/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.processing;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.Resource;

public class AbstractItemProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractItemProcess.class);

    protected String loadQuery(Resource query) {
        InputStream is;
        try {
            is = query.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new Scanner(is, "UTF-8").useDelimiter("\\A").next();
    }

    private Locale currentLocale() {
        Locale current = LocaleContextHolder.getLocale();
        if (current == null) {
            current = Locale.getDefault();
            LOGGER.warn("No locale available from LocaleContextHolder, platform default will be used instead");
        }
        return current;
    }

    protected String convertDatetoString(Date date) {
        return DateFormat.getDateTimeInstance(2, 3, this.currentLocale()).format(date);
    }

    protected String evaluateExpressionToString(Object obj) {
        if (obj instanceof Date) {
            return obj != null ? this.convertDatetoString((Date)obj) : "";
        }
        return obj != null ? obj.toString() : "";
    }

    protected Long evaluateExpressionToLong(Object obj) {
        return Long.valueOf(obj.toString());
    }
}

