/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.testcases.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.osgi.extensions.annotation.ServiceReference;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.query.ReportQuery;
import org.squashtest.tm.api.repository.SqlQueryRunner;
import org.squashtest.tm.plugin.report.foundation.NodeType;
import org.squashtest.tm.plugin.report.foundation.Paragraph;
import org.squashtest.tm.plugin.report.foundation.QueryContext;
import org.squashtest.tm.plugin.report.testcases.query.NodesProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCasesTreeQuery
implements ReportQuery {
    private Resource nodesQuery;
    private Resource allprojectsQuery;
    private Resource projectsQuery;
    private Resource testcasesQuery;
    private Resource testcaseStepsQuery;
    private Resource linkedReqQuery;
    private SqlQueryRunner runner;

    @ServiceReference
    public void setRunner(SqlQueryRunner runner) {
        this.runner = runner;
    }

    public void executeQuery(Map<String, Criteria> crit, Map<String, Object> res) {
        Criteria idsCrit;
        Criteria selectionMode = crit.get("testcasesSelectionMode");
        Criteria options = crit.get("reportOptions");
        NodesProcess nodesprocess = new NodesProcess();
        List<Object> nodesBeans = Collections.emptyList();
        Paragraph paragraphe = new Paragraph();
        QueryContext nodesCtx = new QueryContext();
        HashSet ancestors = new HashSet();
        HashMap<String, Boolean> optionsMap = new HashMap<String, Boolean>();
        optionsMap.put("printSteps", false);
        optionsMap.put("printLinkedRequirements", false);
        Collection selectedOptions = (Collection)options.getValue();
        for (String option : selectedOptions) {
            optionsMap.put(option, true);
        }
        nodesCtx.setReportOptions(optionsMap);
        nodesCtx.setAncestors(ancestors);
        nodesCtx.setRunner(this.runner);
        nodesCtx.setParagraph(paragraphe);
        nodesCtx.put((Object)"nodesQuery", (Object)this.nodesQuery);
        nodesCtx.put((Object)"projectsQuery", (Object)this.projectsQuery);
        nodesCtx.put((Object)"allprojectsQuery", (Object)this.allprojectsQuery);
        nodesCtx.put((Object)"testcasesQuery", (Object)this.testcasesQuery);
        nodesCtx.put((Object)"testcaseStepsQuery", (Object)this.testcaseStepsQuery);
        nodesCtx.put((Object)"linkedReqQuery", (Object)this.linkedReqQuery);
        if ("TREE_PICKER".equals(selectionMode.getValue())) {
            idsCrit = crit.get("testcasesIds");
            if (!idsCrit.getValue().toString().trim().isEmpty()) {
                nodesCtx.setCriteria(this.addNodesIds(idsCrit));
                nodesBeans = nodesprocess.getNodes(nodesCtx, NodeType.NODE);
            }
        } else if ("EVERYTHING".equals(selectionMode.getValue())) {
            Collection tuple = null;
            nodesCtx.setCriteria(tuple);
            nodesBeans = nodesprocess.getNodes(nodesCtx, NodeType.PROJECT);
        } else {
            idsCrit = crit.get("projectIds");
            Collection projectIds = (Collection)idsCrit.getValue();
            if (!projectIds.isEmpty()) {
                nodesCtx.setCriteria(projectIds);
                nodesBeans = nodesprocess.getNodes(nodesCtx, NodeType.PROJECT);
            }
        }
        res.put("data", nodesBeans);
    }

    private Collection addNodesIds(Criteria idsCrit) {
        if (idsCrit != null) {
            Collection ids = ((Map)idsCrit.getValue()).values();
            if (!ids.isEmpty()) {
                HashSet nodesIds = new HashSet();
                nodesIds.addAll(ids);
                return nodesIds;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public void setNodesQuery(Resource nodesQuery) {
        this.nodesQuery = nodesQuery;
    }

    public void setProjectsQuery(Resource projectsQuery) {
        this.projectsQuery = projectsQuery;
    }

    public void setAllprojectsQuery(Resource allprojectsQuery) {
        this.allprojectsQuery = allprojectsQuery;
    }

    public void setTestcasesQuery(Resource testcasesQuery) {
        this.testcasesQuery = testcasesQuery;
    }

    public void setLinkedReqQuery(Resource linkedReqQuery) {
        this.linkedReqQuery = linkedReqQuery;
    }

    public void setTestcaseStepsQuery(Resource testcaseStepsQuery) {
        this.testcaseStepsQuery = testcaseStepsQuery;
    }
}

