/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.testcases.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.io.Resource;
import org.squashtest.tm.internal.domain.report.testcases.beans.TestCaseBean;
import org.squashtest.tm.plugin.report.foundation.QueryContext;
import org.squashtest.tm.plugin.report.processing.AbstractItemProcess;
import org.squashtest.tm.plugin.report.testcases.query.LinkedRequirementsProcess;
import org.squashtest.tm.plugin.report.testcases.query.TestCaseStepsProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCasesProcess
extends AbstractItemProcess {
    private List<TestCaseBean> testCaseBeans;

    public List<TestCaseBean> getTestCases(QueryContext ctx, Long item_id) {
        this.testCaseBeans = new ArrayList<TestCaseBean>();
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("nodeId", item_id);
        List results = ctx.getRunner().executeSelect(this.loadQuery((Resource)ctx.get((Object)"testcasesQuery")), parameters);
        this.convertResultToTestCaseBean(results, ctx);
        return this.testCaseBeans;
    }

    private void convertResultToTestCaseBean(List<Object[]> result, QueryContext ctx) {
        for (Object[] row : result) {
            boolean shouldProcess;
            boolean isFolder = this.evaluateExpressionToLong(row[3]) == 1L;
            Long nodeId = this.evaluateExpressionToLong(row[1]);
            boolean bl = shouldProcess = !isFolder || !ctx.knowsAncestor(nodeId);
            if (!shouldProcess) continue;
            TestCaseBean testcase = new TestCaseBean();
            testcase.setChain(this.evaluateExpressionToString(row[0]));
            testcase.setId(this.evaluateExpressionToLong(row[1]));
            testcase.setFolder(this.evaluateExpressionToLong(row[3]));
            testcase.setName(this.evaluateExpressionToString(row[4]));
            testcase.setLevel(this.evaluateExpressionToLong(row[5]));
            testcase.setImportance(this.evaluateExpressionToString(row[6]));
            testcase.setNature(this.evaluateExpressionToString(row[7]));
            testcase.setType(this.evaluateExpressionToString(row[8]));
            testcase.setStatus(this.evaluateExpressionToString(row[9]));
            testcase.setExecutionMode(this.evaluateExpressionToLong(row[10]));
            testcase.setPrerequisites(this.evaluateExpressionToString(row[11]));
            testcase.setReference(this.evaluateExpressionToString(row[12]));
            testcase.setCreatedOn(this.evaluateExpressionToString(row[13]));
            testcase.setCreatedBy(this.evaluateExpressionToString(row[14]));
            testcase.setLastModifiedOn(this.evaluateExpressionToString(row[15]));
            testcase.setLastModifiedBy(this.evaluateExpressionToString(row[16]));
            testcase.setDescription(this.evaluateExpressionToString(row[17]));
            testcase.setAttachments(this.evaluateExpressionToLong(row[19]));
            testcase.setSortingChain(this.evaluateExpressionToString(row[20]));
            if (testcase.getFolder() == 1L) {
                ctx.getParagraph().calculateParagraphLevel(this.evaluateExpressionToString(row[5]), ctx.getParagraphLevel());
            }
            testcase.setParagraph(ctx.getParagraphLevel());
            if (((Boolean)ctx.getReportOptions().get("printSteps")).booleanValue()) {
                TestCaseStepsProcess tcStepsProcess = new TestCaseStepsProcess();
                testcase.setTcStepsBeans(tcStepsProcess.getSteps(ctx, this.evaluateExpressionToLong(row[1])));
            }
            if (((Boolean)ctx.getReportOptions().get("printLinkedRequirements")).booleanValue()) {
                LinkedRequirementsProcess linkedReq = new LinkedRequirementsProcess();
                testcase.setLinkedRequirements(linkedReq.getLinkedRequirements(ctx, this.evaluateExpressionToLong(row[1])));
            }
            this.testCaseBeans.add(testcase);
            ctx.addAncestor(nodeId);
        }
    }
}

