/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.testcases.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.squashtest.tm.internal.domain.report.testcases.beans.NodeBean;
import org.squashtest.tm.plugin.report.foundation.NodeType;
import org.squashtest.tm.plugin.report.foundation.QueryContext;
import org.squashtest.tm.plugin.report.processing.AbstractItemProcess;
import org.squashtest.tm.plugin.report.testcases.query.TestCasesProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodesProcess
extends AbstractItemProcess {
    private List<NodeBean> nodesBeans;

    public List<NodeBean> getNodes(QueryContext ctx, NodeType type) {
        List<Object[]> results;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (type.equals((Object)NodeType.NODE)) {
            parameters.put("nodesIds", ctx.getCriteria());
            results = this.retreiveResults(ctx, "nodesQuery", parameters);
        } else if (ctx.getCriteria() == null) {
            results = this.retreiveResults(ctx, "allprojectsQuery", parameters);
        } else {
            parameters.put("projectIds", ctx.getCriteria());
            results = this.retreiveResults(ctx, "projectsQuery", parameters);
        }
        if (results.isEmpty()) {
            return Collections.emptyList();
        }
        this.nodesBeans = new ArrayList<NodeBean>();
        this.convertResultToNodeBean(results, ctx);
        return this.nodesBeans;
    }

    private void convertResultToNodeBean(List<Object[]> result, QueryContext ctx) {
        for (Object[] row : result) {
            NodeBean node = new NodeBean();
            node.setProjectId(this.evaluateExpressionToLong(row[0]));
            node.setProjectName(this.evaluateExpressionToString(row[1]));
            node.setItemId(this.evaluateExpressionToLong(row[2]));
            ctx.getParagraph().setCurrentProjectId(node.getProjectId());
            TestCasesProcess reqProcess = new TestCasesProcess();
            node.setTestCasesBeans(reqProcess.getTestCases(ctx, node.getItemId()));
            this.nodesBeans.add(node);
        }
    }

    private List<Object[]> retreiveResults(QueryContext ctx, String queryName, Map<String, Object> params) {
        return ctx.getRunner().executeSelect(this.loadQuery((Resource)ctx.get((Object)queryName)), params);
    }
}

