/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.requirements.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Scanner;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.osgi.extensions.annotation.ServiceReference;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.query.ReportQuery;
import org.squashtest.tm.api.repository.SqlQueryRunner;
import org.squashtest.tm.plugin.report.dto.FolderData;
import org.squashtest.tm.plugin.report.dto.ProjectData;
import org.squashtest.tm.plugin.report.dto.RequirementVersionData;
import org.squashtest.tm.plugin.report.dto.TestCaseData;
import org.squashtest.tm.plugin.report.requirements.query.RequirementTreeQueryFinder;
import org.squashtest.tm.plugin.report.requirements.query.RequirementTreeQueryFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementsTreeQuery
implements ReportQuery,
InitializingBean {
    private static final String REQUIREMENTS_IDS = "requirementsIds";
    private static final String PROJECT_IDS = "projectIds";
    private static final String REQUIREMENTS_SELECTION_MODE = "requirementsSelectionMode";
    private static final String REQUIREMENT_FOLDERS = "requirement-folders";
    private static final String REQUIREMENTS = "requirements";
    private RequirementTreeQueryFinder queryFinder = new RequirementTreeQueryFinder();
    private RequirementTreeQueryFormatter formatter = new RequirementTreeQueryFormatter();
    protected SqlQueryRunner runner;

    @ServiceReference
    public void setRunner(SqlQueryRunner runner) {
        this.runner = runner;
    }

    public void afterPropertiesSet() throws Exception {
        this.queryFinder.setRunner(this.runner);
    }

    public void executeQuery(Map<String, Criteria> crit, Map<String, Object> res) {
        Collection<Long> requirementIds = this.getRequirementIdList(crit);
        Collection<Object[]> rawFolderData = this.queryFinder.getFoldersDataForReqIds(requirementIds);
        Collection<Object[]> rawProjectData = this.queryFinder.getProjectDataForReqIds(requirementIds);
        Collection<Object[]> rawReqVersionData = this.queryFinder.getReqVersionsDataForReqIds(requirementIds);
        Collection<Object[]> rawBoundTCData = this.queryFinder.getTestCasesDataForReqIds(requirementIds);
        Collection<ProjectData> projectDataList = this.formatter.toProjectData(rawProjectData);
        Collection<FolderData> folderDataList = this.formatter.toFolderData(projectDataList, rawFolderData);
        Collection<TestCaseData> testCaseDataList = this.formatter.toTestCaseData(rawBoundTCData);
        Collection<RequirementVersionData> versionDataList = this.formatter.toRequirementVersionData(rawReqVersionData);
        this.formatter.bindAllData(projectDataList, folderDataList, versionDataList, testCaseDataList);
        res.put("data", projectDataList);
    }

    public void setIdsByProjectQuery(Resource idsByProjectQuery) {
        String query = this.loadQuery(idsByProjectQuery);
        this.queryFinder.setIdsByProjectQuery(query);
    }

    public void setIdsForAllProjectsQuery(Resource idsForAllProjectsQuery) {
        String query = this.loadQuery(idsForAllProjectsQuery);
        this.queryFinder.setIdsForAllProjectsQuery(query);
    }

    public void setIdsBySelectionQuery(Resource idsBySelectionQuery) {
        String query = this.loadQuery(idsBySelectionQuery);
        this.queryFinder.setIdsBySelectionQuery(query);
    }

    public void setRequirementVersionDataQuery(Resource requirementVersionDataQuery) {
        String query = this.loadQuery(requirementVersionDataQuery);
        this.queryFinder.setRequirementVersionDataQuery(query);
    }

    public void setFolderDataQuery(Resource folderDataQuery) {
        String query = this.loadQuery(folderDataQuery);
        this.queryFinder.setFolderDataQuery(query);
    }

    public void setProjectDataQuery(Resource projectDataQuery) {
        String query = this.loadQuery(projectDataQuery);
        this.queryFinder.setProjectDataQuery(query);
    }

    public void setBoundTCDataQuery(Resource boundTCDataQuery) {
        String query = this.loadQuery(boundTCDataQuery);
        this.queryFinder.setBoundTCDataQuery(query);
    }

    protected SqlQueryRunner getRunner() {
        return this.runner;
    }

    private Collection<Long> getRequirementIdList(Map<String, Criteria> criteriaMap) {
        Collection<Long> requirementIdList;
        Criteria selectionMode = criteriaMap.get(REQUIREMENTS_SELECTION_MODE);
        if ("PROJECT_PICKER".equals(selectionMode.getValue())) {
            Criteria criteria = criteriaMap.get(PROJECT_IDS);
            Collection projectIds = (Collection)criteria.getValue();
            requirementIdList = this.queryFinder.findIdsByProject(projectIds);
        } else if ("EVERYTHING".equals(selectionMode.getValue())) {
            requirementIdList = this.queryFinder.findIdsByProject(null);
        } else {
            Criteria criteria = criteriaMap.get(REQUIREMENTS_IDS);
            Map selectedIds = (Map)criteria.getValue();
            Collection projectIds = (Collection)selectedIds.get(REQUIREMENT_FOLDERS);
            Collection reqStrIds = (Collection)selectedIds.get(REQUIREMENTS);
            requirementIdList = this.queryFinder.findIdsBySelection(projectIds, reqStrIds);
        }
        return requirementIdList;
    }

    protected String loadQuery(Resource query) {
        InputStream is;
        try {
            is = query.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new Scanner(is, "UTF-8").useDelimiter("\\A").next();
    }
}

