/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.requirements.query;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import org.squashtest.tm.plugin.report.dto.FolderData;
import org.squashtest.tm.plugin.report.dto.ProjectData;
import org.squashtest.tm.plugin.report.dto.RequirementVersionData;
import org.squashtest.tm.plugin.report.dto.TestCaseData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementTreeQueryFormatter {
    Collection<ProjectData> toProjectData(Collection<Object[]> tuples) {
        Konvertor konvertor = new Konvertor();
        ArrayList<ProjectData> result = new ArrayList<ProjectData>(tuples.size());
        for (Object[] array : tuples) {
            ProjectData newData = new ProjectData();
            Long id = konvertor.from(array[0]).toLong();
            String name = konvertor.from(array[1]).toString();
            newData.setId(id);
            newData.setName(name);
            result.add(newData);
        }
        return result;
    }

    Collection<FolderData> toFolderData(Collection<ProjectData> projects, Collection<Object[]> tuples) {
        FolderData newData;
        Konvertor konvertor = new Konvertor();
        ArrayList<FolderData> result = new ArrayList<FolderData>();
        for (Object[] array : tuples) {
            newData = new FolderData();
            Long ancestorId = konvertor.from(array[0]).toLong();
            Long folderId = konvertor.from(array[1]).toLong();
            Long projectId = konvertor.from(array[2]).toLong();
            String name = konvertor.from(array[3]).toString();
            String description = konvertor.from(array[4]).toString();
            newData.setAncestorId(ancestorId);
            newData.setFolderId(folderId);
            newData.setProjectId(projectId);
            newData.setName(name);
            newData.setDescription(description);
            result.add(newData);
        }
        for (ProjectData project : projects) {
            newData = new FolderData();
            newData.setProjectId(project.getId());
            newData.setPseudoRoot(true);
            result.add(newData);
        }
        return result;
    }

    Collection<TestCaseData> toTestCaseData(Collection<Object[]> tuples) {
        Konvertor konvertor = new Konvertor();
        ArrayList<TestCaseData> result = new ArrayList<TestCaseData>();
        for (Object[] array : tuples) {
            TestCaseData data = new TestCaseData();
            String projectName = konvertor.from(array[0]).toString();
            String testCaseName = konvertor.from(array[1]).toString();
            String importance = konvertor.from(array[2]).toString();
            Long requirementVersionId = konvertor.from(array[3]).toLong();
            String reference = konvertor.from(array[4]).toString();
            data.setProjectName(projectName);
            data.setName(testCaseName);
            data.setImportance(importance);
            data.setRequirementVersionId(requirementVersionId);
            data.setReference(reference);
            result.add(data);
        }
        return result;
    }

    Collection<RequirementVersionData> toRequirementVersionData(Collection<Object[]> tuples) {
        Konvertor konvertor = new Konvertor();
        LinkedList<RequirementVersionData> result = new LinkedList<RequirementVersionData>();
        for (Object[] array : tuples) {
            RequirementVersionData newData = new RequirementVersionData();
            Long folderId = konvertor.from(array[0]).toLong();
            Long projectId = konvertor.from(array[1]).toLong();
            Long versionId = konvertor.from(array[2]).toLong();
            Long requirementId = konvertor.from(array[3]).toLong();
            String reference = konvertor.from(array[4]).toString();
            int versionNumber = konvertor.from(array[5]).toInt();
            String criticality = konvertor.from(array[6]).toString();
            String status = konvertor.from(array[7]).toString();
            String category = konvertor.from(array[8]).toString();
            int nbAttachs = konvertor.from(array[9]).toInt();
            String name = konvertor.from(array[10]).toString();
            String description = konvertor.from(array[11]).toString();
            String createdBy = konvertor.from(array[12]).toString();
            Date createdOn = konvertor.from(array[13]).toDate();
            String modifiedBy = konvertor.from(array[14]).toString();
            Date modifiedOn = konvertor.from(array[15]).toDate();
            Integer totalVersionNumber = konvertor.from(array[16]).toInt();
            newData.setParentFolderId(folderId);
            newData.setProjectId(projectId);
            newData.setVersionId(versionId);
            newData.setRequirementId(requirementId);
            newData.setReference(reference);
            newData.setVersionNumber(versionNumber);
            newData.setCriticality(criticality);
            newData.setStatus(status);
            newData.setCategory(category);
            newData.setNbAttachments(nbAttachs);
            newData.setName(name);
            newData.setDescription(description);
            newData.setCreatedBy(createdBy);
            newData.setCreatedOn(createdOn);
            newData.setModifiedBy(modifiedBy);
            newData.setModifiedOn(modifiedOn);
            newData.setTotalVersionNumber(totalVersionNumber);
            result.add(newData);
        }
        return result;
    }

    void bindAllData(Collection<ProjectData> projects, Collection<FolderData> folders, Collection<RequirementVersionData> versionData, Collection<TestCaseData> tcData) {
        this._bindTestCases(versionData, tcData);
        this._bindRequirements(folders, versionData);
        this._buildFolderHierarchy(folders);
        this._bindFolders(projects, folders);
    }

    private void _bindTestCases(Collection<RequirementVersionData> versionData, Collection<TestCaseData> testCaseData) {
        for (RequirementVersionData version : versionData) {
            Iterator<TestCaseData> iterator = testCaseData.iterator();
            while (iterator.hasNext()) {
                TestCaseData next = iterator.next();
                if (!version.acceptsAsContent(next)) continue;
                version.addTestCase(next);
                iterator.remove();
            }
            version.sortContent();
        }
    }

    private void _bindRequirements(Collection<FolderData> folderData, Collection<RequirementVersionData> versionData) {
        for (FolderData folder : folderData) {
            Iterator<RequirementVersionData> iterator = versionData.iterator();
            while (iterator.hasNext()) {
                RequirementVersionData version = iterator.next();
                if (!folder.acceptsAsContent(version)) continue;
                folder.addContent(version);
                iterator.remove();
            }
        }
    }

    private void _buildFolderHierarchy(Collection<FolderData> data) {
        if (data.isEmpty()) {
            return;
        }
        LinkedList<FolderData> nonTreatedFolders = new LinkedList<FolderData>();
        nonTreatedFolders.addAll(data);
        LinkedList<FolderData> beingProcessed = this._findPseudoRoot(data);
        FolderData underProcess = beingProcessed.removeFirst();
        while (underProcess != null) {
            Iterator iterator = nonTreatedFolders.iterator();
            while (iterator.hasNext()) {
                FolderData folder = (FolderData)iterator.next();
                if (folder == underProcess) {
                    iterator.remove();
                    continue;
                }
                if (!underProcess.acceptsAsContent(folder)) continue;
                folder.setParent(underProcess);
                underProcess.addContent(folder);
                beingProcessed.add(folder);
                iterator.remove();
            }
            underProcess.sortContent();
            FolderData folderData = underProcess = beingProcessed.isEmpty() ? null : beingProcessed.removeFirst();
        }
    }

    private void _bindFolders(Collection<ProjectData> projects, Collection<FolderData> folders) {
        for (ProjectData project : projects) {
            for (FolderData folder : folders) {
                if (!project.acceptsAsContent(folder)) continue;
                project.addFolder(folder);
            }
        }
    }

    private LinkedList<FolderData> _findPseudoRoot(Collection<FolderData> data) {
        LinkedList<FolderData> pseudoRoots = new LinkedList<FolderData>();
        for (FolderData folder : data) {
            if (!folder.isPseudoRoot()) continue;
            pseudoRoots.add(folder);
        }
        return pseudoRoots;
    }

    private class Konvertor {
        private Object object;

        private Konvertor() {
        }

        Konvertor from(Object toConvert) {
            this.object = toConvert;
            return this;
        }

        public String toString() {
            if (this.object == null) {
                return null;
            }
            return this.object.toString();
        }

        public Long toLong() {
            if (this.object == null) {
                return null;
            }
            Class<?> clazz = this.object.getClass();
            Long result = clazz.equals(String.class) ? Long.valueOf((String)this.object) : (clazz.equals(BigInteger.class) ? Long.valueOf(((BigInteger)this.object).longValue()) : (clazz.equals(Long.class) ? (Long)this.object : (clazz.equals(Integer.class) ? Long.valueOf(((Integer)this.object).longValue()) : (clazz.equals(Timestamp.class) ? Long.valueOf(((Timestamp)this.object).getTime()) : (clazz.equals(Date.class) ? Long.valueOf(((Date)this.object).getTime()) : Long.valueOf(this.object.toString()))))));
            return result;
        }

        public Date toDate() {
            if (this.object == null) {
                return null;
            }
            Class<?> clazz = this.object.getClass();
            Date result = clazz.equals(Date.class) ? (Date)this.object : new Date(this.toLong());
            return result;
        }

        public Integer toInt() {
            if (this.object == null) {
                return null;
            }
            Class<?> clazz = this.object.getClass();
            Integer result = clazz.equals(Integer.class) ? (Integer)this.object : Integer.valueOf(this.toString());
            return result;
        }
    }
}

