/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.requirements.query;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.squashtest.tm.api.repository.SqlQueryRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementTreeQueryFinder {
    private String idsByProjectQuery;
    private String idsForAllProjectsQuery;
    private String idsBySelectionQuery;
    private String requirementVersionDataQuery;
    private String folderDataQuery;
    private String projectDataQuery;
    private String boundTCDataQuery;
    protected SqlQueryRunner runner;

    RequirementTreeQueryFinder() {
    }

    void setIdsForAllProjectsQuery(String idsForAllProjectsQuery) {
        this.idsForAllProjectsQuery = idsForAllProjectsQuery;
    }

    void setIdsByProjectQuery(String idsByProjectQuery) {
        this.idsByProjectQuery = idsByProjectQuery;
    }

    void setIdsBySelectionQuery(String idsBySelectionQuery) {
        this.idsBySelectionQuery = idsBySelectionQuery;
    }

    void setRequirementVersionDataQuery(String requirementVersionDataQuery) {
        this.requirementVersionDataQuery = requirementVersionDataQuery;
    }

    void setFolderDataQuery(String folderDataQuery) {
        this.folderDataQuery = folderDataQuery;
    }

    void setProjectDataQuery(String projectDataQuery) {
        this.projectDataQuery = projectDataQuery;
    }

    void setBoundTCDataQuery(String boundTCDataQuery) {
        this.boundTCDataQuery = boundTCDataQuery;
    }

    void setRunner(SqlQueryRunner runner) {
        this.runner = runner;
    }

    Collection<Long> findIdsByProject(Collection<String> projectStrIds) {
        if (projectStrIds == null) {
            HashMap params = new HashMap();
            List foundStrIds = this.runner.executeSelect(this.idsForAllProjectsQuery, params);
            return this.toIdList(foundStrIds);
        }
        if (projectStrIds.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<Long> projectIds = this.toIdList(projectStrIds);
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>(1);
        params.put("projectIds", projectIds);
        List foundStrIds = this.runner.executeSelect(this.idsByProjectQuery, params);
        return this.toIdList(foundStrIds);
    }

    Collection<Long> findIdsBySelection(Collection<String> folderIds, Collection<String> reqIds) {
        LinkedList<Long> requirementIdList = new LinkedList<Long>();
        if (folderIds != null && !folderIds.isEmpty()) {
            HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>(1);
            params.put("folderIds", this.toIdList(folderIds));
            List foundStrIds = this.runner.executeSelect(this.idsBySelectionQuery, params);
            requirementIdList.addAll(this.toIdList(foundStrIds));
        }
        if (reqIds != null) {
            requirementIdList.addAll(this.toIdList(reqIds));
        }
        return requirementIdList;
    }

    Collection<Object[]> getReqVersionsDataForReqIds(Collection<Long> requirementIds) {
        return this.execute(this.requirementVersionDataQuery, "requirementIds", requirementIds);
    }

    Collection<Object[]> getTestCasesDataForReqIds(Collection<Long> requirementIds) {
        return this.execute(this.boundTCDataQuery, "requirementIds", requirementIds);
    }

    Collection<Object[]> getFoldersDataForReqIds(Collection<Long> requirementIds) {
        return this.execute(this.folderDataQuery, "requirementIds", requirementIds);
    }

    Collection<Object[]> getProjectDataForReqIds(Collection<Long> requirementIds) {
        return this.execute(this.projectDataQuery, "requirementIds", requirementIds);
    }

    private Collection<Object[]> execute(String query, String paramName, Collection<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>(1);
        params.put(paramName, ids);
        return this.runner.executeSelect(query, params);
    }

    protected Collection<Long> toIdList(Collection<?> ids) {
        return CollectionUtils.collect(ids, (Transformer)new IdTransformer());
    }

    private static class IdTransformer
    implements Transformer {
        private IdTransformer() {
        }

        public Object transform(Object arg0) {
            Class<?> argClass = arg0.getClass();
            if (argClass.equals(String.class)) {
                return Long.valueOf((String)arg0);
            }
            if (argClass.equals(BigInteger.class)) {
                return ((BigInteger)arg0).longValue();
            }
            throw new RuntimeException("bug : IdTransformer cannto convert items of class " + argClass.getName());
        }
    }
}

