/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.dto;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.squashtest.tm.plugin.report.dto.TestCaseData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementVersionData {
    private Long parentFolderId;
    private Long projectId;
    private Long versionId;
    private Long requirementId;
    private String reference;
    private int versionNumber;
    private String criticality;
    private String status;
    private String category;
    private int nbAttachments;
    private String name;
    private String description;
    private String createdBy;
    private Date createdOn;
    private String modifiedBy;
    private Date modifiedOn;
    private int totalVersionNumber;
    private List<TestCaseData> boundTestCases = new LinkedList<TestCaseData>();

    public Long getParentFolderId() {
        return this.parentFolderId;
    }

    public void setParentFolderId(Long parentFolderId) {
        this.parentFolderId = parentFolderId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public Long getRequirementId() {
        return this.requirementId;
    }

    public void setRequirementId(Long requirementId) {
        this.requirementId = requirementId;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Integer getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(int versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String getCriticality() {
        return this.criticality;
    }

    public void setCriticality(String criticality) {
        this.criticality = criticality;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public int getNbAttachments() {
        return this.nbAttachments;
    }

    public void setNbAttachments(int nbAttachments) {
        this.nbAttachments = nbAttachments;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Date getModifiedOn() {
        return this.modifiedOn;
    }

    public void setModifiedOn(Date modifuedOn) {
        this.modifiedOn = modifuedOn;
    }

    public Collection<TestCaseData> getBoundTestCases() {
        return this.boundTestCases;
    }

    public void setBoundTestCases(List<TestCaseData> boundTestCases) {
        this.boundTestCases = boundTestCases;
    }

    public void addAllTestCases(Collection<TestCaseData> data) {
        this.boundTestCases.addAll(data);
    }

    public void addTestCase(TestCaseData data) {
        this.boundTestCases.add(data);
    }

    public int getTotalVersionNumber() {
        return this.totalVersionNumber;
    }

    public void setTotalVersionNumber(int totalVersionNumber) {
        this.totalVersionNumber = totalVersionNumber;
    }

    public boolean hasAttachments() {
        return this.nbAttachments > 0;
    }

    public boolean hasParentFolder() {
        return this.parentFolderId != null;
    }

    public boolean acceptsAsContent(TestCaseData testCase) {
        return testCase.getRequirementVersionId().equals(this.versionId);
    }

    public void sortContent() {
        Collections.sort(this.boundTestCases, new TestCaseSorter());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestCaseSorter
    implements Comparator<TestCaseData> {
        private TestCaseSorter() {
        }

        @Override
        public int compare(TestCaseData tc1, TestCaseData tc2) {
            String name1 = this.normalizeName(tc1);
            String name2 = this.normalizeName(tc2);
            return name1.compareTo(name2);
        }

        private String normalizeName(TestCaseData data) {
            if (StringUtils.isNotBlank((String)data.getReference())) {
                return String.valueOf(data.getReference()) + " - " + data.getName();
            }
            return data.getName();
        }
    }
}

