/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.dto;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.squashtest.tm.plugin.report.dto.FolderData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectData {
    private String name;
    private Long id;
    private Collection<FolderData> folders = new TreeSet<FolderData>(new BreadcrumbComparator());

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Collection<FolderData> getFolders() {
        return this.folders;
    }

    public void setFolders(List<FolderData> folders) {
        this.folders = folders;
    }

    public void addAllFolders(Collection<FolderData> moreFolders) {
        this.folders.addAll(moreFolders);
    }

    public void addFolder(FolderData folder) {
        this.folders.add(folder);
    }

    public boolean acceptsAsContent(FolderData folder) {
        return folder.getProjectId().equals(this.id);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BreadcrumbComparator
    implements Comparator<FolderData> {
        private BreadcrumbComparator() {
        }

        @Override
        public int compare(FolderData folder1, FolderData folder2) {
            int result = this.compareByBeingRoot(folder1, folder2);
            if (result != 0) {
                return result;
            }
            return this.compareBreadcrumbs(folder1, folder2);
        }

        private int compareByBeingRoot(FolderData folder1, FolderData folder2) {
            if (folder1.isPseudoRoot()) {
                return -1;
            }
            if (folder2.isPseudoRoot()) {
                return 1;
            }
            return 0;
        }

        private int compareBreadcrumbs(FolderData folder1, FolderData folder2) {
            String[] crumb1 = folder1.getBreadcrumb().split(" > ");
            String[] crumb2 = folder2.getBreadcrumb().split(" > ");
            int minLength = Math.min(crumb1.length, crumb2.length);
            int i = 0;
            while (i < minLength) {
                int comp = crumb1[i].compareTo(crumb2[i]);
                if (comp != 0) {
                    return comp;
                }
                ++i;
            }
            return crumb1.length < crumb2.length ? -1 : 1;
        }
    }
}

