/*
 *     This file is part of the Jira Agile synchronization connector for Squash TM (plugin.requirement.xsquash4jira) project.
 *     Copyright (C) 2017 - 2018 Henix, henix.fr - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
/*
 Common utilities for the tables in this wizard

*/


define(["jquery", "squash.translator", "workspace.routing", "datatables", "squashtable/squashtable.pagination"], 
		function($, translator, routing){
	
	// prefetch the labels
	// attribute naming convention is different for the new datatable
	// (no more hungarian notation) so I redeclare it here
	translator.load({
		'lengthMenu' : 'generics.datatable.lengthMenu',
		'zeroRecords' : 'generics.datatable.zeroRecords',
		'info' : 'generics.datatable.info',
		'infoEmpty' : 'generics.datatable.infoEmpty',
		'infoFiltered' : 'generics.datatable.infoFiltered',
		'search' : 'generics.datatable.search',
		'paginage' : {
			'first' : 'generics.datatable.paginate.first',
			'previous' : 'generics.datatable.paginate.previous',
			'next' : 'generics.datatable.paginate.next',
			'last' : 'generics.datatable.paginate.last'
		}
	})
	
	
	// helper functions
	function mklink(urlname, idparam, text){
		var url = routing.buildURL(urlname, idparam);
		return '<a href="'+url+'" target="_blank">'+text+'</a>';
	}
	

	return {
	
		language : translator.get({
			'lengthMenu' : 'generics.datatable.lengthMenu',
			'zeroRecords' : 'generics.datatable.zeroRecords',
			'info' : 'generics.datatable.info',
			'infoEmpty' : 'generics.datatable.infoEmpty',
			'infoFiltered' : 'generics.datatable.infoFiltered',
			'search' : 'generics.datatable.search',
			'paginage' : {
				'first' : 'generics.datatable.paginate.first',
				'previous' : 'generics.datatable.paginate.previous',
				'next' : 'generics.datatable.paginate.next',
				'last' : 'generics.datatable.paginate.last'
			}
		}),
		
		asTcLink : function(tc){
			var fullname = (!!tc.reference) ? tc.reference + " - "+tc.name : tc.name;
			return mklink('testcases.info', tc.id, fullname);
		},
		
		asReqLink : function(req){
			return mklink('requirementversions.info', req.id, req.reference);
		},
		
		asBugLink : function(bug){
			return '<a href="'+bug.browseUrl+'" target="_blank">'+bug.key+'</a>';
		}
		
			
	};
	
	
});