/*
 *     This file is part of the Jira Agile synchronization connector for Squash TM (plugin.requirement.xsquash4jira) project.
 *     Copyright (C) 2017 - 2018 Henix, henix.fr - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
define(["./BaseModel", "./BaseScreen"], function(BaseModel, BaseScreen){
	
	
	
	// *************** population strategy model ****************

	var StrategyModel = BaseModel.extend({
		
		produces : ['strategy'],
		
		defaults : {
			strategy : "BY_RELEASE"
		}
	});
	
	
	// ***** Execplan population strategy selection **********

	var StrategyScreen = BaseScreen.extend({
		
		name : "strategy",
		
		el : "#screen-strategy",
		
		template : "#jirsync-plan-popstrategy-template",

		templateModel : function(){
			return {
				radiocheck : this.model.strategy()
			};
		},
		
		events : {
			'change input[type="radio"]' : "setStrategy"
		},
		
		setStrategy : function(evt){
			var value = $(evt.currentTarget).val();
			this.model.strategy(value);
		}
		
	});

	
	return {
		model : StrategyModel,
		screen : StrategyScreen
	};
	
	
});