/*
 *     This file is part of the Jira Agile synchronization connector for Squash TM (plugin.requirement.xsquash4jira) project.
 *     Copyright (C) 2017 - 2018 Henix, henix.fr - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
/*
 * This Mixin can be mixed into a view to offer support 
 * for hash-based model event declaration, which works 
 * like the 'event' hash of native Backbone.
 * 
 * The name of the model attribute can be given as a fully 
 * qualified path if you use Backbone models nested in other 
 * models.
 *  
 *   
 * example : 
 * {
 * 	'change:action : 'handleName',
 * 	'change:selectedNode.type'  : 'handlerFunction'
 * }
 *   
 * 
 */

define([], function(){
	
	var ModelEventMixin = {
			
		bindModelEvents : function(){
			
			for (origEvt in this.modelEvents){
				
				var evtAndPpt = origEvt.split(':');
				
				// look up the event
				var event = evtAndPpt[0];
				
				// walk down the model path
				var path = evtAndPpt[1].split('.');
				var model = this.model;
				for (var i=0; i< path.length-1; i++){
					var ppt = path[i];
					if (model.hasOwnProperty(ppt)){
						if (_.isFunction(model[ppt])){
							// this leverages the extra accessors generated 
							// for the models, see BaseModel in the model definitions
							model = model[ppt]();
						}
						else{
							model = model.ppt;
						}
					}
				}
				
				// look up the property itelf (last element of the path)
				var property = path[path.length-1];
				
				// now look up the handler
				var handlerName = this.modelEvents[origEvt]; 
				var handler = this[handlerName];
				
				// bind
				this.listenTo(model, event+':'+property, handler);
			}
		}
	};
	
	return ModelEventMixin;
});