/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service.execplan;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.plugin.jirasync.controller.execplan.IterationFormMetadata;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanSpecification;
import org.squashtest.tm.plugin.jirasync.service.execplan.ExecplanSynchronizationDao;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.campaign.CampaignTestPlanManagerService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.internal.dto.CustomFieldJsonConverter;
import org.squashtest.tm.service.internal.dto.CustomFieldModel;

@Service(value="squash.tm.plugin.jirasync.explanTestplanService")
@Transactional
class ExecplanTestplanService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecplanTestplanService.class);
    @Inject
    private ExecplanSynchronizationDao dao;
    @Inject
    private CampaignLibraryNavigationService cpgService;
    @Inject
    private CampaignTestPlanManagerService cpgTestPlanService;
    @Inject
    private IterationTestPlanManagerService itTestPlanService;
    @Inject
    private CustomFieldJsonConverter jsonCufConverter;

    ExecplanTestplanService() {
    }

    void updateCampaignTestPlan(ExecplanSpecification specification) {
        if (specification.getAction() != ExecplanSpecification.Action.UPDATE_CPG) {
            throw new RuntimeException("programming error : called service 'updateCampaignTestPlan' but the test plan specification indicates the desired operation is " + (Object)((Object)specification.getAction()));
        }
        Long cpgId = specification.getTarget().getId();
        List<Long> newTcIds = specification.getTestCaseIds();
        LOGGER.debug("updating test plan for campaign {}", (Object)cpgId);
        LOGGER.trace("test plan will contain test cases : {}", newTcIds);
        Collection<Long> alreadyPlanned = this.dao.findTestCasesAlreadyPlannedInCampaign(cpgId);
        LOGGER.trace("discarding test cases that are already planned : {}", alreadyPlanned);
        newTcIds.removeAll(alreadyPlanned);
        LOGGER.trace("planning test cases : {}", newTcIds);
        this.cpgTestPlanService.addTestCasesToCampaignTestPlan(newTcIds, cpgId.longValue());
        LOGGER.trace("done");
    }

    void updateIterationTestPlan(ExecplanSpecification specification) {
        if (specification.getAction() != ExecplanSpecification.Action.UPDATE_IT) {
            throw new RuntimeException("programming error : called service 'updateIterationTestPlan' but the test plan specification indicates the desired operation is " + (Object)((Object)specification.getAction()));
        }
        Long iterId = specification.getTarget().getId();
        List<Long> newTcIds = specification.getTestCaseIds();
        LOGGER.debug("updating test plan for iteration {}", (Object)iterId);
        LOGGER.trace("test plan will contain test cases : {}", newTcIds);
        Collection<Long> alreadyPlanned = this.dao.findTestCasesAlreadyPlannedInIteration(iterId);
        LOGGER.trace("discarding test cases that are already planned : {}", alreadyPlanned);
        newTcIds.removeAll(alreadyPlanned);
        LOGGER.trace("planning test cases : {}", newTcIds);
        this.itTestPlanService.addTestCasesToIteration(newTcIds, iterId.longValue());
        LOGGER.trace("done");
    }

    Iteration createIteration(ExecplanSpecification specification) {
        if (specification.getAction() != ExecplanSpecification.Action.CREATE_IT) {
            throw new IllegalArgumentException("programming error : called service 'createIteration' but the test plan specification indicates the desired operation is " + (Object)((Object)specification.getAction()));
        }
        LOGGER.debug("creating iteration {} into campaign {}", (Object)specification.getIteration().getName(), (Object)specification.getTarget().getId());
        LOGGER.trace("test plan will contain test cases : {}", specification.getTestCaseIds());
        Iteration iteration = specification.getIteration().getIteration();
        Map customFields = specification.getIteration().getCufs();
        this.cpgService.addIterationToCampaign(iteration, specification.getTarget().getId().longValue(), false, customFields);
        LOGGER.trace("iteration created");
        this.itTestPlanService.addTestCasesToIteration(specification.getTestCaseIds(), iteration.getId().longValue());
        LOGGER.trace("test plan complete, task done");
        return iteration;
    }

    IterationFormMetadata getIterationMetadata(Long campaignId) {
        LOGGER.debug("looking for required metadata in order to create an iteration for campaign {}", (Object)campaignId);
        List<String> siblingNames = this.dao.findIterationNamesForCampaign(campaignId);
        LOGGER.trace("sibling iteration names : {}", siblingNames);
        List<CustomField> cufs = this.dao.findIterationCutomfieldsForCampaign(campaignId);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("found custom fields : {}", cufs.stream().map(c -> c.getCode()).collect(Collectors.toList()));
        }
        List<CustomFieldModel<?>> jsonCufs = cufs.stream().map(cf -> this.jsonCufConverter.toJson(cf)).collect(Collectors.toList());
        return new IterationFormMetadata(siblingNames, jsonCufs);
    }
}

