/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service.execplan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanIssue;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanRequirement;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanTestCase;
import org.squashtest.tm.plugin.jirasync.service.execplan.ExecplanIssuePartition;
import org.squashtest.tm.plugin.jirasync.service.execplan.ExecplanSynchronizationDao;

@Service(value="squash.tm.plugin.jirasync.explanTestcaseService")
@Transactional(readOnly=false)
class ExecplanTestCaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecplanTestCaseService.class);
    @Inject
    private ExecplanSynchronizationDao dao;

    ExecplanTestCaseService() {
    }

    List<ExecplanTestCase> findTestCasesForIssues(Collection<ExecplanIssue> fromJira) {
        LOGGER.debug("retrieving relevant test cases related to the jira issues");
        ExecplanIssuePartition partition = this.partitionJiraIssues(fromJira);
        List<ExecplanTestCase> featureTestcases = this.loadTestCasesCoveringFeatures(partition);
        List<ExecplanTestCase> bugfixTestcases = this.loadTestCasesFixedBy(partition);
        List<ExecplanTestCase> result = this.mergeTestCases(featureTestcases, bugfixTestcases);
        return result;
    }

    ExecplanIssuePartition partitionJiraIssues(Collection<ExecplanIssue> fromJira) {
        List<String> jiraKeys = fromJira.stream().map(ExecplanIssue::getKey).collect(Collectors.toList());
        LOGGER.debug("partitioning jira issues : {}", jiraKeys);
        Set<String> features = this.dao.filterFeatures(jiraKeys);
        Set<String> bugs = this.dao.filterBugfixes(jiraKeys);
        Set<String> covered = this.dao.filterCoveredFeatures(jiraKeys);
        ExecplanIssuePartition partition = new ExecplanIssuePartition();
        for (ExecplanIssue jiraIssue : fromJira) {
            boolean related = false;
            String key = jiraIssue.getKey();
            jiraIssue.resetSyncFlags();
            if (features.contains(key)) {
                related = true;
                partition.addFeature(jiraIssue);
                jiraIssue.setSyncedAsFeature(Boolean.TRUE);
            }
            if (bugs.contains(key)) {
                related = true;
                partition.addBugfix(jiraIssue);
                jiraIssue.setSyncedAsIssue(Boolean.TRUE);
            }
            if (covered.contains(key)) {
                related = true;
                partition.addCoveredFeature(jiraIssue);
                jiraIssue.setFeatureIsCovered(Boolean.TRUE);
            }
            if (related) continue;
            partition.addUnrelated(jiraIssue);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("done partitioning");
            LOGGER.debug(partition.log());
        }
        return partition;
    }

    private List<ExecplanTestCase> loadTestCasesCoveringFeatures(ExecplanIssuePartition partition) {
        Set<String> featureKeys = partition.getCoveredFeatureKeys();
        LOGGER.debug("retrieving test cases from the database from the database covered by shipped features : {}", featureKeys);
        List<ExecplanTestCase> featureTestcases = this.dao.findTestCasesCoveringFeatures(featureKeys);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("retrieved feature test cases : {}", featureTestcases.stream().map(tc -> tc.getId()).collect(Collectors.toList()));
        }
        for (ExecplanTestCase testCase : featureTestcases) {
            for (ExecplanRequirement req : testCase.getRequirements()) {
                ExecplanIssue iss = partition.getFeature(req.getRemoteKey());
                if (iss != null) {
                    req.setStatus(iss.getStatus());
                    continue;
                }
                this.logIssueIsUnknown(testCase, iss);
            }
        }
        return featureTestcases;
    }

    private List<ExecplanTestCase> loadTestCasesFixedBy(ExecplanIssuePartition partition) {
        Set<String> fixKeys = partition.getBugfixeKeys();
        LOGGER.debug("retrieving test cases from the database from the database covered by shipped bugfixes : {}", fixKeys);
        List<ExecplanTestCase> fixTestcases = this.dao.findTestCasesFixedBy(partition.getBugfixeKeys());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("retrieved fixed test cases : {}", fixTestcases.stream().map(tc -> tc.getId()).collect(Collectors.toList()));
        }
        for (ExecplanTestCase testCase : fixTestcases) {
            for (ExecplanIssue sqIssue : testCase.getIssues()) {
                ExecplanIssue fromJira = partition.getBugfix(sqIssue.getKey());
                if (fromJira != null) {
                    sqIssue.mergeWith(fromJira);
                    continue;
                }
                this.logIssueIsUnknown(testCase, sqIssue);
            }
        }
        return fixTestcases;
    }

    private List<ExecplanTestCase> mergeTestCases(Collection<ExecplanTestCase> listA, Collection<ExecplanTestCase> listB) {
        if (listA.isEmpty() && listB.isEmpty()) {
            LOGGER.debug("no test cases to merge");
            return Collections.emptyList();
        }
        LOGGER.debug("merging the test cases in a single model");
        ArrayList<ExecplanTestCase> allTestcases = new ArrayList<ExecplanTestCase>(listA.size() + listB.size());
        allTestcases.addAll(listA);
        allTestcases.addAll(listB);
        Collections.sort(allTestcases, (tc1, tc2) -> tc1.getId() < tc2.getId() ? -1 : 1);
        Iterator iterator = allTestcases.iterator();
        ExecplanTestCase previous = (ExecplanTestCase)iterator.next();
        while (iterator.hasNext()) {
            ExecplanTestCase current = (ExecplanTestCase)iterator.next();
            if (current.equals(previous)) {
                LOGGER.trace("test case {} present both as a feature and an issue : merging", (Object)current.getId());
                previous.mergeWith(current);
                iterator.remove();
                continue;
            }
            previous = current;
        }
        LOGGER.debug("done");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("final test case collection (after merge) is : {}", allTestcases.stream().map(ExecplanTestCase::getId).collect(Collectors.toList()));
        }
        return allTestcases;
    }

    private void logIssueIsUnknown(ExecplanTestCase testCase, ExecplanIssue sqIssue) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("test case '{}' reported that it's affected by issue '{}', which could not be found in the original set of JIRA issues", (Object)testCase.getId(), (Object)sqIssue.getKey());
        }
    }
}

