/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service.execplan;

import com.querydsl.core.group.GroupBy;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.hibernate.HibernateQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.csp.core.bugtracker.domain.QBugTracker;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.bugtracker.QIssue;
import org.squashtest.tm.domain.campaign.QCampaign;
import org.squashtest.tm.domain.campaign.QCampaignTestPlanItem;
import org.squashtest.tm.domain.campaign.QIteration;
import org.squashtest.tm.domain.campaign.QIterationTestPlanItem;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.execution.QExecution;
import org.squashtest.tm.domain.project.QProject;
import org.squashtest.tm.domain.requirement.QRequirement;
import org.squashtest.tm.domain.requirement.QRequirementSyncExtender;
import org.squashtest.tm.domain.requirement.QRequirementVersion;
import org.squashtest.tm.domain.synchronisation.QRemoteSynchronisation;
import org.squashtest.tm.domain.testcase.QRequirementVersionCoverage;
import org.squashtest.tm.domain.testcase.QTestCase;
import org.squashtest.tm.plugin.jirasync.domain.JiraSelectType;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanIssue;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanRequirement;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanTestCase;
import org.squashtest.tm.plugin.jirasync.service.execplan.SelectedNode;

@Repository(value="squash.tm.plugin.jirasync.execplandao")
public class ExecplanSynchronizationDao {
    @PersistenceContext
    private EntityManager em;
    private static final String FILTER_SYNC_KEY = "select distinct extender.remoteReqId from RequirementSyncExtender extender inner join extender.remoteSynchronisation sync where sync.kind = 'squash.tm.plugin.jirasync' and extender.remoteReqId in (:keys)";
    private static final String FILTER_BUGFIXES_KEY = "select distinct issue.remoteIssueId from Issue issue where issue.remoteIssueId in (:keys)";
    private static final String FILTER_COVERED_REQS = "select distinct extender.remoteReqId from RequirementSyncExtender extender inner join extender.remoteSynchronisation sync inner join extender.requirement req inner join req.versions versions inner join versions.requirementVersionCoverages cov where sync.kind = 'squash.tm.plugin.jirasync' and extender.remoteReqId in (:keys)";
    private static final String LOAD_SELECTED_NODE_CPG = "select c.id, 'campaign', c.name, p.id, p.name from Campaign c join c.project p where c.id = :id";
    private static final String LOAD_SELECTED_NODE_IT = "select  it.id, 'iteration', it.name, p.id, p.name from Iteration it join it.campaign c join c.project p where it.id = :id";
    private static final String FIND_ITERATION_NAMES = "select it.name from Iteration it join it.campaign c where c.id = :id";
    private static final String FIND_ITERATION_CUFS = "select cuf from CustomFieldBinding binding join binding.customField cuf join binding.boundProject project where project.id = ( select cpro.id from Campaign c join c.project cpro where c.id = :cpgId ) and binding.boundEntity = :boundEntity order by binding.position asc";
    private static final String FIND_SYNCED_SERVERS = "select distinct serv from RemoteSynchronisation sync join sync.server serv";

    public List<BugTracker> findAllJiraServers() {
        return this.em.createQuery(FIND_SYNCED_SERVERS).getResultList();
    }

    public BugTracker findServerById(long id) {
        return (BugTracker)this.em.find(BugTracker.class, (Object)id);
    }

    public List<String> findAllSyncedJiraProjects() {
        return this.findJiraProjectsFromExtenders(null);
    }

    public List<String> findAllSyncedJiraProjects(long squashProjectId) {
        return this.findJiraProjectsFromExtenders(new RestrictToSquashProject(squashProjectId));
    }

    public Map<BugTracker, List<String>> findJiraProjectsGroupedByServer(Collection<String> serverKeys) {
        QBugTracker server = QBugTracker.bugTracker;
        QRemoteSynchronisation sync = QRemoteSynchronisation.remoteSynchronisation;
        QRequirementSyncExtender extender = QRequirementSyncExtender.requirementSyncExtender;
        HibernateQuery query = new HibernateQuery(this.getSession());
        return (Map)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)query.distinct()).select(new Expression[]{server, extender.remoteProjectId}).from((EntityPath)extender)).innerJoin((EntityPath)extender.remoteSynchronisation, (Path)sync)).innerJoin((EntityPath)sync.server, (Path)server)).where(new Predicate[]{sync.kind.eq((Object)"squash.tm.plugin.jirasync"), extender.remoteProjectId.in(serverKeys)})).transform(GroupBy.groupBy((Expression)server).as((Expression)GroupBy.list((Expression)extender.remoteProjectId)));
    }

    private List<String> findJiraProjectsFromExtenders(QueryCustomizer customizer) {
        QRequirementSyncExtender extender = QRequirementSyncExtender.requirementSyncExtender;
        QRemoteSynchronisation sync = QRemoteSynchronisation.remoteSynchronisation;
        HibernateQuery query = new HibernateQuery(this.getSession());
        ((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)query.distinct()).select((Expression)extender.remoteProjectId).from((EntityPath)extender)).innerJoin((EntityPath)extender.remoteSynchronisation, (Path)sync)).where((Predicate)sync.kind.eq((Object)"squash.tm.plugin.jirasync"))).orderBy(extender.remoteProjectId.asc());
        if (customizer != null) {
            customizer.customize(query);
        }
        return query.fetch();
    }

    public List<String> findAllSyncedBoards() {
        return this.findBoardsFromSync(null);
    }

    public List<String> findAllSyncedBoards(long squashProjectId) {
        return this.findBoardsFromSync(new RestrictToSquashProject(squashProjectId));
    }

    public Map<BugTracker, List<String>> findBoardsGroupedByServer(Collection<String> boardNames) {
        QBugTracker server = QBugTracker.bugTracker;
        QRemoteSynchronisation sync = QRemoteSynchronisation.remoteSynchronisation;
        HibernateQuery query = new HibernateQuery(this.getSession());
        return (Map)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)query.distinct()).select(new Expression[]{server, sync.selectValue}).from((EntityPath)sync)).innerJoin((EntityPath)sync.server, (Path)server)).where(new Predicate[]{sync.kind.eq((Object)"squash.tm.plugin.jirasync"), sync.selectType.eq((Object)JiraSelectType.BOARD.toString()), sync.selectValue.in(boardNames)})).transform(GroupBy.groupBy((Expression)server).as((Expression)GroupBy.list((Expression)sync.selectValue)));
    }

    private List<String> findBoardsFromSync(QueryCustomizer customizer) {
        QRemoteSynchronisation sync = QRemoteSynchronisation.remoteSynchronisation;
        HibernateQuery query = new HibernateQuery(this.getSession());
        ((HibernateQuery)((HibernateQuery)((HibernateQuery)query.distinct()).select((Expression)sync.selectValue).from((EntityPath)sync)).where((Predicate)sync.kind.eq((Object)"squash.tm.plugin.jirasync").and((Predicate)sync.selectType.eq((Object)JiraSelectType.BOARD.toString())))).orderBy(sync.selectValue.asc());
        if (customizer != null) {
            customizer.customize(query);
        }
        return query.fetch();
    }

    public List<ExecplanTestCase> findTestCasesCoveringFeatures(Collection<String> jiraKeys) {
        if (jiraKeys.isEmpty()) {
            return Collections.emptyList();
        }
        QTestCase tc = QTestCase.testCase;
        QRequirementVersionCoverage cov = QRequirementVersionCoverage.requirementVersionCoverage;
        QRequirementVersion ver = QRequirementVersion.requirementVersion;
        QRequirement req = QRequirement.requirement;
        QRequirementSyncExtender ext = QRequirementSyncExtender.requirementSyncExtender;
        Map result = (Map)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)new HibernateQuery(this.getSession()).select(new Expression[]{tc.id, tc.name, tc.reference, ver.id, ver.reference, ext.remoteReqId}).from((EntityPath)tc)).innerJoin((CollectionExpression)tc.requirementVersionCoverages, (Path)cov)).innerJoin((EntityPath)cov.verifiedRequirementVersion, (Path)ver)).innerJoin((EntityPath)ver.requirement, (Path)req)).innerJoin((EntityPath)req.syncExtender, (Path)ext)).where((Predicate)ext.remoteReqId.in(jiraKeys))).transform(GroupBy.groupBy((Expression)Projections.constructor(ExecplanTestCase.class, (Expression[])new Expression[]{tc.id, tc.name, tc.reference})).as((Expression)GroupBy.list((Expression)Projections.constructor(ExecplanRequirement.class, (Expression[])new Expression[]{ver.id, ver.reference, ext.remoteReqId}))));
        return result.entrySet().stream().map(entry -> {
            ExecplanTestCase ctc = (ExecplanTestCase)entry.getKey();
            List creqs = (List)entry.getValue();
            ctc.setRequirements(creqs);
            return ctc;
        }).collect(Collectors.toList());
    }

    public List<ExecplanTestCase> findTestCasesFixedBy(Collection<String> jiraKeys) {
        if (jiraKeys.isEmpty()) {
            return Collections.emptyList();
        }
        QTestCase tc = QTestCase.testCase;
        QExecution exec = QExecution.execution;
        QIssue issue = QIssue.issue;
        Map result = (Map)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)new HibernateQuery(this.getSession()).select(new Expression[]{tc.id, tc.name, tc.reference, issue.remoteIssueId}).from((EntityPath)exec)).innerJoin((CollectionExpression)exec.issues, (Path)issue)).innerJoin((EntityPath)exec.referencedTestCase, (Path)tc)).where((Predicate)issue.remoteIssueId.in(jiraKeys))).transform(GroupBy.groupBy((Expression)Projections.constructor(ExecplanTestCase.class, (Expression[])new Expression[]{tc.id, tc.name, tc.reference})).as((Expression)GroupBy.list((Expression)Projections.constructor(ExecplanIssue.class, (Expression[])new Expression[]{issue.remoteIssueId}))));
        return result.entrySet().stream().map(entry -> {
            ExecplanTestCase ctc = (ExecplanTestCase)entry.getKey();
            List cissues = (List)entry.getValue();
            ctc.setIssues(cissues);
            return ctc;
        }).collect(Collectors.toList());
    }

    public Set<String> filterFeatures(Collection<String> jiraKeys) {
        if (jiraKeys.isEmpty()) {
            return Collections.emptySet();
        }
        List res = this.em.createQuery(FILTER_SYNC_KEY).setParameter("keys", jiraKeys).getResultList();
        return new HashSet<String>(res);
    }

    public Set<String> filterBugfixes(Collection<String> jiraKeys) {
        if (jiraKeys.isEmpty()) {
            return Collections.emptySet();
        }
        List res = this.em.createQuery(FILTER_BUGFIXES_KEY).setParameter("keys", jiraKeys).getResultList();
        return new HashSet<String>(res);
    }

    public Set<String> filterCoveredFeatures(Collection<String> jiraKeys) {
        if (jiraKeys.isEmpty()) {
            return Collections.emptySet();
        }
        List res = this.em.createQuery(FILTER_COVERED_REQS).setParameter("keys", jiraKeys).getResultList();
        return new HashSet<String>(res);
    }

    public Collection<Long> findTestCasesAlreadyPlannedInCampaign(long campaignId) {
        QCampaign cpg = QCampaign.campaign;
        QCampaignTestPlanItem item = QCampaignTestPlanItem.campaignTestPlanItem;
        QTestCase tc = QTestCase.testCase;
        HibernateQuery query = new HibernateQuery(this.getSession());
        ((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)query.distinct()).select((Expression)tc.id).from((EntityPath)item)).innerJoin((EntityPath)item.campaign, (Path)cpg)).innerJoin((EntityPath)item.referencedTestCase, (Path)tc)).where((Predicate)cpg.id.eq((Object)campaignId));
        return query.fetch();
    }

    public Collection<Long> findTestCasesAlreadyPlannedInIteration(long iterationId) {
        QIteration it = QIteration.iteration;
        QIterationTestPlanItem item = QIterationTestPlanItem.iterationTestPlanItem;
        QTestCase tc = QTestCase.testCase;
        HibernateQuery query = new HibernateQuery(this.getSession());
        ((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)query.distinct()).select((Expression)tc.id).from((EntityPath)item)).innerJoin((EntityPath)item.iteration, (Path)it)).innerJoin((EntityPath)item.referencedTestCase, (Path)tc)).where((Predicate)it.id.eq((Object)iterationId));
        return query.fetch();
    }

    public List<String> findIterationNamesForCampaign(long campaignId) {
        return this.em.createQuery(FIND_ITERATION_NAMES).setParameter("id", (Object)campaignId).getResultList();
    }

    public List<CustomField> findIterationCutomfieldsForCampaign(long campaignId) {
        return this.em.createQuery(FIND_ITERATION_CUFS).setParameter("cpgId", (Object)campaignId).setParameter("boundEntity", (Object)BindableEntity.ITERATION).getResultList();
    }

    public SelectedNode loadSelectedNode(EntityReference reference) {
        Long id = reference.getId();
        String query = null;
        switch (reference.getType()) {
            case CAMPAIGN: {
                query = LOAD_SELECTED_NODE_CPG;
                break;
            }
            case ITERATION: {
                query = LOAD_SELECTED_NODE_IT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Entity Type '" + reference.getType() + "' is not yet supported");
            }
        }
        return this.loadSelectedNode(query, id);
    }

    private SelectedNode loadSelectedNode(String hql, Long entityId) {
        Object[] tuple = (Object[])this.em.createQuery(hql).setParameter("id", (Object)entityId).getSingleResult();
        SelectedNode node = new SelectedNode();
        node.setEntityId((Long)tuple[0]);
        node.setType((String)tuple[1]);
        node.setEntityName((String)tuple[2]);
        node.setProjectId((Long)tuple[3]);
        node.setProjectName((String)tuple[4]);
        return node;
    }

    private Session getSession() {
        return (Session)this.em.unwrap(Session.class);
    }

    @FunctionalInterface
    private static interface QueryCustomizer {
        public void customize(HibernateQuery<?> var1);
    }

    private static final class RestrictToSquashProject
    implements QueryCustomizer {
        private final long squashProjectId;

        RestrictToSquashProject(long squashProjectId) {
            this.squashProjectId = squashProjectId;
        }

        @Override
        public void customize(HibernateQuery<?> query) {
            QRemoteSynchronisation sync = QRemoteSynchronisation.remoteSynchronisation;
            QProject proj = QProject.project;
            ((HibernateQuery)query.innerJoin((EntityPath)sync.project, (Path)proj)).where((Predicate)proj.id.eq((Object)this.squashProjectId));
        }
    }
}

