/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service.execplan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.collections.comparators.NullComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.plugin.jirasync.client.JiraClient;
import org.squashtest.tm.plugin.jirasync.domain.JiraSprintState;
import org.squashtest.tm.plugin.jirasync.domain.execplan.BoardSprints;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanIssue;
import org.squashtest.tm.plugin.jirasync.domain.execplan.SprintSearch;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraBoard;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraSearchResult;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraSprint;
import org.squashtest.tm.plugin.jirasync.service.ClientProvider;
import org.squashtest.tm.plugin.jirasync.service.execplan.ExecplanSynchronizationDao;
import org.squashtest.tm.plugin.jirasync.service.execplan.TicketBrowseUrlFixer;

@Service(value="squash.tm.plugin.jirasync.explanSprintService")
@Transactional
class ExecplanSprintsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecplanSprintsService.class);
    @Inject
    private ExecplanSynchronizationDao dao;
    @Inject
    private ClientProvider clientProvider;

    ExecplanSprintsService() {
    }

    @Transactional(readOnly=true)
    SprintSearch findSprints(SprintSearch ssearch) {
        Collection<String> boardNames = ssearch.getBoards();
        LOGGER.debug("searching sprints for the given boards : {}", boardNames);
        Map<BugTracker, List<String>> boardsByServer = this.dao.findBoardsGroupedByServer(boardNames);
        ArrayList<BoardSprints> result = new ArrayList<BoardSprints>();
        boardsByServer.forEach((bugtracker, boards) -> {
            LOGGER.debug("fetching sprints for boards {} on server {}", boards, (Object)bugtracker.getName());
            Throwable throwable = null;
            Object var6_7 = null;
            try (JiraClient client = this.clientProvider.createAuthenticatedClient((BugTracker)bugtracker);){
                for (String board : boards) {
                    Optional<BoardSprints> brd = this.fetchOptionalBoardSprints(client, board, ssearch);
                    if (!brd.isPresent()) continue;
                    result.add(brd.get());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
        ssearch.setResult(result);
        return ssearch;
    }

    @Transactional(readOnly=true)
    List<ExecplanIssue> findTicketsInSprints(Collection<BoardSprints> boardSprints) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("fetching JIRA tickets shipped with sprints :");
            for (BoardSprints sprints : boardSprints) {
                LOGGER.debug("\t{}", (Object)sprints.log());
            }
        }
        Map<BugTracker, List<BoardSprints>> sprintsByServer = this.locateServerHostingSprints(boardSprints);
        ArrayList<ExecplanIssue> issues = new ArrayList<ExecplanIssue>();
        sprintsByServer.forEach((bugTracker, bsprints) -> {
            LOGGER.debug("fetching JIRA tickets deom sprint on bugtracker '{}'", (Object)bugTracker.getName());
            Throwable throwable = null;
            Object var5_6 = null;
            try (JiraClient client = this.clientProvider.createAuthenticatedClient((BugTracker)bugTracker);){
                List<Long> sprintIds = bsprints.stream().flatMap(bsprint -> bsprint.getSprints().stream()).map(JiraSprint::getId).collect(Collectors.toList());
                List<ExecplanIssue> fetched = this.fetchIssuesForSprints(client, sprintIds);
                TicketBrowseUrlFixer urlFixer = new TicketBrowseUrlFixer((BugTracker)bugTracker);
                fetched.forEach(urlFixer::setBrowseUrl);
                issues.addAll(fetched);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
        LOGGER.debug("fetched {} issues", (Object)issues.size());
        return issues;
    }

    private Optional<BoardSprints> fetchOptionalBoardSprints(JiraClient client, String board, SprintSearch ssearch) {
        JiraBoard jBoard = null;
        try {
            jBoard = client.getBoard(board);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.debug("board '{}' does not exist, skipping", (Object)board);
            return Optional.empty();
        }
        if (jBoard == null || !jBoard.canHaveSprints()) {
            LOGGER.debug("board '{}' cannot have sprint, abort", (Object)board);
            return Optional.empty();
        }
        LOGGER.debug("fetching sprints for board '{}'", (Object)board);
        BoardSprints boardSprints = new BoardSprints();
        boardSprints.setBoard(board);
        JiraSprintState[] state = null;
        Date completedSince = ssearch.getCompletedSince();
        boolean stillRunning = ssearch.isSprintStillRunning();
        String nameLike = ssearch.getNameLike();
        Integer mostRecent = ssearch.getMostRecentReleasesLimit();
        if (completedSince != null && stillRunning) {
            throw new IllegalArgumentException("The search form have both options 'completedSince' and 'isStillRunning' were set at the same time.");
        }
        if (completedSince != null) {
            LOGGER.debug("sprint search : restrict to complete sprint since date {}", (Object)completedSince);
            state = new JiraSprintState[]{JiraSprintState.CLOSED};
        } else if (stillRunning) {
            LOGGER.debug("sprint search : restrict to active sprints");
            state = new JiraSprintState[]{JiraSprintState.ACTIVE};
        } else {
            LOGGER.debug("sprint search : no status restriction, retrieve all the sprints");
        }
        List<JiraSprint> jSprints = client.getSprints(jBoard.getId(), state);
        if (nameLike != null) {
            jSprints.removeIf(s -> !s.getName().contains(nameLike));
        }
        if (completedSince != null) {
            jSprints.removeIf(s -> s.getCompleteDate() != null && s.getCompleteDate().before(completedSince));
        }
        if (mostRecent != null) {
            mostRecent = mostRecent < 0 ? 0 : mostRecent;
            if (jSprints.size() > mostRecent) {
                NullComparator cmp = new NullComparator(true);
                jSprints.sort((a, b) -> -cmp.compare((Object)a.getStartDate(), (Object)b.getStartDate()));
                jSprints = jSprints.subList(0, mostRecent);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("found these sprints according to criterion : {}", jSprints.stream().map(JiraSprint::getId).collect(Collectors.toList()));
        }
        boardSprints.setSprints(jSprints);
        return Optional.of(boardSprints);
    }

    private Map<BugTracker, List<BoardSprints>> locateServerHostingSprints(Collection<BoardSprints> boardSprints) {
        LOGGER.debug("locating servers hosting those sprints");
        List<String> boardNames = boardSprints.stream().map(BoardSprints::getBoard).collect(Collectors.toList());
        Map<BugTracker, List<String>> boardsByServer = this.dao.findBoardsGroupedByServer(boardNames);
        return boardsByServer.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            List bnames = (List)entry.getValue();
            return boardSprints.stream().filter(spr -> bnames.contains(spr.getBoard())).collect(Collectors.toList());
        }));
    }

    private List<ExecplanIssue> fetchIssuesForSprints(JiraClient client, Collection<Long> sprintIds) {
        LOGGER.debug("fetching issues for sprint ids : {}", sprintIds);
        ArrayList<ExecplanIssue> issues = new ArrayList<ExecplanIssue>();
        for (Long sprintId : sprintIds) {
            LOGGER.debug("fetching for sprint {}", (Object)sprintId);
            JiraSearchResult<ExecplanIssue> result = null;
            int pagenum = 0;
            int fetchCnt = 0;
            do {
                LOGGER.trace("paged REST call, page {}", (Object)pagenum);
                result = client.findExecplanIssuesForSprint(sprintId, pagenum).claim();
                for (ExecplanIssue jirssue : result.getIssues()) {
                    ++fetchCnt;
                    issues.add(jirssue);
                }
                LOGGER.trace("retrieved issues : {} / {}", (Object)fetchCnt, (Object)result.getTotal());
                ++pagenum;
            } while (fetchCnt < result.getTotal());
        }
        LOGGER.debug("done");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("retrieved issues : {}", issues.stream().map(ExecplanIssue::getKey).collect(Collectors.toList()));
        }
        return issues;
    }
}

