/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service.execplan;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.plugin.jirasync.client.JiraClient;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanIssue;
import org.squashtest.tm.plugin.jirasync.domain.execplan.JqlSearch;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraSearchResult;
import org.squashtest.tm.plugin.jirasync.service.ClientProvider;
import org.squashtest.tm.plugin.jirasync.service.execplan.ExecplanSynchronizationDao;
import org.squashtest.tm.plugin.jirasync.service.execplan.TicketBrowseUrlFixer;

@Service(value="squash.tm.plugin.jirasync.explanJslService")
@Transactional(readOnly=true)
class ExecplanJqlService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecplanJqlService.class);
    @Inject
    private ClientProvider clientProvider;
    @Inject
    private ExecplanSynchronizationDao dao;

    ExecplanJqlService() {
    }

    List<BugTracker> findQueriableServers() {
        return this.dao.findAllJiraServers();
    }

    List<ExecplanIssue> findTicketsByJql(JqlSearch jsearch) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("fetching JIRA tickets with a jql expression : {}", (Object)jsearch.logParameters());
        }
        BugTracker server = this.dao.findServerById(jsearch.getServerId());
        LOGGER.trace("server is : {}", (Object)server.getName());
        ArrayList<ExecplanIssue> issues = new ArrayList<ExecplanIssue>();
        Throwable throwable = null;
        Object var5_6 = null;
        try (JiraClient client = this.clientProvider.createAuthenticatedClient(server);){
            int page = 0;
            int fetchCnt = 0;
            JiraSearchResult<ExecplanIssue> result = null;
            do {
                LOGGER.trace("paged RESTcall, page {}", (Object)page);
                result = client.findExecplanIssueForJql(jsearch.getExpression(), page).claim();
                for (ExecplanIssue jirssue : result.getIssues()) {
                    ++fetchCnt;
                    issues.add(jirssue);
                }
                LOGGER.trace("retrieved issues : {} / {}", (Object)fetchCnt, (Object)result.getTotal());
                ++page;
            } while (fetchCnt < result.getTotal());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        TicketBrowseUrlFixer urlFixer = new TicketBrowseUrlFixer(server);
        issues.forEach(urlFixer::setBrowseUrl);
        LOGGER.debug("done");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("retrieved issues : {}", issues.stream().map(ExecplanIssue::getKey).collect(Collectors.toList()));
        }
        return issues;
    }
}

