/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jirasync.org.apache.commons.lang.StringUtils;
import org.squashtest.tm.plugin.jirasync.service.ValueMappings;

public class SynchronisationEffectiveConfiguration {
    public static final String EFFECTIVE_EPIC_LINK_KEY = "(internal - Epic link)";
    public static final String EPIC_LINK_SCHEMA_NAME = "com.pyxis.greenhopper.jira:gh-epic-link";
    private String epicLinkId = null;
    private String sprintFieldId = null;
    private Map<String, EffectiveMapping> fieldMappings = new HashMap<String, EffectiveMapping>();
    private ValueMappings valueMappings = new ValueMappings();
    private Long targetRequirementFolderId;

    public String getEpicLinkId() {
        return this.epicLinkId;
    }

    public void setEpicLinkId(String epicLinkId) {
        this.epicLinkId = epicLinkId;
    }

    public Map<String, EffectiveMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public void setFieldMappings(Map<String, EffectiveMapping> fieldMappings) {
        this.fieldMappings = fieldMappings;
    }

    public void addEffectiveMapping(String squashField, String jiraField, boolean isCustom) {
        this.fieldMappings.put(squashField, new EffectiveMapping(squashField, jiraField, isCustom));
    }

    public void setValueMappings(ValueMappings valueMappings) {
        this.valueMappings = valueMappings;
    }

    public ValueMappings getValueMappings() {
        return this.valueMappings;
    }

    public boolean hasCustomFields() {
        for (EffectiveMapping e : this.fieldMappings.values()) {
            if (e == null || !e.isCustom()) continue;
            return true;
        }
        return false;
    }

    public Set<String> getQueryFields() {
        HashSet<String> fields = new HashSet<String>();
        for (EffectiveMapping m : this.fieldMappings.values()) {
            if (m.invalid()) continue;
            fields.add(m.getJiraField());
        }
        if (StringUtils.isNotBlank(this.sprintFieldId)) {
            fields.add(this.sprintFieldId);
        }
        return fields;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ \n");
        builder.append("\tepic link id : ").append(this.epicLinkId).append(",\n");
        builder.append("\tfields : [\n");
        for (EffectiveMapping m : this.fieldMappings.values()) {
            builder.append("\t\t").append(m.toString()).append(",\n");
        }
        builder.append("\t]");
        builder.append("\n}");
        return builder.toString();
    }

    public boolean hasSomeJirafieldsNotfound() {
        for (EffectiveMapping m : this.fieldMappings.values()) {
            if (!m.invalid()) continue;
            return true;
        }
        return false;
    }

    public String getSprintFieldId() {
        return this.sprintFieldId;
    }

    public void setSprintFieldId(String sprintFieldId) {
        this.sprintFieldId = sprintFieldId;
    }

    public boolean hasValidSprintField() {
        return StringUtils.isNotBlank(this.sprintFieldId);
    }

    public static final class EffectiveMapping {
        private String squashField;
        private String jiraField;
        private boolean isCustom;
        private String type;
        private String items;

        public EffectiveMapping() {
        }

        public EffectiveMapping(String squashField, String jiraField, boolean isCustom) {
            this.squashField = squashField;
            this.jiraField = jiraField;
            this.isCustom = isCustom;
        }

        public String getSquashField() {
            return this.squashField;
        }

        public void setSquashField(String squashField) {
            this.squashField = squashField;
        }

        public String getJiraField() {
            return this.jiraField;
        }

        public void setJiraField(String jiraField) {
            this.jiraField = jiraField;
        }

        public boolean isCustom() {
            return this.isCustom;
        }

        public boolean isNative() {
            return !this.isCustom;
        }

        public void setCustom(boolean isCustom) {
            this.isCustom = isCustom;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getItems() {
            return this.items;
        }

        public void setItems(String items) {
            this.items = items;
        }

        public boolean invalid() {
            return this.jiraField == null;
        }

        public void addCustomInfos(String type, String items) {
            this.type = type;
            this.items = items;
        }

        public String toString() {
            String tostr;
            if (this.invalid()) {
                tostr = "{ " + this.squashField + " : (not found - invalid) }";
            } else {
                String detail = !this.isCustom ? "native" : "custom, type : '" + this.type + "', items : '" + this.items + "'";
                tostr = "{ " + this.squashField + " : " + this.jiraField + " (" + detail + ") }";
            }
            return tostr;
        }
    }
}

