/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import jirasync.com.atlassian.jira.rest.client.api.RestClientException;
import jirasync.com.atlassian.jira.rest.client.api.domain.BasicIssue;
import jirasync.com.atlassian.jira.rest.client.api.domain.Issue;
import jirasync.com.atlassian.jira.rest.client.api.domain.SearchResult;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementFolderSyncExtender;
import org.squashtest.tm.domain.requirement.RequirementFolderSyncExtenderType;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.synchronisation.SynchronisationStatus;
import org.squashtest.tm.plugin.jirasync.client.JiraClient;
import org.squashtest.tm.plugin.jirasync.domain.Configuration;
import org.squashtest.tm.plugin.jirasync.domain.JiraRemoteSynchronisation;
import org.squashtest.tm.plugin.jirasync.domain.JiraSelectType;
import org.squashtest.tm.plugin.jirasync.importer.ImporterState;
import org.squashtest.tm.plugin.jirasync.importer.JiraRequirementImporter;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraAgileIssue;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraBoard;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraSprint;
import org.squashtest.tm.plugin.jirasync.repository.PluginRequirementDao;
import org.squashtest.tm.plugin.jirasync.service.ClientProvider;
import org.squashtest.tm.plugin.jirasync.service.ConfigurationManager;
import org.squashtest.tm.plugin.jirasync.service.ConfigurationService;
import org.squashtest.tm.plugin.jirasync.service.JiraReportingService;
import org.squashtest.tm.plugin.jirasync.service.SynchronisationEffectiveConfiguration;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.library.FolderModificationService;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;

@Service(value="squash.tm.plugin.jirasync.synchronizationService")
public class RequirementSynchronizationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementSynchronizationService.class);
    public static final String JIRA_SYNC_CRON_ID = "jira.xsquash";
    @Inject
    private Provider<JiraRequirementImporter> importerProvider;
    @Inject
    private BugTrackerFinderService serverService;
    @Inject
    private ConfigurationService confService;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private PluginRequirementDao pluginRequirementDao;
    @Inject
    private RequirementLibraryNavigationService requirementLibraryNavigationService;
    @Inject
    private PlatformTransactionManager transactionManager;
    @Inject
    private ClientProvider clientProvider;
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private JiraReportingService jiraReportingService;
    private FolderModificationService<RequirementFolder> folderModificationService;
    @Inject
    @Named(value="org.squashtest.tm.plugin.jirasync.ConfigurationManager")
    private ConfigurationManager configurationManager;

    @Inject
    @Named(value="squashtest.tm.service.RequirementFolderModificationService")
    public final void setFolderModificationService(FolderModificationService<RequirementFolder> folderModificationService) {
        this.folderModificationService = folderModificationService;
    }

    public void performFullSynchronisation() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[JIRA-SYNC] - Begin Synchronisation with JIRA.");
        }
        this.performCronAuthentication();
        try {
            List<Long> jiraRemoteSyncIds = this.pluginRequirementDao.findJiraRemoteSyncIds();
            for (Long remoteSynchronisationId : jiraRemoteSyncIds) {
                this.performSynchronisation(remoteSynchronisationId);
            }
            this.jiraReportingService.performReportingToJira(jiraRemoteSyncIds);
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(null);
        }
    }

    private void performCronAuthentication() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[JIRA-SYNC] - Performing cron internal authentication");
        }
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        authorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"));
        AnonymousAuthenticationToken authentication = new AnonymousAuthenticationToken(JIRA_SYNC_CRON_ID, (Object)JIRA_SYNC_CRON_ID, authorities);
        SecurityContext context = SecurityContextHolder.getContext();
        context.setAuthentication((Authentication)authentication);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[JIRA-SYNC] - Done cron internal authentication as jira.xsquash");
        }
    }

    protected void performSynchronisation(Long remoteSynchronisationId) {
        Date syncDate = new Date();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[JIRA-SYNC] -  Begin Synchronisation with JIRA for RemoteSynchronisation " + remoteSynchronisationId);
        }
        this.logSyncStarted(remoteSynchronisationId, syncDate);
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(3);
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)remoteSynchronisationId);
        JiraClient jiraClient = null;
        SynchronisationStatus finalStatus = SynchronisationStatus.FAILURE;
        try {
            try {
                jiraClient = this.clientProvider.createAuthenticatedClient(remoteSynchronisation.getServer());
                JiraRemoteSynchronisation jiraRemoteSynchronisation = this.getJiraRemoteSynchronisation(remoteSynchronisation, jiraClient);
                if (jiraRemoteSynchronisation.isBoard()) {
                    this.doSynchronisationOnBoard(jiraClient, jiraRemoteSynchronisation);
                } else {
                    MultiMap desynchronisedIssueKeys = this.findDesynchronisedIssueKeys(jiraRemoteSynchronisation, jiraClient);
                    if (desynchronisedIssueKeys.values().size() != 0) {
                        this.doSynchronisation(jiraClient, jiraRemoteSynchronisation, desynchronisedIssueKeys);
                    }
                }
                this.entityManager.flush();
                this.transactionManager.commit(transaction);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[JIRA-SYNC] -  Finished Synchronisation with success : " + remoteSynchronisation.toString());
                }
                finalStatus = SynchronisationStatus.SUCCESS;
            }
            catch (Exception e) {
                this.transactionManager.rollback(transaction);
                LOGGER.error("[JIRA-SYNC] -  Error while processing remoteSynchronisation : " + remoteSynchronisationId, (Throwable)e);
                finalStatus = SynchronisationStatus.FAILURE;
                if (jiraClient != null) {
                    jiraClient.close();
                }
                this.logFinalStatus(remoteSynchronisationId, finalStatus, syncDate);
            }
        }
        finally {
            if (jiraClient != null) {
                jiraClient.close();
            }
            this.logFinalStatus(remoteSynchronisationId, finalStatus, syncDate);
        }
    }

    private void logSyncStarted(Long remoteSynchronisationId, Date syncDate) {
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(3);
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)remoteSynchronisationId);
        remoteSynchronisation.setLastSyncDate(syncDate);
        remoteSynchronisation.setSynchronisationStatus(SynchronisationStatus.RUNNING);
        this.entityManager.flush();
        this.entityManager.clear();
        this.transactionManager.commit(transaction);
    }

    private void logFinalStatus(Long remoteSynchronisationId, SynchronisationStatus synchronisationStatus, Date syncDate) {
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(3);
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)remoteSynchronisationId);
        remoteSynchronisation.setSynchronisationStatus(synchronisationStatus);
        remoteSynchronisation.setLastSynchronisationStatus(synchronisationStatus);
        if (synchronisationStatus.equals((Object)SynchronisationStatus.SUCCESS)) {
            remoteSynchronisation.setLastSuccessfulSyncDate(syncDate);
        }
        this.entityManager.flush();
        this.entityManager.clear();
        this.transactionManager.commit(transaction);
    }

    private void doSynchronisationOnBoard(JiraClient jiraClient, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        MultiMap multiMap;
        Collection desyncKeys;
        Long boardId = jiraRemoteSynchronisation.getBoardId();
        List<Object> sprints = new ArrayList();
        if (jiraRemoteSynchronisation.canHaveSprints()) {
            sprints = jiraClient.getSprints(boardId, jiraRemoteSynchronisation.isRestraintToActiveSprint());
            for (JiraSprint jiraSprint : sprints) {
                this.synchronizeSprint(jiraSprint, jiraRemoteSynchronisation);
            }
        }
        if ((desyncKeys = (multiMap = this.findDesynchronisedIssueKeys(jiraRemoteSynchronisation, jiraClient)).values()).size() > 0) {
            this.doSynchronisation(jiraClient, jiraRemoteSynchronisation, multiMap);
        }
        if (jiraRemoteSynchronisation.canHaveSprints()) {
            if (jiraRemoteSynchronisation.isRestraintToActiveSprint()) {
                this.synchroniseIssuePositionForActiveSprintOnlyBoards(jiraClient, jiraRemoteSynchronisation, sprints);
            } else if (desyncKeys.size() > 0) {
                this.synchroniseIssuePositionForStandardBoards(jiraClient, jiraRemoteSynchronisation, sprints, multiMap);
            }
        }
    }

    private void synchroniseIssuePositionForActiveSprintOnlyBoards(JiraClient jiraClient, JiraRemoteSynchronisation jiraRemoteSynchronisation, List<JiraSprint> activeSprints) {
        for (JiraSprint activeSprint : activeSprints) {
            Collection issuesThatShouldMoveOutSprintFolder;
            Set<Long> reqIdsToMoveOutSprint;
            Set<String> issuesInSquashSprintFolder;
            Set<String> issuesInJiraSprint = jiraClient.findIssuesForSprint(activeSprint.getId());
            Collection issuesThatShouldMoveToSprintFolder = CollectionUtils.removeAll(issuesInJiraSprint, issuesInSquashSprintFolder = this.pluginRequirementDao.findIssueKeyInSprintSubFolder(jiraRemoteSynchronisation.getId(), activeSprint.getSquashFolderId()));
            Set<Long> reqIdsToMoveInSprint = this.findReqThatShouldMove(jiraRemoteSynchronisation, issuesThatShouldMoveToSprintFolder);
            if (!reqIdsToMoveInSprint.isEmpty()) {
                this.requirementLibraryNavigationService.moveNodesToFolder(activeSprint.getSquashFolderId().longValue(), reqIdsToMoveInSprint.toArray(new Long[reqIdsToMoveInSprint.size()]));
            }
            if ((reqIdsToMoveOutSprint = this.findReqThatShouldMove(jiraRemoteSynchronisation, issuesThatShouldMoveOutSprintFolder = CollectionUtils.removeAll(issuesInSquashSprintFolder, issuesInJiraSprint))).isEmpty()) continue;
            this.requirementLibraryNavigationService.moveNodesToFolder(jiraRemoteSynchronisation.getTargetFolderId().longValue(), reqIdsToMoveOutSprint.toArray(new Long[reqIdsToMoveOutSprint.size()]));
        }
    }

    private Set<Long> findReqThatShouldMove(JiraRemoteSynchronisation jiraRemoteSynchronisation, Collection<String> issuesThatShouldMoveToSprintFolder) {
        return this.pluginRequirementDao.findReqIdEligibleToBeMoved(jiraRemoteSynchronisation.getId(), issuesThatShouldMoveToSprintFolder, jiraRemoteSynchronisation.getTargetFolderId());
    }

    private void synchroniseIssuePositionForStandardBoards(JiraClient jiraClient, JiraRemoteSynchronisation jiraRemoteSynchronisation, List<JiraSprint> sprints, MultiMap desynchronisedIssueKeys) {
        Long boardId = jiraRemoteSynchronisation.getBoardId();
        Collection desyncKeys = desynchronisedIssueKeys.values();
        Collection updatedIssues = (Collection)desynchronisedIssueKeys.getOrDefault((Object)"UPDATE", new ArrayList());
        Collection<String> movedIssuesToBacklog = this.moveIssuesToBacklog(jiraClient, jiraRemoteSynchronisation, boardId, updatedIssues);
        Collection issuesInSprints = CollectionUtils.removeAll((Collection)desyncKeys, movedIssuesToBacklog);
        this.moveIssuesToSprints(jiraClient, jiraRemoteSynchronisation, sprints, issuesInSprints);
    }

    private void moveIssuesToSprints(JiraClient jiraClient, JiraRemoteSynchronisation jiraRemoteSynchronisation, List<JiraSprint> sprints, Collection<String> issuesInSprints) {
        MultiMap moveOrder = this.findMoveOrderToSprints(jiraClient, jiraRemoteSynchronisation, sprints, issuesInSprints);
        for (Object id : moveOrder.keySet()) {
            Long folderId = (Long)id;
            List reqIds = (List)moveOrder.get((Object)folderId);
            this.requirementLibraryNavigationService.moveNodesToFolder(folderId.longValue(), reqIds.toArray(new Long[0]));
        }
    }

    private MultiMap findMoveOrderToSprints(JiraClient jiraClient, JiraRemoteSynchronisation jiraRemoteSynchronisation, List<JiraSprint> sprints, Collection<String> issuesInSprints) {
        Long boardId = jiraRemoteSynchronisation.getBoardId();
        MultiValueMap moveOrder = MultiValueMap.decorate(new HashMap());
        Map sprintById = sprints.stream().collect(Collectors.toMap(JiraSprint::getId, Function.identity()));
        Set<JiraAgileIssue> agileIssues = jiraClient.findIssuesForSprints(boardId, issuesInSprints);
        Set<String> keys = agileIssues.stream().map(JiraAgileIssue::getKey).collect(Collectors.toSet());
        Map<String, Long> eligibleToBeMoved = this.pluginRequirementDao.findReqIdAndJiraKeyEligibleToBeMoved(jiraRemoteSynchronisation.getId(), keys, jiraRemoteSynchronisation.getTargetFolderId());
        agileIssues = agileIssues.stream().filter(agileIssue -> agileIssue.getSprint() != null && eligibleToBeMoved.containsKey(agileIssue.getKey())).collect(Collectors.toSet());
        for (JiraAgileIssue agileIssue2 : agileIssues) {
            String issueKey = agileIssue2.getKey();
            JiraSprint sprint = (JiraSprint)sprintById.get(agileIssue2.getSprint().getId());
            if (Objects.nonNull(sprint)) {
                if (this.pluginRequirementDao.isRequirementInSynchronizedFolder(jiraRemoteSynchronisation.getId(), issueKey, sprint.getSquashFolderId())) continue;
                moveOrder.put((Object)sprint.getSquashFolderId(), (Object)this.pluginRequirementDao.findRequirementId(issueKey, jiraRemoteSynchronisation.getId()));
                continue;
            }
            throw new IllegalArgumentException("Programmatic error : The sprint  " + agileIssue2.getSprint().getName() + " has not be synchronized");
        }
        return moveOrder;
    }

    private Collection<String> moveIssuesToBacklog(JiraClient jiraClient, JiraRemoteSynchronisation jiraRemoteSynchronisation, Long boardId, Collection<String> updatedIssues) {
        Set<Long> requirementEligibleToBeMoved;
        Set<String> issuesForBackLog = jiraClient.findIssuesForBackLog(boardId);
        Collection issuesThatShouldMoveIntoBackLog = CollectionUtils.intersection(updatedIssues, issuesForBackLog);
        if (!issuesThatShouldMoveIntoBackLog.isEmpty() && !(requirementEligibleToBeMoved = this.pluginRequirementDao.findReqIdEligibleToBeMoved(jiraRemoteSynchronisation.getId(), issuesThatShouldMoveIntoBackLog, jiraRemoteSynchronisation.getTargetFolderId())).isEmpty()) {
            this.requirementLibraryNavigationService.moveNodesToFolder(jiraRemoteSynchronisation.getTargetFolderId().longValue(), requirementEligibleToBeMoved.toArray(new Long[0]));
        }
        return issuesThatShouldMoveIntoBackLog;
    }

    private JiraRemoteSynchronisation getJiraRemoteSynchronisation(RemoteSynchronisation remoteSynchronisation, JiraClient jiraClient) {
        JiraRemoteSynchronisation jiraRemoteSynchronisation;
        if (remoteSynchronisation.getSelectType().equals(JiraSelectType.BOARD.name())) {
            JiraBoard board = jiraClient.getBoard(remoteSynchronisation.getSelectValue());
            if (board == null) {
                throw new IllegalArgumentException("The board " + remoteSynchronisation.getSelectValue() + "doesn't exist on this jira server " + remoteSynchronisation.getServer().getUrl());
            }
            jiraRemoteSynchronisation = new JiraRemoteSynchronisation(remoteSynchronisation, board);
        } else {
            jiraRemoteSynchronisation = new JiraRemoteSynchronisation(remoteSynchronisation);
        }
        Long targetFolderId = this.validateSynchronisationTargetFolder(jiraRemoteSynchronisation);
        jiraRemoteSynchronisation.setTargetFolderId(targetFolderId);
        return jiraRemoteSynchronisation;
    }

    private void doSynchronisation(JiraClient jiraClient, JiraRemoteSynchronisation jiraRemoteSynchronisation, MultiMap desynchronisedIssueKeys) {
        ArrayList<String> allKeys;
        block8: {
            LOGGER.trace("Initiating synchronization");
            Configuration conf = this.confService.getConfigurationForProject(jiraRemoteSynchronisation.getRemoteSynchronisation());
            LOGGER.trace("Initiating synchronization client");
            LOGGER.trace("fetching metadata and creating effective configuration");
            SynchronisationEffectiveConfiguration effective = jiraClient.createEffectiveConfiguration(conf);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Effective configuration completed as follow : ");
                LOGGER.trace(effective.toString());
            }
            Set<String> jiraFields = effective.getQueryFields();
            if (effective.getEpicLinkId() != null) {
                jiraFields.add(effective.getEpicLinkId());
            }
            Long projectId = jiraRemoteSynchronisation.getProject().getId();
            Long serverId = jiraRemoteSynchronisation.getServer().getId();
            JiraRequirementImporter importer = this.createImporter(serverId, projectId, effective);
            ImporterState state = new ImporterState();
            importer.setState(state);
            Collection rawValues = desynchronisedIssueKeys.values();
            allKeys = new ArrayList<String>(rawValues);
            try {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Processing remote synchronisation : " + jiraRemoteSynchronisation.toString());
                }
                int processed = 0;
                int total = 0;
                int batchSize = this.configurationManager.getBatchSize();
                do {
                    total = allKeys.size();
                    List<String> subList = allKeys.subList(processed, Math.min(processed + batchSize, total));
                    SearchResult res = jiraClient.getIssuesForFilter(subList, jiraFields, processed, batchSize).claim();
                    Map<String, String> issuesDescription = jiraClient.getIssuesDescription(subList, processed, batchSize);
                    importer.importJiraTickets(res.getIssues(), jiraRemoteSynchronisation, desynchronisedIssueKeys, issuesDescription);
                    int incr = Math.min(batchSize, total - processed);
                    processed += incr;
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("retrieved " + processed + " out of " + total + " issues");
                    }
                    state.setHasAllFetchFailed(false);
                } while (processed < total);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Remote Synchronisation " + jiraRemoteSynchronisation.toString() + " done processing");
                }
            }
            catch (RestClientException exception) {
                if (!LOGGER.isTraceEnabled()) break block8;
                LOGGER.trace("encountered exception on fetch, which will be added to the synchronization report : ", (Throwable)exception);
            }
        }
        this.processSubTaskRelationship(jiraRemoteSynchronisation, allKeys);
    }

    private void processSubTaskRelationship(JiraRemoteSynchronisation jiraRemoteSynchronisation, ArrayList<String> allKeys) {
        Map<Long, List<String>> subTasksToMove = this.pluginRequirementDao.findSubtaskToMove(jiraRemoteSynchronisation.getId(), new HashSet<String>(allKeys));
        List<String> keys = subTasksToMove.entrySet().stream().map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
        Map<String, Long> eligibleToBeMoved = this.pluginRequirementDao.findReqIdAndJiraKeyInSynchronizedFolder(jiraRemoteSynchronisation.getId(), keys, jiraRemoteSynchronisation.getTargetFolderId());
        subTasksToMove.forEach((parentId, subtasksKeys) -> {
            HashSet requirementToMove = new HashSet();
            subtasksKeys.forEach(subtaskKey -> {
                if (eligibleToBeMoved.containsKey(subtaskKey)) {
                    requirementToMove.add((Long)eligibleToBeMoved.get(subtaskKey));
                }
            });
            if (!requirementToMove.isEmpty()) {
                this.requirementLibraryNavigationService.moveNodesToRequirement(parentId.longValue(), requirementToMove.toArray(new Long[requirementToMove.size()]));
            }
        });
    }

    private Long validateSynchronisationTargetFolder(JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        Long targetFolderId = this.pluginRequirementDao.findTargetFolderId(jiraRemoteSynchronisation.getRemoteSynchronisation().getId());
        if (targetFolderId != null) {
            return targetFolderId;
        }
        Long id = this.requirementLibraryNavigationService.findNodeIdByPath(jiraRemoteSynchronisation.getSynchronisationPath());
        if (id == null) {
            Long folderId = this.requirementLibraryNavigationService.mkdirs(jiraRemoteSynchronisation.getSynchronisationPath());
            RequirementFolder requirementFolder = (RequirementFolder)this.entityManager.find(RequirementFolder.class, (Object)folderId);
            RequirementFolderSyncExtender syncExtender = new RequirementFolderSyncExtender();
            syncExtender.setRequirementFolder(requirementFolder);
            syncExtender.setType(RequirementFolderSyncExtenderType.TARGET);
            syncExtender.setRemoteSynchronisation(jiraRemoteSynchronisation.getRemoteSynchronisation());
            this.entityManager.persist((Object)syncExtender);
            return folderId;
        }
        throw new IllegalArgumentException("The folder " + id + " is not a valid target for synchronisation " + jiraRemoteSynchronisation + ". Aborting");
    }

    private MultiMap findDesynchronisedIssueKeys(JiraRemoteSynchronisation jiraRemoteSynchronisation, JiraClient jiraClient) {
        int increment;
        MultiValueMap keys = MultiValueMap.decorate(new HashMap());
        String filter = this.computeJQL(jiraRemoteSynchronisation, jiraClient);
        int processed = 0;
        int total = 0;
        int batchSize = this.configurationManager.getBatchSize();
        do {
            if (LOGGER.isDebugEnabled()) {
                String message = String.format("Fetching from JIRA : %s for remote synchronisation %s. Fetching %d issues, from %d.", jiraRemoteSynchronisation.getServer().getURL(), jiraRemoteSynchronisation, batchSize, processed);
                LOGGER.debug(message);
            }
            SearchResult res = jiraClient.getIssueForModificationChecking(filter, processed, batchSize).claim();
            total = res.getTotal();
            increment = Math.min(batchSize, total - processed);
            Iterable<Issue> issues = res.getIssues();
            Map<String, DateTime> jiraIssuesKeyAndDate = StreamSupport.stream(issues.spliterator(), false).collect(Collectors.toMap(BasicIssue::getKey, Issue::getUpdateDate));
            Map<String, Timestamp> squashKnownIssueKeyAndDate = this.pluginRequirementDao.findKnownIssueKeyAndDate(jiraRemoteSynchronisation);
            jiraIssuesKeyAndDate.forEach((arg_0, arg_1) -> this.lambda$2(squashKnownIssueKeyAndDate, jiraRemoteSynchronisation, (MultiMap)keys, arg_0, arg_1));
        } while ((processed += increment) < total);
        return keys;
    }

    private boolean isTimeDiffIsSuperiorToThreshold(DateTime jiraIssueDate, Timestamp squashKnownIssueDate) {
        long squashTime = squashKnownIssueDate.getTime();
        long jiraTime = jiraIssueDate.toDate().getTime();
        long diff = jiraTime - squashTime;
        return diff > 1000L;
    }

    private void synchronizeSprint(JiraSprint jiraSprint, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        Long sprintFolderId = this.pluginRequirementDao.findSprintFolderId(jiraSprint.getId().toString(), jiraRemoteSynchronisation.getId());
        if (sprintFolderId == null) {
            this.createSprintFolder(jiraSprint, jiraRemoteSynchronisation);
        } else {
            this.updateSprintFolder(jiraSprint, sprintFolderId);
        }
    }

    private void updateSprintFolder(JiraSprint jiraSprint, Long sprintFolderId) {
        Long extenderId = this.pluginRequirementDao.findSprintFolderExtenderId(sprintFolderId);
        RequirementFolderSyncExtender requirementFolderSyncExtender = (RequirementFolderSyncExtender)this.entityManager.find(RequirementFolderSyncExtender.class, (Object)extenderId);
        String stateName = jiraSprint.getState().name();
        if (!requirementFolderSyncExtender.getRemoteFolderStatus().equals(stateName)) {
            requirementFolderSyncExtender.setRemoteFolderStatus(stateName);
        }
        String sprintName = jiraSprint.getName();
        RequirementFolder requirementFolder = requirementFolderSyncExtender.getRequirementFolder();
        if (StringUtils.isNotBlank((CharSequence)sprintName) && !requirementFolder.getName().equals(sprintName)) {
            this.folderModificationService.renameFolder(requirementFolder.getId().longValue(), sprintName);
        }
        jiraSprint.setSquashFolderId(sprintFolderId);
    }

    private void createSprintFolder(JiraSprint jiraSprint, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        Long targetFolderId = jiraRemoteSynchronisation.getTargetFolderId();
        RequirementFolder sprintFolder = new RequirementFolder();
        sprintFolder.setName(jiraSprint.getName());
        this.requirementLibraryNavigationService.addFolderToFolder(targetFolderId.longValue(), (Folder)sprintFolder);
        RequirementFolderSyncExtender requirementFolderSyncExtender = new RequirementFolderSyncExtender();
        requirementFolderSyncExtender.setRemoteSynchronisation(jiraRemoteSynchronisation.getRemoteSynchronisation());
        requirementFolderSyncExtender.setType(RequirementFolderSyncExtenderType.SPRINT);
        requirementFolderSyncExtender.setRemoteFolderId(jiraSprint.getId().toString());
        requirementFolderSyncExtender.setRemoteFolderStatus(jiraSprint.getState().name());
        requirementFolderSyncExtender.setRequirementFolder(sprintFolder);
        sprintFolder.setRequirementFolderSyncExtender(requirementFolderSyncExtender);
        this.entityManager.persist((Object)sprintFolder);
        jiraSprint.setSquashFolderId(sprintFolder.getId());
    }

    private String computeJQL(JiraRemoteSynchronisation remoteSynchronisation, JiraClient jiraClient) {
        JiraSelectType jiraSelectType = (JiraSelectType)EnumUtils.getEnum(JiraSelectType.class, (String)remoteSynchronisation.getSelectType());
        String jql = "";
        switch (jiraSelectType) {
            case BOARD: {
                jql = String.valueOf(jql) + jiraClient.getFilterForBoard(remoteSynchronisation.getSelectValue());
                String additionalJQL = remoteSynchronisation.getAdditionalJQL();
                if (!StringUtils.isNotBlank((CharSequence)additionalJQL)) break;
                additionalJQL = StringUtils.appendIfMissing((String)additionalJQL, (CharSequence)" AND ", (CharSequence[])new CharSequence[0]);
                jql = String.valueOf(additionalJQL) + jql;
                break;
            }
            case FILTER: {
                String filterName = remoteSynchronisation.getSelectValue();
                filterName = StringUtils.overlay((String)"''", (String)filterName, (int)1, (int)1);
                jql = String.valueOf(jql) + "filter=" + filterName;
                break;
            }
            case QUERY: {
                jql = String.valueOf(jql) + remoteSynchronisation.getSelectValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("Programmatic error, the select type " + (Object)((Object)jiraSelectType) + "isn't handled by this plugin.");
            }
        }
        if (remoteSynchronisation.isRestraintToActiveSprint()) {
            jql = StringUtils.prependIfMissing((String)jql, (CharSequence)" sprint IN openSprints() AND ", (CharSequence[])new CharSequence[0]);
        }
        return jql;
    }

    private JiraRequirementImporter createImporter(Long serverId, Long projectId, SynchronisationEffectiveConfiguration effective) {
        Project project = (Project)this.projectDao.findOne((Serializable)projectId);
        BugTracker server = this.serverService.findById(serverId.longValue());
        JiraRequirementImporter importer = (JiraRequirementImporter)this.importerProvider.get();
        importer.setServer(server);
        importer.setProject(project);
        importer.setConfiguration(effective);
        importer.configure();
        return importer;
    }

    private /* synthetic */ void lambda$2(Map map, JiraRemoteSynchronisation jiraRemoteSynchronisation, MultiMap multiMap, String jiraIssueKey, DateTime jiraIssueDate) {
        if (map.containsKey(jiraIssueKey)) {
            Timestamp squashKnownIssueDate = (Timestamp)map.get(jiraIssueKey);
            boolean diffIsSuperiorToThreshold = this.isTimeDiffIsSuperiorToThreshold(jiraIssueDate, squashKnownIssueDate);
            if (diffIsSuperiorToThreshold) {
                if (LOGGER.isTraceEnabled()) {
                    String message = String.format("The issue %s is present in Squash database for synchronisation %s. Persisted modification date is %s, JIRA modification date is %s. Must resync the issue !", jiraIssueKey, jiraRemoteSynchronisation, jiraIssueDate, squashKnownIssueDate);
                    LOGGER.trace(message);
                }
                multiMap.put((Object)"UPDATE", (Object)jiraIssueKey);
            }
        } else {
            if (LOGGER.isTraceEnabled()) {
                String message = String.format("The issue %s is not present in squash database for synchronisation %s. Will sync it !", jiraIssueKey, jiraRemoteSynchronisation);
                LOGGER.trace(message);
            }
            multiMap.put((Object)"CREATE", (Object)jiraIssueKey);
        }
    }
}

