/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.plugin.jirasync.client.JiraClient;
import org.squashtest.tm.plugin.jirasync.client.JiraReport;
import org.squashtest.tm.plugin.jirasync.domain.Configuration;
import org.squashtest.tm.plugin.jirasync.repository.PluginRequirementDao;
import org.squashtest.tm.plugin.jirasync.service.ClientProvider;
import org.squashtest.tm.plugin.jirasync.service.ConfigurationManager;
import org.squashtest.tm.plugin.jirasync.service.ConfigurationService;
import org.squashtest.tm.plugin.jirasync.service.JiraReportingEffectiveConfiguration;
import org.squashtest.tm.service.requirement.RequirementStatisticsService;
import org.squashtest.tm.service.statistics.requirement.RequirementVersionBundleStat;

@Service
public class JiraReportingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraReportingService.class);
    @Inject
    private PlatformTransactionManager transactionManager;
    @Inject
    private ClientProvider clientProvider;
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private ConfigurationService confService;
    @Inject
    private PluginRequirementDao pluginRequirementDao;
    @Inject
    private RequirementStatisticsService requirementStatisticsService;
    @Inject
    private DSLContext DSL;
    @Inject
    @Named(value="org.squashtest.tm.plugin.jirasync.ConfigurationManager")
    private ConfigurationManager configurationManager;

    public void performReportingToJira(List<Long> remoteSynchronisationIds) {
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(3);
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        try {
            try {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("[JIRA-SYNC] - Begin reporting to JIRA.");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[JIRA-SYNC] -  Begin rates calculation for synchronised requirements");
                }
                Map<Long, Map<String, List<Long>>> reqIdsByServerAndByKey = this.pluginRequirementDao.getReqIdsByServerAndByKey();
                ArrayList allIds = new ArrayList();
                reqIdsByServerAndByKey.values().forEach(stringListMap -> {
                    List ids = stringListMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                    allIds.addAll(ids);
                });
                Map reqStatsById = this.requirementStatisticsService.findSimplifiedCoverageStats(allIds).getRequirementStats();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[JIRA-SYNC] -  Finished rates calculation for + " + reqStatsById.size() + " synchronised requirements.");
                }
                for (Long remoteSynchronisationId : remoteSynchronisationIds) {
                    this.doReportingForOneSync(remoteSynchronisationId, reqIdsByServerAndByKey, reqStatsById);
                }
                this.transactionManager.commit(transaction);
            }
            catch (Exception e) {
                this.transactionManager.rollback(transaction);
                throw e;
            }
        }
        finally {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("[JIRA-SYNC] - Finished reporting to JIRA.");
            }
        }
    }

    private void doReportingForOneSync(Long remoteSynchronisationId, Map<Long, Map<String, List<Long>>> reqIdsByServerAndByKey, Map<Long, RequirementVersionBundleStat.SimpleRequirementStats> reqStatsById) {
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)remoteSynchronisationId);
        try (JiraClient jiraClient = null;){
            BugTracker server = remoteSynchronisation.getServer();
            jiraClient = this.clientProvider.createAuthenticatedClient(server);
            Configuration conf = this.confService.getConfigurationForProject(remoteSynchronisation);
            JiraReportingEffectiveConfiguration effectiveConfiguration = jiraClient.createJiraReportingEffectiveConfiguration(conf);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[JIRA-SYNC] Begin reporting to JIRA for sync : " + remoteSynchronisation.toString());
            }
            if (effectiveConfiguration.getValidFieldIds().size() == 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[JIRA-SYNC] Skipping reporting to JIRA : No valid field configuration for sync " + remoteSynchronisation.toString());
                }
                return;
            }
            List<String> keys = this.pluginRequirementDao.findAllKeys(remoteSynchronisationId);
            ArrayList<JiraReport> reportsToPost = new ArrayList<JiraReport>();
            int processed = 0;
            int total = keys.size();
            int batchSize = this.configurationManager.getBatchSize();
            while (processed < total) {
                int nextBatchSize = Math.min(processed + batchSize, keys.size());
                List<String> subKeys = keys.subList(processed, nextBatchSize);
                Iterable<JiraReport> initialReport = jiraClient.getInitialReport(subKeys, effectiveConfiguration);
                processed += subKeys.size();
                Map<String, List<Long>> reqsByIssueKeys = reqIdsByServerAndByKey.get(server.getId());
                for (JiraReport jiraReport : initialReport) {
                    this.doStatReconciliation(reqStatsById, server, reqsByIssueKeys, jiraReport);
                    if (!jiraReport.shouldBePostToJIRA()) continue;
                    reportsToPost.add(jiraReport);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[JIRA-SYNC] Finished preparing phase for reporting to JIRA. " + reportsToPost.size() + " Issues are out of date and need to be updated in JIRA.");
            }
            jiraClient.performReportingToJira(reportsToPost, effectiveConfiguration);
        }
    }

    private void doStatReconciliation(Map<Long, RequirementVersionBundleStat.SimpleRequirementStats> reqStatsById, BugTracker server, Map<String, List<Long>> reqsByIssueKeys, JiraReport jiraReport) {
        String issueKey = jiraReport.getKey();
        List<Long> ids = reqsByIssueKeys.get(issueKey);
        if (ids == null || ids.size() == 0) {
            throw new IllegalArgumentException("Programmatic error : Unknown requirement for key " + issueKey);
        }
        if (ids.size() == 1) {
            Long reqId = ids.get(0);
            RequirementVersionBundleStat.SimpleRequirementStats stats = reqStatsById.get(reqId);
            jiraReport.performStatReconciliation(stats);
        } else {
            String idsAsString = StringUtils.join(ids, (String)",");
            String msg = String.format("[JIRA-SYNC] Multiple synchronisations of the same JIRA issue %s in server %s. The affected requirements in squash are : %s. Note that reporting will be done by averaging the multiples values and it could result in apparently wrong reporting in JIRA. You should probably adjust synchronisations perimeters to avoid clashes.", issueKey, server.getName(), idsAsString);
            LOGGER.warn(msg);
            List<RequirementVersionBundleStat.SimpleRequirementStats> stats = ids.stream().map(reqStatsById::get).collect(Collectors.toList());
            jiraReport.performStatReconciliation(stats);
        }
    }
}

