/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.api.plugin.PluginValidationException;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.plugin.jirasync.controller.model.JiraRemoteSynchronisationModel;
import org.squashtest.tm.plugin.jirasync.domain.Configuration;
import org.squashtest.tm.plugin.jirasync.domain.FieldMapping;
import org.squashtest.tm.plugin.jirasync.domain.JiraRemoteSynchronisation;
import org.squashtest.tm.plugin.jirasync.repository.PluginRequirementDao;
import org.squashtest.tm.service.internal.repository.RemoteSynchronisationDao;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.scanner.ScannerException;

@Service(value="squash.tm.plugin.jirasync.configurationService")
@Transactional
public class ConfigurationService {
    private static final String PROJECT_LEADER_OR_ADMIN = "hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationService.class);
    @Inject
    private PluginRequirementDao dao;
    @Inject
    private InternationalizationHelper inHelper;
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private RemoteSynchronisationDao remoteSynchronisationDao;
    @Inject
    private RequirementLibraryNavigationService requirementLibraryNavigationService;

    public Configuration getConfigurationForProject(RemoteSynchronisation remoteSynchronisation) {
        Configuration conf = this.dao.getConfigurationForProject(remoteSynchronisation.getProject().getId());
        return conf;
    }

    public Configuration getConfigurationForProject(Long projectId) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        return conf;
    }

    public List<JiraRemoteSynchronisation> findRemoteSyncForProject(Long projectId) {
        return this.dao.findJiraRemoteSyncForProject(projectId);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')")
    public JiraRemoteSynchronisation addJiraRemoteSynchronisation(Long projectId, JiraRemoteSynchronisationModel model) {
        Project project = (Project)this.entityManager.find(Project.class, (Object)projectId);
        JiraRemoteSynchronisation sync = new JiraRemoteSynchronisation(new RemoteSynchronisation());
        this.validateName(model.getName());
        sync.setName(model.getName());
        this.validatePath(model, project);
        sync.setSynchronisationPath(model.getSynchronisationPath());
        sync.setKind("squash.tm.plugin.jirasync");
        sync.setSelectType(model.getSelectType());
        if (StringUtils.isBlank((CharSequence)model.getSelectValue())) {
            throw new PluginValidationException(this.inHelper.internationalize("henix.jirasync.sync.dialog.add.emptyvalue", LocaleContextHolder.getLocale()));
        }
        sync.setSelectValue(model.getSelectValue());
        if (sync.isBoard() && StringUtils.isNotBlank((CharSequence)model.getAdditionalJQL())) {
            sync.setAdditionalJQL(model.getAdditionalJQL());
        }
        sync.restraintToActiveSprint(model.isRestrainToActiveSprint());
        sync.setProject(project);
        if (model.getServerId() == null || model.getServerId().equals(0L)) {
            throw new PluginValidationException(this.inHelper.internationalize("henix.jirasync.sync.dialog.add.emptyserver", LocaleContextHolder.getLocale()));
        }
        BugTracker bugTracker = (BugTracker)this.entityManager.find(BugTracker.class, (Object)model.getServerId());
        sync.setServer(bugTracker);
        this.entityManager.persist((Object)sync.getRemoteSynchronisation());
        this.entityManager.flush();
        return sync;
    }

    private void validatePath(JiraRemoteSynchronisationModel model, Project project) {
        if (StringUtils.isBlank((CharSequence)model.getSynchronisationPath())) {
            throw new PluginValidationException(this.inHelper.internationalize("henix.jirasync.sync.dialog.add.emptypath", LocaleContextHolder.getLocale()));
        }
        Long id = this.requirementLibraryNavigationService.findNodeIdByPath(JiraRemoteSynchronisation.computeSynchronisationPath(project.getName(), model.getSynchronisationPath()));
        if (id != null) {
            throw new PluginValidationException(this.inHelper.internationalize("henix.jirasync.sync.dialog.add.existingpath", LocaleContextHolder.getLocale()));
        }
    }

    private void validateName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new PluginValidationException(this.inHelper.internationalize("henix.jirasync.sync.dialog.add.emptyname", LocaleContextHolder.getLocale()));
        }
        List remoteSynchronisations = this.remoteSynchronisationDao.findByNameAndKind(name, "squash.tm.plugin.jirasync");
        if (!remoteSynchronisations.isEmpty()) {
            throw new PluginValidationException(this.inHelper.internationalize("henix.jirasync.sync.dialog.add.uniquename", LocaleContextHolder.getLocale()));
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')")
    public void addFieldMapping(Long projectId, FieldMapping mapping) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        if (conf.hasFieldMapping(mapping)) {
            throw new PluginValidationException(this.inHelper.getMessage("henix.jirasync.mappings.add.invalid", new Object[]{mapping.getSquashField()}, "field mapping invalid", LocaleContextHolder.getLocale()));
        }
        conf.addFieldMapping(mapping);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')")
    public void removeFieldMappings(Long projectId, Collection<FieldMapping> mappings) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        for (FieldMapping map : mappings) {
            FieldMapping realItem = conf.getFieldMapping(map.getId());
            if (realItem == null || realItem.isLocked()) continue;
            conf.removeFieldMapping(realItem);
        }
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')")
    public void removeFieldMappingsByIds(Long projectId, Collection<String> ids) {
        ArrayList<FieldMapping> keys = new ArrayList<FieldMapping>(ids.size());
        for (String id : ids) {
            FieldMapping key = FieldMapping.byId(id);
            keys.add(key);
        }
        this.removeFieldMappings(projectId, keys);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')")
    public void updateFieldMappingSquashField(Long projectId, String mappingId, String newValue) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        FieldMapping mapping = conf.getFieldMapping(mappingId);
        if (mapping != null && mapping.getSquashField().equals(newValue)) {
            return;
        }
        if (conf.hasFieldMapping(newValue)) {
            throw new PluginValidationException(this.inHelper.getMessage("henix.jirasync.mappings.add.invalid", new Object[]{newValue}, "field mapping invalid", LocaleContextHolder.getLocale()));
        }
        if (mapping.isLocked()) {
            throw new RuntimeException("atempted to modify a locked field mapping '" + mappingId + "' !");
        }
        mapping.setSquashField(newValue);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')")
    public void updateFieldMappingJiraField(Long projectId, String mappingId, String newValue) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        FieldMapping mapping = conf.getFieldMapping(mappingId);
        if (mapping.isLocked()) {
            throw new RuntimeException("atempted to modify a locked field mapping '" + mappingId + "' !");
        }
        mapping.setJiraField(newValue);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')")
    public void updateValueMappings(Long projectId, String newValueMapping) {
        try {
            Yaml yaml = new Yaml();
            yaml.load(newValueMapping);
        }
        catch (ScannerException ex) {
            String parseError = ex.getMessage();
            String msg = this.inHelper.getMessage("henix.jirasync.valuemappings.invalid", new Object[]{parseError}, "Value mapping is invalid, check again your YAML syntax", LocaleContextHolder.getLocale());
            throw new PluginValidationException(msg);
        }
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        conf.setYamlFieldvalueMapping(newValueMapping);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')")
    public void deleteJiraRemoteSynchronisation(Long syncId) {
        this.dao.deleteJiraRemoteSynchronisation(syncId);
    }

    public void changeSyncName(String syncId, String newName) {
        this.validateName(newName);
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)Long.parseLong(syncId));
        remoteSynchronisation.setName(newName);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')")
    public void changeSyncSelectValue(String syncId, String selectValue) {
        if (StringUtils.isBlank((CharSequence)selectValue)) {
            throw new PluginValidationException(this.inHelper.internationalize("henix.jirasync.sync.dialog.add.emptyvalue", LocaleContextHolder.getLocale()));
        }
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)Long.parseLong(syncId));
        remoteSynchronisation.setSelectValue(selectValue);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')")
    public void changeSyncAdditionalJQL(String syncId, String additionalJQL) {
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)Long.parseLong(syncId));
        JiraRemoteSynchronisation jiraRemoteSynchronisation = new JiraRemoteSynchronisation(remoteSynchronisation);
        jiraRemoteSynchronisation.setAdditionalJQL(additionalJQL);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')")
    public void changeJiraStatusField(Long projectId, String jiraStatusField) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        conf.setStatusField(jiraStatusField);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')")
    public void changeJiraRedactionField(Long projectId, String jiraRedactionField) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        conf.setRedactionProgressField(jiraRedactionField);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')")
    public void changeJiraRedactionRatioField(Long projectId, String jiraRedactionRatioField) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        conf.setRedactionRatioField(jiraRedactionRatioField);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')")
    public void changeJiraVerificationField(Long projectId, String jiraVerificationField) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        conf.setVerificationProgressField(jiraVerificationField);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')")
    public void changeJiraVerificationRatioField(Long projectId, String jiraVerificationRatioField) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        conf.setVerificationRatioField(jiraVerificationRatioField);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')")
    public void changeJiraValidationField(Long projectId, String jiraValidationField) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        conf.setValidationProgressField(jiraValidationField);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')")
    public void changeJiraValidationRatioField(Long projectId, String jiraValidationRatioField) {
        Configuration conf = this.dao.getConfigurationForProject(projectId);
        conf.setValidationRatioField(jiraValidationRatioField);
        this.dao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')")
    public void commandFullSynchronisation(Long syncId) {
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        LOGGER.info("[JIRA-SYNC] : Command given to perform full synchronisation on " + remoteSynchronisation);
        this.dao.resetLastSyncDate(remoteSynchronisation);
    }
}

