/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service;

import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.plugin.jirasync.client.JiraClient;
import org.squashtest.tm.service.servers.CredentialsProvider;

@Service
@Transactional(readOnly=true)
public class ClientProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientProvider.class);
    @Inject
    private Provider<JiraClient> provider;
    @Inject
    private CredentialsProvider credentialsProvider;

    public JiraClient createAuthenticatedClient(BugTracker tracker) {
        Credentials credentials;
        String trackerName = tracker.getName();
        LOGGER.debug("creating authenticated client for bugtracker '{}'", (Object)trackerName);
        Optional maybeCredentials = this.credentialsProvider.getAppLevelCredentials(tracker);
        if (!maybeCredentials.isPresent()) {
            this.logAndThrowCredentialsError(trackerName);
        }
        if (!this.areCredentialsCorrect(credentials = (Credentials)maybeCredentials.get())) {
            this.logAndThrowCredentialsError(trackerName);
        }
        JiraClient client = (JiraClient)this.provider.get();
        client.initialize(tracker, credentials);
        LOGGER.debug("client authenticated and ready");
        return client;
    }

    private boolean areCredentialsCorrect(Credentials credentials) {
        return JiraClient.PROTOCOLS.contains(credentials.getImplementedProtocol());
    }

    private void logAndThrowCredentialsError(String trackerName) {
        String errorMsg = String.format("The configuration for the JIRA server '%s' in Squash TM is incomplete. It is required to configure a Basic Authentication  scheme as an application-level credential prior using this plugin", trackerName);
        RuntimeException ex = new RuntimeException(errorMsg);
        throw ex;
    }
}

