/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.repository;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.querydsl.core.group.GroupBy;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.hibernate.HibernateQuery;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.hibernate.Session;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.event.RequirementAuditEvent;
import org.squashtest.tm.domain.milestone.QMilestone;
import org.squashtest.tm.domain.project.QProject;
import org.squashtest.tm.domain.requirement.ManagementMode;
import org.squashtest.tm.domain.requirement.QRequirement;
import org.squashtest.tm.domain.requirement.QRequirementSyncExtender;
import org.squashtest.tm.domain.requirement.QRequirementVersion;
import org.squashtest.tm.domain.requirement.RequirementFolderSyncExtenderType;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.RequirementSyncExtender;
import org.squashtest.tm.plugin.jirasync.domain.Configuration;
import org.squashtest.tm.plugin.jirasync.domain.FieldMapping;
import org.squashtest.tm.plugin.jirasync.domain.JiraRemoteSynchronisation;
import org.squashtest.tm.plugin.jirasync.domain.RequirementReference;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.web.internal.helper.JsonHelper;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.scanner.ScannerException;

@Repository(value="squash.tm.plugin.jirasync.dao")
public class PluginRequirementDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginRequirementDao.class);
    private static final String ID_AND_KEY_BY_KEY = "select req.id, ext.remoteReqId from Requirement req inner join req.syncExtender ext where ext.remoteReqId in (:keys) and ext.remoteSynchronisation.id = :remoteSyncId";
    private static final String PARENT_NODE = "select parent from RequirementPathEdge edge, RequirementLibraryNode parent where edge.descendantId = :nodeId and edge.ancestorId = parent and edge.depth = 1";
    private static final String PARENT_LIB = "select rl from RequirementLibraryNode rln inner join rln.project proj inner join proj.requirementLibrary rl where rln.id = :nodeId ";
    private static final String RMV_CREAT_EVT = "delete RequirementCreation c where c.requirementVersion.id in (:vIds)";
    private static final String FIND_SYNC_FOR_PROJECT = "select sync from RemoteSynchronisation sync inner join sync.project p where p.id = :projectId";
    @PersistenceContext
    private EntityManager em;
    @Inject
    private GenericProjectManagerService projectManager;
    @Inject
    private ObjectMapper jsonifier;
    @Inject
    private DSLContext DSL;

    public void flush() {
        this.getSession().flush();
    }

    public List<Long> findJiraRemoteSyncIds() {
        return this.DSL.select((SelectField)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID).from((TableLike)Tables.REMOTE_SYNCHRONISATION).where(new Condition[]{Tables.REMOTE_SYNCHRONISATION.KIND.eq((Object)"squash.tm.plugin.jirasync")}).orderBy(Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID.desc()).fetch((Field)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID, Long.class);
    }

    public void storeConfigurationForProject(Long projectId, Configuration configuration) {
        HashMap<String, String> storageConf = new HashMap<String, String>(5);
        List<FieldMapping> fieldMappings = configuration.getFieldMappings();
        String strMappings = JsonHelper.serialize(fieldMappings);
        storageConf.put("attributeMappings", strMappings);
        String valueMapping = configuration.getYamlFieldvalueMapping();
        storageConf.put("valuesMapping", valueMapping);
        storageConf.put("jiraTestingStatusField", configuration.getStatusField());
        storageConf.put("jiraRedactionProgressField", configuration.getRedactionProgressField());
        storageConf.put("jiraVerificationProgressField", configuration.getVerificationProgressField());
        storageConf.put("jiraValidationProgressField", configuration.getValidationProgressField());
        storageConf.put("jiraRedactionRatioField", configuration.getRedactionRatioField());
        storageConf.put("jiraVerificationRatioField", configuration.getVerificationRatioField());
        storageConf.put("jiraValidationRatioField", configuration.getValidationRatioField());
        this.projectManager.setPluginConfiguration(projectId.longValue(), WorkspaceType.REQUIREMENT_WORKSPACE, "squash.tm.plugin.jirasync", storageConf);
    }

    public Configuration getConfigurationForProject(Long projectId) {
        Configuration configuration;
        block7: {
            Map conf;
            block6: {
                conf = this.projectManager.getPluginConfiguration(projectId.longValue(), WorkspaceType.REQUIREMENT_WORKSPACE, "squash.tm.plugin.jirasync");
                configuration = new Configuration();
                configuration.setStatusField((String)conf.get("jiraTestingStatusField"));
                configuration.setRedactionProgressField((String)conf.get("jiraRedactionProgressField"));
                configuration.setVerificationProgressField((String)conf.get("jiraVerificationProgressField"));
                configuration.setValidationProgressField((String)conf.get("jiraValidationProgressField"));
                configuration.setRedactionRatioField((String)conf.get("jiraRedactionRatioField"));
                configuration.setVerificationRatioField((String)conf.get("jiraVerificationRatioField"));
                configuration.setValidationRatioField((String)conf.get("jiraValidationRatioField"));
                String strMappings = (String)conf.get("attributeMappings");
                if (strMappings == null) {
                    strMappings = "[]";
                }
                try {
                    configuration = this.restoreMappings(configuration, strMappings);
                }
                catch (IOException e) {
                    if (!LOGGER.isErrorEnabled()) break block6;
                    LOGGER.error("could not parse field mapping " + strMappings + " for project ", (Throwable)e);
                }
            }
            String strValMappings = (String)conf.get("valuesMapping");
            if (strValMappings == null) {
                strValMappings = "";
            }
            try {
                configuration = this.restoreValueMappings(configuration, strValMappings);
            }
            catch (ScannerException ex) {
                if (!LOGGER.isErrorEnabled()) break block7;
                LOGGER.error("could not parse field value mapping " + strValMappings + " for project ", (Throwable)ex);
            }
        }
        return configuration;
    }

    public List<JiraRemoteSynchronisation> findJiraRemoteSyncForProject(Long projectId) {
        Query query = this.em.createQuery(FIND_SYNC_FOR_PROJECT);
        query.setParameter("projectId", (Object)projectId);
        List remoteSynchronisations = query.getResultList();
        return remoteSynchronisations.stream().map(JiraRemoteSynchronisation::new).collect(Collectors.toList());
    }

    private Configuration restoreMappings(Configuration conf, String strMappings) throws IOException {
        List mappings = (List)this.jsonifier.readValue(strMappings, (TypeReference)new TypeReference<List<FieldMapping>>(){});
        List<FieldMapping> basicMapping = FieldMapping.getBuiltinMapping();
        for (FieldMapping m : basicMapping) {
            boolean exists = mappings.contains(m);
            if (exists) continue;
            mappings.add(m);
        }
        conf.setFieldMappings(mappings);
        return conf;
    }

    private Configuration restoreValueMappings(Configuration conf, String stryaml) throws ScannerException {
        Yaml yaml = new Yaml();
        yaml.load(stryaml);
        conf.setYamlFieldvalueMapping(stryaml);
        return conf;
    }

    public Map<String, RequirementReference> findKnownRequirements(Collection<String> keys, RemoteSynchronisation remoteSynchronisation) {
        Session session = this.getSession();
        HashMap<String, RequirementReference> result = new HashMap<String, RequirementReference>();
        if (keys.isEmpty()) {
            return result;
        }
        List idsList = session.createQuery(ID_AND_KEY_BY_KEY).setParameterList("keys", keys, (Type)StringType.INSTANCE).setParameter("remoteSyncId", (Object)remoteSynchronisation.getId()).list();
        Map<Long, String> idsMap = this.tupleToMap(idsList);
        if (idsMap.keySet().isEmpty()) {
            return result;
        }
        List pathList = session.getNamedQuery("RequirementPathEdge.findPathsByIds").setParameterList("nodeIds", idsMap.keySet()).list();
        Map<Long, String> pathById = this.tupleToMap(pathList);
        for (Map.Entry<Long, String> entry : pathById.entrySet()) {
            Long id = entry.getKey();
            String path = entry.getValue();
            path = path.replace("/", "\\/").replace("\u001f", "/");
            String key = idsMap.get(id);
            result.put(key, new RequirementReference(id, path));
        }
        return result;
    }

    public Map<Long, Set<Long>> versionAndMilestoneIdsByRemoteKeys(Collection<String> remoteKeys, Long projectId) {
        if (remoteKeys.isEmpty()) {
            return new HashMap<Long, Set<Long>>();
        }
        QRequirement req = QRequirement.requirement;
        QRequirementSyncExtender sync = QRequirementSyncExtender.requirementSyncExtender;
        QMilestone mile = QMilestone.milestone;
        QRequirementVersion vers = QRequirementVersion.requirementVersion;
        QProject proj = QProject.project;
        HibernateQuery query = new HibernateQuery(this.getSession());
        Map res = (Map)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)query.select((Expression)vers.id).from((EntityPath)sync)).innerJoin((EntityPath)sync.requirement, (Path)req)).innerJoin((EntityPath)req.resource, (Path)vers)).innerJoin((EntityPath)req.project, (Path)proj)).innerJoin((CollectionExpression)vers.milestones, (Path)mile)).where((Predicate)proj.id.eq((Object)projectId).and((Predicate)sync.remoteReqId.in(remoteKeys)))).groupBy((Expression)vers.id)).groupBy((Expression)mile.id)).transform(GroupBy.groupBy((Expression)vers.id).as((Expression)GroupBy.set((Expression)mile.id)));
        return res;
    }

    public void resetLastSyncDate(RemoteSynchronisation remoteSynchronisation) {
        this.DSL.update((Table)Tables.REQUIREMENT_SYNC_EXTENDER).set((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_LAST_UPDATED, (Object)new Timestamp(0L)).where(new Condition[]{Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisation.getId())}).execute();
    }

    public Map<String, Timestamp> findKnownIssueKeyAndDate(JiraRemoteSynchronisation remoteSynchronisation) {
        return this.DSL.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_LAST_UPDATED).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).where(new Condition[]{Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisation.getId())}).fetch().stream().collect(Collectors.toMap(r -> (String)r.get((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID), r -> (Timestamp)r.get((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_LAST_UPDATED)));
    }

    public List<String> findAllKeys(Long remoteSyncId) {
        return this.DSL.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).where(new Condition[]{Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSyncId)}).orderBy((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID).fetch((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, String.class);
    }

    public Map<String, Long> findSynchronizedRequirementIds(Long remoteSynchronisationId) {
        return this.DSL.select((SelectField)Tables.REQUIREMENT.RLN_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID).from((TableLike)Tables.REQUIREMENT).innerJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(new Condition[]{Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)}).where(new Condition[]{Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisationId)}).fetch().stream().collect(Collectors.toMap(r -> (String)r.get((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID), r -> (Long)r.get((Field)Tables.REQUIREMENT.RLN_ID)));
    }

    public void removeAllCreationEvent(Collection<Long> versionIds) {
        if (versionIds.isEmpty()) {
            return;
        }
        org.hibernate.Query q = this.getSession().createQuery(RMV_CREAT_EVT);
        q.setParameterList("vIds", versionIds, (Type)LongType.INSTANCE);
        q.executeUpdate();
    }

    public void persist(RequirementAuditEvent event) {
        this.getSession().persist((Object)event);
    }

    private Map<Long, String> tupleToMap(List<Object[]> tuples) {
        HashMap<Long, String> res = new HashMap<Long, String>();
        for (Object[] tuple : tuples) {
            res.put((Long)tuple[0], (String)tuple[1]);
        }
        return res;
    }

    private Session getSession() {
        return (Session)this.em.unwrap(Session.class);
    }

    public Long findTargetFolderId(Long remoteSynchronisationId) {
        this.em.flush();
        return (Long)this.DSL.select((SelectField)Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.REQUIREMENT_FOLDER_ID).from((TableLike)Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER).where(new Condition[]{Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisationId)}).and(Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.TYPE.eq((Object)RequirementFolderSyncExtenderType.TARGET.name())).fetchOne((Field)Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.REQUIREMENT_FOLDER_ID);
    }

    public Long findSprintFolderId(String sprintId, Long remoteSynchronisationId) {
        this.em.flush();
        return (Long)this.DSL.select((SelectField)Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.REQUIREMENT_FOLDER_ID).from((TableLike)Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER).where(new Condition[]{Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisationId)}).and(Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.REMOTE_FOLDER_ID.eq((Object)sprintId)).and(Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.TYPE.eq((Object)RequirementFolderSyncExtenderType.SPRINT.name())).fetchOne((Field)Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.REQUIREMENT_FOLDER_ID);
    }

    public Long findSprintFolderExtenderId(Long requirementFolderId) {
        this.em.flush();
        return (Long)this.DSL.select((SelectField)Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.RF_SYNC_EXTENDER_ID).from((TableLike)Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER).where(new Condition[]{Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.REQUIREMENT_FOLDER_ID.eq((Object)requirementFolderId)}).fetchOne((Field)Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.RF_SYNC_EXTENDER_ID);
    }

    public boolean isRequirementInSynchronizedFolder(long remoteSynchronisationId, String issueKey, long requirementFolderId) {
        this.em.flush();
        Integer count = (Integer)this.DSL.selectCount().from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(new Condition[]{Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)}).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.eq((Object)issueKey)).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisationId)).where(new Condition[]{Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Object)requirementFolderId)}).fetchOneInto(Integer.class);
        return count > 0;
    }

    public Map<String, Long> findReqIdAndJiraKeyInSynchronizedFolder(long remoteSynchronisationId, List<String> issueKeys, long synchronizedFolderId) {
        this.em.flush();
        return this.DSL.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(new Condition[]{Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)}).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.in(issueKeys)).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisationId)).where(new Condition[]{Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Object)synchronizedFolderId)}).fetchMap((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID);
    }

    public long findRequirementId(String issueKey, Long remoteSyncId) {
        this.em.flush();
        return (Long)this.DSL.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).where(new Condition[]{Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.eq((Object)issueKey)}).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSyncId)).fetchOne((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID);
    }

    public Map<Long, List<String>> findSubtaskToMove(Long remoteSyncId, Set<String> issueKey) {
        this.em.flush();
        RequirementSyncExtender subtask = Tables.REQUIREMENT_SYNC_EXTENDER.as("subtask");
        RequirementSyncExtender parent = Tables.REQUIREMENT_SYNC_EXTENDER.as("parent");
        return this.DSL.select((SelectField)parent.REQUIREMENT_ID, (SelectField)subtask.REMOTE_REQ_ID).from((TableLike)subtask).innerJoin((TableLike)parent).on(new Condition[]{subtask.REMOTE_PARENT_ID.eq((Field)parent.REMOTE_REQ_ID)}).and(subtask.REMOTE_SYNCHRONISATION_ID.eq((Field)parent.REMOTE_SYNCHRONISATION_ID)).leftAntiJoin((TableLike)Tables.RLN_RELATIONSHIP).on(new Condition[]{Tables.RLN_RELATIONSHIP.ANCESTOR_ID.eq((Field)parent.REQUIREMENT_ID)}).and(Tables.RLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)subtask.REQUIREMENT_ID)).where(new Condition[]{parent.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSyncId)}).and(subtask.REMOTE_REQ_ID.in(issueKey)).fetch().stream().collect(Collectors.groupingBy(r -> (Long)r.get((Field)requirementSyncExtender.REQUIREMENT_ID), Collectors.mapping(r -> (String)r.get((Field)requirementSyncExtender.REMOTE_REQ_ID), Collectors.toList())));
    }

    public Set<String> findIssueKeyInSprintSubFolder(Long remoteSynchronisationId, Long squashFolderSprintId) {
        this.em.flush();
        List keys = this.DSL.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).innerJoin((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).on(new Condition[]{Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)}).and(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Object)squashFolderSprintId)).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisationId)).fetch((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID);
        return new HashSet<String>(keys);
    }

    public Map<Long, Map<String, List<Long>>> getReqIdsByServerAndByKey() {
        HashMap<Long, Map<String, List<Long>>> result = new HashMap<Long, Map<String, List<Long>>>();
        this.DSL.select((SelectField)Tables.REMOTE_SYNCHRONISATION.SERVER_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).innerJoin((TableLike)Tables.REMOTE_SYNCHRONISATION).on(new Condition[]{Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Field)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID)}).where(new Condition[]{Tables.REMOTE_SYNCHRONISATION.KIND.eq((Object)"squash.tm.plugin.jirasync")}).fetch().stream().collect(Collectors.groupingBy(r -> (Long)r.get((Field)Tables.REMOTE_SYNCHRONISATION.SERVER_ID))).forEach((serverId, records) -> {
            Map reqIdsByJiraKey = records.stream().collect(Collectors.groupingBy(r -> (String)r.get((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID), Collectors.mapping(r -> (Long)r.get((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID), Collectors.toList())));
            result.put((Long)serverId, reqIdsByJiraKey);
        });
        return result;
    }

    public void deleteJiraRemoteSynchronisation(Long syncId) {
        Collection<Long> reqIds = this.findSynchronizedRequirementIds(syncId).values();
        this.DSL.update((Table)Tables.REQUIREMENT).set((Field)Tables.REQUIREMENT.MODE, (Object)ManagementMode.NATIVE.name()).where(new Condition[]{Tables.REQUIREMENT.RLN_ID.in(reqIds)}).execute();
        this.DSL.delete((Table)Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER).where(new Condition[]{Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)syncId)}).execute();
        this.DSL.delete((Table)Tables.REQUIREMENT_SYNC_EXTENDER).where(new Condition[]{Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)syncId)}).execute();
        this.DSL.delete((Table)Tables.REMOTE_SYNCHRONISATION).where(new Condition[]{Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID.eq((Object)syncId)}).execute();
    }

    public Set<Long> findReqIdEligibleToBeMoved(long remoteSynchronisationId, Collection<String> issuesThatShouldMoveToSprintFolder, Long targetFolderId) {
        Map<String, Long> jiraKeyByReqId = this.findReqIdAndJiraKeyEligibleToBeMoved(remoteSynchronisationId, issuesThatShouldMoveToSprintFolder, targetFolderId);
        return new HashSet<Long>(jiraKeyByReqId.values());
    }

    public Map<String, Long> findReqIdAndJiraKeyEligibleToBeMoved(long remoteSynchronisationId, Collection<String> issuesThatShouldMoveToSprintFolder, Long targetFolderId) {
        this.em.flush();
        RequirementSyncExtender subtask = Tables.REQUIREMENT_SYNC_EXTENDER.as("subtask");
        RequirementSyncExtender parent = Tables.REQUIREMENT_SYNC_EXTENDER.as("parent");
        return this.DSL.select((SelectField)subtask.REMOTE_REQ_ID, (SelectField)subtask.REQUIREMENT_ID).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)subtask).on(new Condition[]{Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)subtask.REQUIREMENT_ID)}).and(subtask.REMOTE_REQ_ID.in(issuesThatShouldMoveToSprintFolder)).and(subtask.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisationId)).leftAntiJoin((TableLike)parent).on(new Condition[]{parent.REMOTE_REQ_ID.eq((Field)subtask.REMOTE_PARENT_ID)}).and(parent.REMOTE_SYNCHRONISATION_ID.eq((Field)subtask.REMOTE_SYNCHRONISATION_ID)).where(new Condition[]{Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Object)targetFolderId)}).fetchMap((Field)subtask.REMOTE_REQ_ID, (Field)subtask.REQUIREMENT_ID);
    }
}

