/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.importer;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import jirasync.com.atlassian.jira.rest.client.api.domain.Issue;
import jirasync.com.atlassian.jira.rest.client.api.domain.IssueField;
import jirasync.org.codehaus.jettison.json.JSONObject;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.domain.event.RequirementAuditEvent;
import org.squashtest.tm.domain.event.SyncRequirementCreation;
import org.squashtest.tm.domain.event.SyncRequirementUpdate;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementSyncExtender;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.plugin.jirasync.domain.BuiltinSquashField;
import org.squashtest.tm.plugin.jirasync.domain.JiraRemoteSynchronisation;
import org.squashtest.tm.plugin.jirasync.domain.RequirementReference;
import org.squashtest.tm.plugin.jirasync.helpers.JiraHelper;
import org.squashtest.tm.plugin.jirasync.helpers.JiraValue;
import org.squashtest.tm.plugin.jirasync.helpers.SquashHelper;
import org.squashtest.tm.plugin.jirasync.importer.ImporterState;
import org.squashtest.tm.plugin.jirasync.repository.PluginRequirementDao;
import org.squashtest.tm.plugin.jirasync.service.SynchronisationEffectiveConfiguration;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.importer.ImportMode;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.internal.batchimport.FacilityImpl;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.RequirementTarget;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionInstruction;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionTarget;
import org.squashtest.tm.service.internal.importer.ExcelRowReaderUtils;
import org.squashtest.tm.service.internal.repository.RequirementSyncExtenderDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;

@Component(value="squash.tm.plugin.jirasync.importer")
@Scope(value="prototype")
public class JiraRequirementImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraRequirementImporter.class);
    private static final Set<String> BUILTIN_FIELDS = new HashSet<String>();
    @Inject
    private PluginRequirementDao pluginRequirementDao;
    @Inject
    private FacilityImpl importer;
    @Inject
    private RequirementSyncExtenderDao reqsyncDao;
    @Inject
    private SquashHelper squashHelper;
    @Inject
    private JiraHelper jiraHelper;
    @Inject
    private InternationalizationHelper lang;
    @Inject
    private RequirementLibraryNavigationService navService;
    @Inject
    private RequirementVersionManagerService managService;
    @Inject
    private ActiveMilestoneHolder milestoneHolder;
    @PersistenceContext
    private EntityManager entityManager;
    private BugTracker server;
    private Project project;
    private SynchronisationEffectiveConfiguration conf;
    private ImporterState state;
    private Locale locale;
    private Map<String, RequirementReference> knownRequirementPaths;
    private Map<Long, Set<Long>> versionAndMilestoneIds;

    static {
        BuiltinSquashField[] builtinSquashFieldArray = BuiltinSquashField.values();
        int n = builtinSquashFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuiltinSquashField field = builtinSquashFieldArray[n2];
            BUILTIN_FIELDS.add(field.toString());
            ++n2;
        }
    }

    public void setServer(BugTracker server) {
        this.server = server;
    }

    public void setProject(Project p) {
        this.project = p;
    }

    public void setState(ImporterState state) {
        this.state = state;
    }

    public void setConfiguration(SynchronisationEffectiveConfiguration conf) {
        this.conf = conf;
    }

    public void configure() {
        this.locale = LocaleContextHolder.getLocale();
        this.squashHelper.initForProject(this.project, this.conf.getValueMappings());
    }

    public void importJiraTickets(Iterable<Issue> jiraIssues, JiraRemoteSynchronisation jiraRemoteSynchronisation, MultiMap desynchronisedIssueKeys, Map<String, String> issuesDescription) {
        this.conf.getEpicLinkId();
        List keys = (List)desynchronisedIssueKeys.getOrDefault((Object)"UPDATE", new ArrayList());
        ArrayList<RequirementVersionInstruction> instructions = new ArrayList<RequirementVersionInstruction>(keys.size());
        this.cacheKnownRequirementsData(new HashSet<String>(keys), jiraRemoteSynchronisation.getRemoteSynchronisation());
        for (Issue issue : jiraIssues) {
            String htmlDescription = issuesDescription.get(issue.getKey());
            RequirementVersionInstruction instruction = this.knows(issue.getKey()) ? this.updateRequirement(issue, jiraRemoteSynchronisation, htmlDescription) : this.createRequirement(issue, jiraRemoteSynchronisation, htmlDescription);
            if (instruction.isFatalError()) continue;
            instructions.add(instruction);
            this.state.setHadFailureOnFieldImport(true);
        }
        this.postProcess(instructions);
        this.state.addProcessedReqs(keys);
    }

    private RequirementVersionInstruction createRequirement(Issue issue, JiraRemoteSynchronisation jiraRemoteSynchronisation, String htmlDescription) {
        LogTrain logs;
        RequirementVersionInstruction instruction = this.createInstruction(issue, jiraRemoteSynchronisation, htmlDescription);
        instruction.setMode(ImportMode.CREATE);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("attempting to create requirement version '" + ((RequirementVersionTarget)instruction.getTarget()).getPath() + "'");
        }
        if (!(logs = this.importer.createRequirementVersion(instruction)).hasCriticalErrors()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("import went with no critical errors " + logs.getEntries().size());
            }
            Requirement req = instruction.getRequirementVersion().getRequirement();
            RequirementSyncExtender extender = new RequirementSyncExtender();
            this.updateExtender(extender, issue, jiraRemoteSynchronisation);
            if (req.getSyncExtender() != null) {
                throw new IllegalArgumentException("this was supposed to be a new requirement !");
            }
            req.setSyncExtender(extender);
            extender.setRequirement(req);
            this.entityManager.persist((Object)extender);
        } else {
            this.logCriticalErrors(logs);
        }
        return instruction;
    }

    private RequirementVersionInstruction updateRequirement(Issue issue, JiraRemoteSynchronisation jiraRemoteSynchronisation, String htmlDescription) {
        LogTrain logs;
        RequirementVersionInstruction instruction = this.createInstruction(issue, jiraRemoteSynchronisation, htmlDescription);
        instruction.setMode(ImportMode.UPDATE);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("attempting to update requirement version '" + ((RequirementVersionTarget)instruction.getTarget()).getPath() + "' with new data");
        }
        if (!(logs = this.importer.updateRequirementVersion(instruction)).hasCriticalErrors()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("import went with no critical errors " + logs.getEntries().size());
            }
            RequirementSyncExtender extender = this.reqsyncDao.retrieveByRemoteKeyAndSyncId(issue.getKey(), Long.valueOf(jiraRemoteSynchronisation.getId()));
            this.updateExtender(extender, issue, jiraRemoteSynchronisation);
        } else {
            this.logCriticalErrors(logs);
        }
        return instruction;
    }

    private RequirementVersionInstruction createInstruction(Issue issue, JiraRemoteSynchronisation jiraRemoteSynchronisation, String htmlDescription) {
        RequirementVersion version = new RequirementVersion();
        version.setVersionNumber(1);
        new Requirement(version);
        HashMap<String, String> customFields = new HashMap<String, String>();
        this.populate(version, customFields, issue);
        version.getPropertySetter().setDescription(ExcelRowReaderUtils.escapeHTMLInsideTags((String)htmlDescription));
        String issueKey = issue.getKey();
        String path = "";
        if (this.knows(issueKey)) {
            path = this.knownRequirementPaths.get(issueKey).getRequirementPath();
        } else {
            String escvname = version.getName().replace("/", "\\/");
            path = String.valueOf(this.navService.getPathAsString(jiraRemoteSynchronisation.getTargetFolderId().longValue())) + "/" + escvname;
        }
        RequirementVersionInstruction instruction = this.wrapAsInstruction(version, customFields, path, issue.getKey(), jiraRemoteSynchronisation);
        return instruction;
    }

    private void populate(RequirementVersion version, Map<String, String> cufs, Issue jiraIssue) {
        Map<String, SynchronisationEffectiveConfiguration.EffectiveMapping> mapping = this.conf.getFieldMappings();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("parsing issue '" + jiraIssue.getKey() + "'");
        }
        for (Map.Entry<String, SynchronisationEffectiveConfiguration.EffectiveMapping> entry : mapping.entrySet()) {
            String squashField = entry.getKey();
            SynchronisationEffectiveConfiguration.EffectiveMapping jiraField = entry.getValue();
            if (!jiraField.invalid()) {
                JiraValue jiraValue = null;
                try {
                    jiraValue = this.jiraHelper.getFieldValue(jiraIssue, jiraField);
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("processing value '" + jiraValue.toString() + "' for mapped field '" + jiraField.toString() + "'");
                    }
                    if (BUILTIN_FIELDS.contains(squashField)) {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("setting builtin property '" + squashField + "' with value '" + jiraValue.toString() + "'");
                        }
                        this.squashHelper.setBuiltinProperty(version, BuiltinSquashField.valueOf(squashField), jiraValue);
                        continue;
                    }
                    String strValue = this.squashHelper.getCustomfieldValue(squashField, jiraValue);
                    cufs.put(squashField, strValue);
                }
                catch (IllegalArgumentException ex) {
                    this.state.setHadFailureOnFieldImport(true);
                    if (!LOGGER.isTraceEnabled()) continue;
                    LOGGER.error("an error occured while settings value for field '" + squashField + "' : " + ex.getMessage());
                }
                continue;
            }
            if (!LOGGER.isTraceEnabled()) continue;
            LOGGER.trace("skipping squash field " + squashField + " because the corresponding jira field doesn't exist");
        }
    }

    private RequirementVersionInstruction wrapAsInstruction(RequirementVersion version, Map<String, String> cufs, String path, String key, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        RequirementTarget treq = new RequirementTarget(path);
        treq.setRemoteKey(key);
        treq.setRemoteSynchronisationId(Long.valueOf(jiraRemoteSynchronisation.getId()));
        RequirementVersionTarget tversion = new RequirementVersionTarget(treq, null);
        RequirementVersionInstruction instr = new RequirementVersionInstruction(tversion, version);
        tversion.setVersion(Integer.valueOf(1));
        for (Map.Entry<String, String> cuf : cufs.entrySet()) {
            instr.addCustomField(cuf.getKey(), cuf.getValue());
        }
        return instr;
    }

    private void updateExtender(RequirementSyncExtender ext, Issue issue, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        ext.setServer(this.server);
        ext.setRemoteProjectId(issue.getProject().getKey());
        ext.setRemoteSynchronisation(jiraRemoteSynchronisation.getRemoteSynchronisation());
        ext.setRemoteReqId(issue.getKey());
        ext.setRemoteLastUpdated(issue.getUpdateDate().toDate());
        IssueField parent = issue.getField("parent");
        if (parent == null) {
            ext.setRemoteParentId(null);
        } else {
            JSONObject jsonParent = (JSONObject)parent.getValue();
            String key = jsonParent.optString("key");
            ext.setRemoteParentId(key);
        }
        String url = String.valueOf(StringUtils.appendIfMissing((String)this.server.getUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0])) + "browse/" + issue.getKey();
        try {
            ext.setRemoteUrl(new URL(url));
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.warn("could not set url correctly for issue '" + issue.getKey() + "', offending url being '" + url + "'");
        }
    }

    private void postProcess(List<RequirementVersionInstruction> instructions) {
        this.importer.postprocess(instructions);
        this.processAudit(instructions);
    }

    private void processAudit(List<RequirementVersionInstruction> instructions) {
        this.pluginRequirementDao.flush();
        String login = UserContextHolder.getUsername();
        HashSet<Long> versionIds = new HashSet<Long>();
        for (RequirementVersionInstruction instr : instructions) {
            SyncRequirementCreation evt;
            ImportMode mode = instr.getMode();
            RequirementVersion version = instr.getRequirementVersion();
            versionIds.add(version.getId());
            if (mode == ImportMode.CREATE) {
                evt = new SyncRequirementCreation(version, login);
                evt.setSource(version.getRequirement().getSyncExtender().getRemoteUrl().toString());
                this.pluginRequirementDao.persist((RequirementAuditEvent)evt);
                continue;
            }
            evt = new SyncRequirementUpdate(version, login);
            evt.setSource(version.getRequirement().getSyncExtender().getRemoteUrl().toString());
            this.pluginRequirementDao.persist((RequirementAuditEvent)evt);
        }
        this.pluginRequirementDao.removeAllCreationEvent(versionIds);
    }

    private void logCriticalErrors(LogTrain logs) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("some critical errors occured when importing that requirement :");
            for (LogEntry log : logs.getEntries()) {
                if (log.getStatus() != ImportStatus.FAILURE) continue;
                RequirementVersionTarget target = (RequirementVersionTarget)log.getTarget();
                LOGGER.trace(String.valueOf(target.getPath()) + " : " + this.lang.getMessage(log.getI18nError(), log.getErrorArgs(), log.getI18nError(), this.locale));
            }
        }
    }

    private void cacheKnownRequirementsData(Set<String> keys, RemoteSynchronisation remoteSynchronisation) {
        this.knownRequirementPaths = this.pluginRequirementDao.findKnownRequirements(keys, remoteSynchronisation);
        this.versionAndMilestoneIds = this.pluginRequirementDao.versionAndMilestoneIdsByRemoteKeys(keys, this.project.getId());
    }

    private boolean knows(String issueKey) {
        return this.knownRequirementPaths.containsKey(issueKey);
    }
}

