/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JiraValue {
    private List<String> values;

    private JiraValue(List<String> values) {
        this.values = values;
    }

    private JiraValue(String v) {
        this.values = new ArrayList<String>(1);
        this.values.add(v);
    }

    public String getFirst() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.get(0);
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getValues(String separator) {
        StringBuilder builder = new StringBuilder();
        for (String s : this.values) {
            builder.append(String.valueOf(s) + separator);
        }
        return builder.toString().replaceAll(String.valueOf(separator) + "$", "");
    }

    public String toString() {
        return "[" + this.getValues(", ") + "]";
    }

    public static JiraValue fromStrings(String ... values) {
        List<String> myvalues = Arrays.asList(values);
        return new JiraValue(myvalues);
    }

    public static JiraValue fromStrings(List<String> values) {
        return new JiraValue(values);
    }

    public static JiraValue fromOtherValues(JiraValue ... jiraValues) {
        ArrayList<String> values = new ArrayList<String>();
        JiraValue[] jiraValueArray = jiraValues;
        int n = jiraValues.length;
        int n2 = 0;
        while (n2 < n) {
            JiraValue v = jiraValueArray[n2];
            values.addAll(v.getValues());
            ++n2;
        }
        return new JiraValue(values);
    }

    public static JiraValue fromOtherValues(List<JiraValue> jiraValues) {
        ArrayList<String> values = new ArrayList<String>();
        for (JiraValue v : jiraValues) {
            values.addAll(v.getValues());
        }
        return new JiraValue(values);
    }
}

