/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.helpers;

import java.util.ArrayList;
import jirasync.com.atlassian.jira.rest.client.api.domain.IssueField;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonParser;
import jirasync.org.codehaus.jettison.json.JSONArray;
import jirasync.org.codehaus.jettison.json.JSONException;
import jirasync.org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.plugin.jirasync.helpers.AbstractValueFinder;
import org.squashtest.tm.plugin.jirasync.helpers.JiraValue;
import org.squashtest.tm.plugin.jirasync.helpers.JiraValueFinder;
import org.squashtest.tm.plugin.jirasync.jsonext.JsonPrimitiveParser;

abstract class IssueFieldValueFinder
extends AbstractValueFinder
implements JiraValueFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(IssueFieldValueFinder.class);
    protected final boolean isArray;
    protected final JiraValueFinder delegate;

    IssueFieldValueFinder(boolean isArray, JiraValueFinder delegate) {
        this.isArray = isArray;
        this.delegate = delegate;
    }

    static IssueFieldValueFinder create(boolean isArray, JsonParser<?, ?> parser, JiraValueFinder delegate) {
        if (JsonPrimitiveParser.class.isAssignableFrom(parser.getClass())) {
            return new FieldPrimitiveValueFinder(isArray, (JsonPrimitiveParser)parser, delegate);
        }
        return new FieldObjectValueFinder(isArray, (JsonObjectParser)parser, delegate);
    }

    @Override
    public JiraValue getValue(Object object) {
        IssueField field = (IssueField)object;
        Object parsed = this.isArray ? this.parseAsArray(field) : this.parseSingleValue(field);
        if (parsed != null) {
            return this.delegate.getValue(parsed);
        }
        return JiraValue.fromStrings(new String[0]);
    }

    private Object parseAsArray(IssueField field) {
        JSONArray payload;
        block5: {
            payload = null;
            payload = (JSONArray)field.getValue();
            if (payload != null) break block5;
            return null;
        }
        try {
            ArrayList<Object> array = new ArrayList<Object>(payload.length());
            int i = 0;
            while (i < payload.length()) {
                Object rawval = payload.get(i);
                Object value = this.parseValue(rawval);
                array.add(value);
                ++i;
            }
            return array;
        }
        catch (ClassCastException ex) {
            String warning = "could not process a jira custom field because we expected a payload of type JSONArray, but got instead '" + field.getValue().getClass() + "'";
            LOGGER.warn(warning, (Throwable)ex);
            throw new IllegalArgumentException(warning);
        }
        catch (JSONException ex) {
            String warning = "could not process a jira custom field because invalid json was supplied : '" + payload + "'";
            LOGGER.warn(warning, (Throwable)ex);
            throw new IllegalArgumentException(warning);
        }
    }

    private Object parseSingleValue(IssueField field) {
        Object payload;
        block4: {
            payload = null;
            payload = field.getValue();
            if (payload != null) break block4;
            return null;
        }
        try {
            Object singleValue = this.parseValue(payload);
            return singleValue;
        }
        catch (ClassCastException ex) {
            String warning = "could not process a jira custom field because we expected a payload of type JSONObject, but got instead '" + field.getValue().getClass() + "'";
            LOGGER.warn(warning, (Throwable)ex);
            throw new IllegalArgumentException(warning);
        }
        catch (JSONException ex) {
            String warning = "could not process a jira custom field because invalid json was supplied : '" + payload + "'";
            LOGGER.warn(warning, (Throwable)ex);
            throw new IllegalArgumentException(warning);
        }
    }

    @Override
    public String toString() {
        return "IssueFieldValueFinder -> " + this.delegate.toString();
    }

    protected abstract Object parseValue(Object var1) throws JSONException;

    static final class FieldObjectValueFinder
    extends IssueFieldValueFinder {
        private final JsonObjectParser<?> parser;

        FieldObjectValueFinder(boolean isArray, JsonObjectParser<?> parser, JiraValueFinder delegate) {
            super(isArray, delegate);
            this.parser = parser;
        }

        @Override
        protected Object parseValue(Object value) throws JSONException {
            return this.parser.parse((JSONObject)value);
        }
    }

    static final class FieldPrimitiveValueFinder
    extends IssueFieldValueFinder {
        private final JsonPrimitiveParser<?> parser;

        FieldPrimitiveValueFinder(boolean isArray, JsonPrimitiveParser<?> parser, JiraValueFinder delegate) {
            super(isArray, delegate);
            this.parser = parser;
        }

        @Override
        protected Object parseValue(Object value) throws JSONException {
            return this.parser.parse(value);
        }
    }
}

