/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.domain;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.synchronisation.SynchronisationStatus;
import org.squashtest.tm.plugin.jirasync.domain.JiraSelectType;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraBoard;
import org.squashtest.tm.web.internal.helper.JsonHelper;

public class JiraRemoteSynchronisation {
    private RemoteSynchronisation remoteSynchronisation;
    private JiraBoard board;
    private Long targetFolderId;
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraRemoteSynchronisation.class);
    public static final String KEY_SYNCHRONISATION_PATH = "synchronisationPath";
    public static final String KEY_ADDITIONAL_JQL = "additionalJQL";
    public static final String KEY_RESTRAIN_TO_ACTIVE_SPRINT = "restrainToActiveSprint";

    public JiraRemoteSynchronisation(RemoteSynchronisation remoteSynchronisation) {
        this.remoteSynchronisation = remoteSynchronisation;
    }

    public JiraRemoteSynchronisation(RemoteSynchronisation remoteSynchronisation, JiraBoard board) {
        this.remoteSynchronisation = remoteSynchronisation;
        this.board = board;
    }

    public RemoteSynchronisation getRemoteSynchronisation() {
        return this.remoteSynchronisation;
    }

    public String getSynchronisationPath() {
        try {
            Map conf = JsonHelper.deserialize((String)this.remoteSynchronisation.getOptions());
            Object rawPath = conf.get(KEY_SYNCHRONISATION_PATH);
            if (rawPath == null) {
                throw new IllegalArgumentException("Programmatic error, not key synchronisationPath in  " + this.remoteSynchronisation);
            }
            return JiraRemoteSynchronisation.computeSynchronisationPath(this.remoteSynchronisation.getProject().getName(), rawPath);
        }
        catch (Exception e) {
            LOGGER.error("Could not deserialize options for synchronisation " + this.remoteSynchronisation);
            throw new IllegalArgumentException(e);
        }
    }

    public static String computeSynchronisationPath(String projectName, Object rawPath) {
        return "/" + projectName + StringUtils.prependIfMissing((String)rawPath.toString(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    public void setSynchronisationPath(String synchronisationPath) {
        Map<String, Object> conf = this.getConfForUpdate();
        conf.put(KEY_SYNCHRONISATION_PATH, synchronisationPath);
        this.remoteSynchronisation.setOptions(JsonHelper.serialize(conf));
    }

    public String getAdditionalJQL() {
        Object jql;
        block3: {
            try {
                Map conf = JsonHelper.deserialize((String)this.remoteSynchronisation.getOptions());
                jql = conf.get(KEY_ADDITIONAL_JQL);
                if (jql != null) break block3;
                return "";
            }
            catch (Exception e) {
                LOGGER.error("Could not deserialize options for synchronisation " + this.remoteSynchronisation);
                throw new IllegalArgumentException(e);
            }
        }
        return jql.toString();
    }

    public void setAdditionalJQL(String jql) {
        Map<String, Object> conf = this.getConfForUpdate();
        conf.put(KEY_ADDITIONAL_JQL, jql);
        this.remoteSynchronisation.setOptions(JsonHelper.serialize(conf));
    }

    private Map<String, Object> getConfForUpdate() {
        Map<String, Object> conf;
        if (this.remoteSynchronisation.getOptions() == null) {
            conf = new HashMap<String, Object>();
        } else {
            try {
                conf = JsonHelper.deserialize((String)this.remoteSynchronisation.getOptions());
            }
            catch (IOException e) {
                LOGGER.error("Could not deserialize options for synchronisation " + this.remoteSynchronisation);
                throw new IllegalArgumentException(e);
            }
        }
        return conf;
    }

    public boolean isRestraintToActiveSprint() {
        try {
            Map conf = JsonHelper.deserialize((String)this.remoteSynchronisation.getOptions());
            Object rawOption = conf.get(KEY_RESTRAIN_TO_ACTIVE_SPRINT);
            return rawOption != null && Boolean.parseBoolean(rawOption.toString());
        }
        catch (Exception e) {
            LOGGER.error("Could not deserialize restrain to active sprint property for synchronisation " + this.remoteSynchronisation);
            throw new IllegalArgumentException(e);
        }
    }

    public void restraintToActiveSprint(boolean restrain) {
        Map<String, Object> conf = this.getConfForUpdate();
        conf.put(KEY_RESTRAIN_TO_ACTIVE_SPRINT, restrain);
        this.remoteSynchronisation.setOptions(JsonHelper.serialize(conf));
    }

    public Long getBoardId() {
        if (this.getSelectType().equals(JiraSelectType.BOARD.name())) {
            return this.board.getId();
        }
        throw new IllegalArgumentException("Programmatic error : you should not try to get board id on a no - board synchronisation : " + this.remoteSynchronisation.toString());
    }

    public long getId() {
        return this.remoteSynchronisation.getId();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("JiraRemoteSynchronisation{");
        sb.append(this.remoteSynchronisation.toString());
        sb.append('}');
        return sb.toString();
    }

    public String getSelectValue() {
        return this.remoteSynchronisation.getSelectValue();
    }

    public String getSelectType() {
        return this.remoteSynchronisation.getSelectType();
    }

    public BugTracker getServer() {
        return this.remoteSynchronisation.getServer();
    }

    public String getName() {
        return this.remoteSynchronisation.getName();
    }

    public void setSelectValue(String selectValue) {
        this.remoteSynchronisation.setSelectValue(selectValue);
    }

    public void setName(String name) {
        this.remoteSynchronisation.setName(name);
    }

    public void setKind(String kind) {
        this.remoteSynchronisation.setKind(kind);
    }

    public void setSelectType(String selectType) {
        this.remoteSynchronisation.setSelectType(selectType);
    }

    public void setLastSuccessfulSyncDate(Date lastSuccessfulSyncDate) {
        this.remoteSynchronisation.setLastSuccessfulSyncDate(lastSuccessfulSyncDate);
    }

    public void setLastSyncDate(Date lastSyncDate) {
        this.remoteSynchronisation.setLastSyncDate(lastSyncDate);
    }

    public Date getLastSuccessfulSyncDate() {
        return this.remoteSynchronisation.getLastSuccessfulSyncDate();
    }

    public Date getLastSyncDate() {
        return this.remoteSynchronisation.getLastSyncDate();
    }

    public void setProject(Project project) {
        this.remoteSynchronisation.setProject(project);
    }

    public void setServer(BugTracker server) {
        this.remoteSynchronisation.setServer(server);
    }

    public Project getProject() {
        return this.remoteSynchronisation.getProject();
    }

    public boolean isBoard() {
        return this.getSelectType().equals(JiraSelectType.BOARD.toString());
    }

    public boolean canHaveSprints() {
        return this.board.canHaveSprints();
    }

    public Long getTargetFolderId() {
        return this.targetFolderId;
    }

    public void setTargetFolderId(Long targetFolderId) {
        this.targetFolderId = targetFolderId;
    }

    public SynchronisationStatus getSynchronisationStatus() {
        return this.remoteSynchronisation.getSynchronisationStatus();
    }

    public SynchronisationStatus getLastSynchronisationStatus() {
        return this.remoteSynchronisation.getLastSynchronisationStatus();
    }
}

