/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.domain;

import java.util.ArrayList;
import java.util.List;
import jirasync.org.apache.commons.lang.StringUtils;
import org.squashtest.tm.plugin.jirasync.domain.BuiltinSquashField;

public class FieldMapping {
    private static final List<FieldMapping> BUILTIN_MAPPING = new ArrayList<FieldMapping>();
    private String squashField;
    private String jiraField;
    private boolean locked;

    static {
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.REFERENCE, "issuekey", true));
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.LABEL, "summary", true));
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.CRITICALITY, "priority", true));
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.DESCRIPTION, "description", true));
    }

    public FieldMapping() {
    }

    public FieldMapping(BuiltinSquashField squashField, String jiraField, boolean locked) {
        this.squashField = squashField.toString();
        this.jiraField = jiraField;
        this.locked = locked;
    }

    public FieldMapping(String squashFieldId, String jiraFieldId, boolean locked) {
        this.squashField = squashFieldId;
        this.jiraField = jiraFieldId;
        this.locked = locked;
    }

    public String getId() {
        return this.squashField;
    }

    public String getSquashField() {
        return this.squashField;
    }

    public void setSquashField(String squashField) {
        this.squashField = StringUtils.trim(squashField);
    }

    public String getJiraField() {
        return this.jiraField;
    }

    public void setJiraField(String jiraField) {
        this.jiraField = StringUtils.trim(jiraField);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public static List<FieldMapping> getBuiltinMapping() {
        return new ArrayList<FieldMapping>(BUILTIN_MAPPING);
    }

    public static FieldMapping byId(String id) {
        return new FieldMapping(id, null, false);
    }

    public String toString() {
        return String.valueOf(this.squashField) + "<->" + this.jiraField;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.squashField == null ? 0 : this.squashField.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldMapping other = (FieldMapping)obj;
        return !(this.squashField == null ? other.squashField != null : !this.squashField.equals(other.squashField));
    }
}

