/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.controller.model;

import java.util.Date;
import java.util.Locale;
import javax.inject.Inject;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.synchronisation.SynchronisationStatus;
import org.squashtest.tm.plugin.jirasync.controller.model.JiraRemoteSynchronisationModel;
import org.squashtest.tm.plugin.jirasync.domain.JiraRemoteSynchronisation;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;

@Component
@Scope(value="prototype")
public class JiraRemoteSynchronisationModelBuilder {
    @Inject
    private InternationalizationHelper inHelper;
    private static final String SELECT_TYPE_ROOT_KEY = "henix.jirasync.configuration.sync.type.";

    public JiraRemoteSynchronisationModel build(JiraRemoteSynchronisation sync) {
        Locale locale = LocaleContextHolder.getLocale();
        JiraRemoteSynchronisationModel model = new JiraRemoteSynchronisationModel();
        model.setId(sync.getId());
        model.setName(sync.getName());
        model.setServerName(sync.getServer().getName());
        model.setSynchronisationPath(sync.getSynchronisationPath());
        model.setSelectTypeConst(sync.getSelectType());
        String typeKey = SELECT_TYPE_ROOT_KEY + sync.getSelectType().toLowerCase();
        model.setSelectType(this.inHelper.internationalize(typeKey, locale));
        Date lastSyncDate = sync.getLastSyncDate();
        model.setLastSyncDate(this.inHelper.localizeDateWithDefaultToNever(lastSyncDate, locale));
        Date lastSuccessfulSyncDate = sync.getLastSuccessfulSyncDate();
        model.setLastSuccessfulSyncDate(this.inHelper.localizeDateWithDefaultToNever(lastSuccessfulSyncDate, locale));
        model.setSelectValue(sync.getSelectValue());
        model.setAdditionalJQL(sync.getAdditionalJQL());
        String label = "";
        if (sync.isBoard()) {
            label = sync.isRestraintToActiveSprint() ? this.inHelper.internationalize("label.True", locale) : this.inHelper.internationalize("label.False", locale);
        }
        model.setRestrainToActiveSprintValue(label);
        SynchronisationStatus synchronisationStatus = sync.getSynchronisationStatus();
        String i18nStatus = this.inHelper.internationalize("label." + synchronisationStatus.getI18nKey(), locale);
        model.setStatus(i18nStatus);
        SynchronisationStatus lastSynchronisationStatus = sync.getLastSynchronisationStatus();
        String i18nLastStatus = this.inHelper.internationalize("label." + lastSynchronisationStatus.getI18nKey(), locale);
        model.setLastStatus(i18nLastStatus);
        return model;
    }
}

