/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.controller.execplan;

import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jirasync.com.atlassian.jira.rest.client.api.RestClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.plugin.jirasync.controller.execplan.IterationFormMetadata;
import org.squashtest.tm.plugin.jirasync.controller.execplan.JiraBoards;
import org.squashtest.tm.plugin.jirasync.controller.execplan.JiraProjects;
import org.squashtest.tm.plugin.jirasync.controller.execplan.JiraServer;
import org.squashtest.tm.plugin.jirasync.domain.execplan.BoardSprints;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanIssue;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanSpecification;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanTestCase;
import org.squashtest.tm.plugin.jirasync.domain.execplan.JqlSearch;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ProjectReleases;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ReleasesSearch;
import org.squashtest.tm.plugin.jirasync.domain.execplan.SprintSearch;
import org.squashtest.tm.plugin.jirasync.service.execplan.ExecplanSynchronizationService;
import org.squashtest.tm.plugin.jirasync.service.execplan.SelectedNode;

@Controller
@RequestMapping(value={"jirasync"})
public class ExecplanSynchronizationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecplanSynchronizationController.class);
    @Inject
    private ExecplanSynchronizationService service;

    @RequestMapping(value={"/exec-plan-designer"})
    public String getDesigner(@RequestParam(value="campaigns", required=false) List<Long> campaignIds, @RequestParam(value="iterations", required=false) List<Long> iterationIds, Model model, Locale locale) {
        SelectedNode selectedNode = this.coerceSelectedNode(campaignIds, iterationIds);
        model.addAttribute("selectedNode", (Object)selectedNode);
        return "jirasync/execplan/execplan-designer.html";
    }

    @RequestMapping(value={"/campaigns/{id}/iterations/new"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public EntityReference createNewIteration(@RequestBody ExecplanSpecification specification, HttpServletResponse response) {
        Iteration iter = this.service.createIteration(specification);
        return this.toEntityReference(iter);
    }

    @RequestMapping(value={"/campaigns/{id}/test-plan"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public EntityReference updateCampaignExecutionPlan(@RequestBody ExecplanSpecification specification, HttpServletResponse response) {
        this.service.updateCampaignTestPlan(specification);
        return specification.getTarget();
    }

    @RequestMapping(value={"/iterations/{id}/test-plan"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public EntityReference updateIterationExecutionPlan(@RequestBody ExecplanSpecification specification, HttpServletResponse response) {
        this.service.updateIterationTestPlan(specification);
        return specification.getTarget();
    }

    @RequestMapping(value={"/exec-plan/test-cases/search-by-issues"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public List<ExecplanTestCase> findTestCasesForIssues(@RequestBody List<ExecplanIssue> issues) {
        return this.service.findCandidateTestCasesForTickets(issues);
    }

    @RequestMapping(value={"/campaigns/{id}/iterations/meta"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public IterationFormMetadata getIterationMetadataForCampaign(@PathVariable(value="id") long campaignId) {
        return this.service.findIterationMetadataForCampaign(campaignId);
    }

    @RequestMapping(value={"/servers"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<JiraServer> findAllSyncedJiraServers() {
        return this.service.findAllSyncedJiraServers().stream().map(bt -> new JiraServer((BugTracker)bt)).collect(Collectors.toList());
    }

    @RequestMapping(value={"/exec-plan/jql-resolver/search"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public List<ExecplanIssue> getIssuesByJql(@RequestBody JqlSearch jqlSearch) {
        return this.service.findIssuesForJQL(jqlSearch);
    }

    @RequestMapping(value={"/exec-plan/jira-projects"}, params={"selected-squash-project-id"}, method={RequestMethod.GET})
    @ResponseBody
    public JiraProjects getAvailableJiraProjects(@RequestParam(value="selected-squash-project-id") long squashProjectId) {
        List<String> forSelectedProject = this.service.findSyncedJiraProjectForSquashProject(squashProjectId);
        List<String> forAllProjects = this.service.findAllSyncedJiraProject();
        return new JiraProjects(squashProjectId, forSelectedProject, forAllProjects);
    }

    @RequestMapping(value={"/exec-plan/jira-projects/releases/search"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public ReleasesSearch searchAvailableReleases(@RequestBody ReleasesSearch search) {
        return this.service.findReleases(search);
    }

    @RequestMapping(value={"/exec-plan/jira-projects/releases/issues/search"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public List<ExecplanIssue> getIssuesByRelease(@RequestBody List<ProjectReleases> releases) {
        return this.service.findIssuesForReleases(releases);
    }

    @RequestMapping(value={"/exec-plan/jira-boards"}, params={"selected-squash-project-id"}, method={RequestMethod.GET})
    @ResponseBody
    public JiraBoards getAvailableJiraBoards(@RequestParam(value="selected-squash-project-id") long squashProjectId) {
        List<String> forSelectedProject = this.service.findSyncedBoardForSquashProject(squashProjectId);
        List<String> forAllProjects = this.service.findAllSyncedBoards();
        return new JiraBoards(squashProjectId, forSelectedProject, forAllProjects);
    }

    @RequestMapping(value={"/exec-plan/jira-boards/sprints/search"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public SprintSearch searchAvailableSprints(@RequestBody SprintSearch search, BindingResult validation) throws BindException {
        SprintSearch.SprintSearchValidator validator = new SprintSearch.SprintSearchValidator();
        validator.validate(search, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException(validation);
        }
        return this.service.findSprints(search);
    }

    @RequestMapping(value={"/exec-plan/jira-boards/sprints/issues/search"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public List<ExecplanIssue> getIssuesBySprints(@RequestBody List<BoardSprints> sprints) {
        return this.service.findIssuesForSprints(sprints);
    }

    @ExceptionHandler(value={RestClientException.class})
    public ModelAndView handleRemoteExceptions(HttpServletRequest req, HttpServletResponse resp, RestClientException ex) {
        resp.setStatus(HttpStatus.PRECONDITION_FAILED.value());
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new MappingJackson2JsonView());
        mav.addObject("jira-exception", (Object)ex);
        return mav;
    }

    private SelectedNode coerceSelectedNode(List<Long> campaignIds, List<Long> iterationIds) {
        EntityReference reference = null;
        if (campaignIds != null && !campaignIds.isEmpty()) {
            reference = new EntityReference(EntityType.CAMPAIGN, campaignIds.get(0));
        } else if (iterationIds != null && !iterationIds.isEmpty()) {
            reference = new EntityReference(EntityType.ITERATION, iterationIds.get(0));
        } else {
            throw new IllegalArgumentException("no target campaign or iteration provided");
        }
        return this.service.createSelectedNode(reference);
    }

    private EntityReference toEntityReference(Iteration iter) {
        return new EntityReference(EntityType.ITERATION, iter.getId());
    }
}

