/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.plugin.jirasync.controller.ConfigPageConfiguration;
import org.squashtest.tm.plugin.jirasync.controller.model.JiraRemoteSynchronisationModel;
import org.squashtest.tm.plugin.jirasync.controller.model.JiraRemoteSynchronisationModelBuilder;
import org.squashtest.tm.plugin.jirasync.controller.model.JiraSelectTypeModel;
import org.squashtest.tm.plugin.jirasync.domain.BuiltinSquashField;
import org.squashtest.tm.plugin.jirasync.domain.Configuration;
import org.squashtest.tm.plugin.jirasync.domain.FieldMapping;
import org.squashtest.tm.plugin.jirasync.domain.JiraRemoteSynchronisation;
import org.squashtest.tm.plugin.jirasync.domain.JiraSelectType;
import org.squashtest.tm.plugin.jirasync.service.ConfigurationService;
import org.squashtest.tm.service.bugtracker.BugTrackerManagerService;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.project.GenericProjectFinder;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.rest.RestThirdPartyServer;

@Controller(value="squash.tm.plugin.jirasync.configurationController")
@RequestMapping(value={"jirasync/project/{projectId}/configuration"})
public class ConfigurationController {
    private static final String LANG_FIELD_PREFIX = "henix.jirasync.fields.";
    private static final String LANG_SELECT_TYPE_PREFIX = "henix.jirasync.configuration.sync.type.";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationController.class);
    @Inject
    private BugTrackerManagerService btService;
    @Inject
    private ConfigurationService pluginService;
    @Inject
    private InternationalizationHelper i18nhelper;
    @Inject
    private CustomFieldBindingFinderService cufService;
    @Inject
    private GenericProjectFinder genericProjectFinder;
    @Inject
    private Provider<JiraRemoteSynchronisationModelBuilder> syncModelBuilderProvider;
    @Inject
    private CredentialsProvider credentialsProvider;

    @RequestMapping(method={RequestMethod.GET})
    public String getConfigurationPanel(@PathVariable(value="projectId") Long projectId, Model model) {
        ConfigPageConfiguration pageconf = new ConfigPageConfiguration();
        pageconf.setProjectId(projectId);
        List bugtrackers = this.btService.findByKind("jira.rest");
        bugtrackers.addAll(this.btService.findByKind("jira.xsquash"));
        pageconf.setServers(this.toRestServers(bugtrackers));
        pageconf.setSelectTypes(this.getSelectTypes());
        Map<String, String> fieldList = this.makeFieldList(projectId);
        pageconf.setAvailableFields(fieldList);
        Map<String, List<String>> valueMappings = this.makeValueMappingsList(projectId);
        pageconf.setValueMappingsHelper(valueMappings);
        List<JiraRemoteSynchronisation> jiraRemoteSynchronisations = this.pluginService.findRemoteSyncForProject(projectId);
        List<JiraRemoteSynchronisationModel> synchronisationModels = jiraRemoteSynchronisations.stream().map(jiraRemoteSynchronisation -> ((JiraRemoteSynchronisationModelBuilder)this.syncModelBuilderProvider.get()).build((JiraRemoteSynchronisation)jiraRemoteSynchronisation)).collect(Collectors.toList());
        pageconf.setSynchronisations(synchronisationModels);
        Configuration conf = this.pluginService.getConfigurationForProject(projectId);
        pageconf.setConfiguration(conf);
        model.addAttribute("pageconf", (Object)pageconf);
        model.addAttribute("project", (Object)this.genericProjectFinder.findById(projectId.longValue()));
        return "jirasync/configuration.html";
    }

    private List<JiraSelectTypeModel> getSelectTypes() {
        EnumSet<JiraSelectType> selectTypes = EnumSet.allOf(JiraSelectType.class);
        return selectTypes.stream().map(selectType -> {
            String key = LANG_SELECT_TYPE_PREFIX + selectType.name().toLowerCase();
            return new JiraSelectTypeModel(selectType.name(), key);
        }).collect(Collectors.toList());
    }

    @RequestMapping(value={"/sync"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public JiraRemoteSynchronisationModel createNewSync(@PathVariable(value="projectId") Long projectId, @RequestBody JiraRemoteSynchronisationModel newSyncModel) {
        LOGGER.debug("Try to create sync : " + newSyncModel + " in project " + projectId);
        JiraRemoteSynchronisation jiraRemoteSynchronisation = this.pluginService.addJiraRemoteSynchronisation(projectId, newSyncModel);
        return ((JiraRemoteSynchronisationModelBuilder)this.syncModelBuilderProvider.get()).build(jiraRemoteSynchronisation);
    }

    @RequestMapping(value={"/sync/{syncId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteSync(@PathVariable(value="syncId") List<String> syncIds) {
        for (String id : syncIds) {
            long syncId = Long.parseLong(id);
            LOGGER.debug("Try to delete sync : " + syncId);
            this.pluginService.deleteJiraRemoteSynchronisation(syncId);
        }
    }

    @RequestMapping(value={"/sync/{syncId}/name"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String updateSyncName(@PathVariable(value="syncId") String syncId, @RequestParam(value="value") String newName) {
        this.pluginService.changeSyncName(syncId, newName);
        return newName;
    }

    @RequestMapping(value={"/sync/{syncId}/selectValue"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String updateSyncSelectValue(@PathVariable(value="syncId") String syncId, @RequestParam(value="value") String newSelectValue) {
        this.pluginService.changeSyncSelectValue(syncId, newSelectValue);
        return newSelectValue;
    }

    @RequestMapping(value={"/sync/{syncId}/additionalJQL"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String updateSyncAdditionalJQL(@PathVariable(value="syncId") String syncId, @RequestParam(value="value") String additionalJQL) {
        this.pluginService.changeSyncAdditionalJQL(syncId, additionalJQL);
        return additionalJQL;
    }

    @RequestMapping(value={"/sync/{syncId}/full"}, method={RequestMethod.PUT})
    @ResponseBody
    public void forceFullSynchronisation(@PathVariable(value="syncId") Long syncId) {
        this.pluginService.commandFullSynchronisation(syncId);
    }

    @RequestMapping(value={"jira-field-test-status"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String updateJiraFieldStatus(@PathVariable(value="projectId") Long projectId, @RequestParam(value="value") String jiraStatusField) {
        this.pluginService.changeJiraStatusField(projectId, jiraStatusField);
        return jiraStatusField;
    }

    @RequestMapping(value={"jira-field-progress-redaction"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String updateJiraFieldRedaction(@PathVariable(value="projectId") Long projectId, @RequestParam(value="value") String jiraRedactionField) {
        this.pluginService.changeJiraRedactionField(projectId, jiraRedactionField);
        return jiraRedactionField;
    }

    @RequestMapping(value={"jira-field-redaction-ratio"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String updateJiraFieldRedactionRatio(@PathVariable(value="projectId") Long projectId, @RequestParam(value="value") String jiraRedactionRatioField) {
        this.pluginService.changeJiraRedactionRatioField(projectId, jiraRedactionRatioField);
        return jiraRedactionRatioField;
    }

    @RequestMapping(value={"jira-field-progress-verification"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String updateJiraFieldVerification(@PathVariable(value="projectId") Long projectId, @RequestParam(value="value") String jiraVerificationField) {
        this.pluginService.changeJiraVerificationField(projectId, jiraVerificationField);
        return jiraVerificationField;
    }

    @RequestMapping(value={"jira-field-verification-ratio"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String updateJiraFieldVerificationRatio(@PathVariable(value="projectId") Long projectId, @RequestParam(value="value") String jiraVerificationRatioField) {
        this.pluginService.changeJiraVerificationRatioField(projectId, jiraVerificationRatioField);
        return jiraVerificationRatioField;
    }

    @RequestMapping(value={"jira-field-progress-validation"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String updateJiraFieldValidation(@PathVariable(value="projectId") Long projectId, @RequestParam(value="value") String jiraValidationField) {
        this.pluginService.changeJiraValidationField(projectId, jiraValidationField);
        return jiraValidationField;
    }

    @RequestMapping(value={"jira-field-validation-ratio"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String updateJiraFieldValidationRatio(@PathVariable(value="projectId") Long projectId, @RequestParam(value="value") String jiraValidationRatioField) {
        this.pluginService.changeJiraValidationRatioField(projectId, jiraValidationRatioField);
        return jiraValidationRatioField;
    }

    @RequestMapping(value={"/mappings"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public void addFieldMapping(@PathVariable(value="projectId") Long projectId, @RequestBody FieldMapping newMapping) {
        this.pluginService.addFieldMapping(projectId, newMapping);
    }

    @RequestMapping(value={"/mappings/{id}/squashfield"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String changeMappingSquashField(@PathVariable(value="projectId") Long projectId, @PathVariable(value="id") String mappingId, @RequestParam(value="value") String squashField) {
        this.pluginService.updateFieldMappingSquashField(projectId, mappingId, squashField);
        return squashField;
    }

    @RequestMapping(value={"/mappings/{id}/jirafield"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String changeMappingJiraField(@PathVariable(value="projectId") Long projectId, @PathVariable(value="id") String mappingId, @RequestParam(value="value") String jiraField) {
        this.pluginService.updateFieldMappingJiraField(projectId, mappingId, jiraField);
        return jiraField;
    }

    @RequestMapping(value={"/mappings/{ids}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void removeFieldMappings(@PathVariable(value="projectId") Long projectId, @PathVariable(value="ids") List<String> mappingIds) {
        this.pluginService.removeFieldMappingsByIds(projectId, mappingIds);
    }

    @RequestMapping(value={"/valuemappings"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public void changeValueMappings(@PathVariable(value="projectId") Long projectId, @RequestParam(value="value") String newValue) {
        this.pluginService.updateValueMappings(projectId, newValue);
    }

    @RequestMapping(value={"/valuemappings"}, method={RequestMethod.GET})
    @ResponseBody
    public String retrieveValueMappings(@PathVariable(value="projectId") Long projectId) {
        Configuration conf = this.pluginService.getConfigurationForProject(projectId);
        return conf.getYamlFieldvalueMapping();
    }

    private Collection<RestThirdPartyServer> toRestServers(List<BugTracker> btrackers) {
        List<RestThirdPartyServer> servers = btrackers.stream().filter(bt -> this.credentialsProvider.hasAppLevelCredentials(bt)).map(bt -> new RestThirdPartyServer(bt.getId().longValue(), bt.getName(), bt.getUrl())).collect(Collectors.toList());
        String nullServerName = this.i18nhelper.internationalize("label.None", LocaleContextHolder.getLocale());
        RestThirdPartyServer nullServer = new RestThirdPartyServer(0L, nullServerName, null);
        servers.add(0, nullServer);
        return servers;
    }

    private Map<String, String> makeFieldList(Long projectId) {
        String label;
        String code;
        Locale locale = LocaleContextHolder.getLocale();
        HashMap<String, String> fields = new HashMap<String, String>();
        BuiltinSquashField[] builtinSquashFieldArray = BuiltinSquashField.values();
        int n = builtinSquashFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuiltinSquashField f = builtinSquashFieldArray[n2];
            code = f.toString();
            label = this.i18nhelper.getMessage(LANG_FIELD_PREFIX + code, null, "translation of " + code, locale);
            fields.put(code, label);
            ++n2;
        }
        List cufs = this.cufService.findCustomFieldsForProjectAndEntity(projectId.longValue(), BindableEntity.REQUIREMENT_VERSION);
        for (CustomFieldBinding cufB : cufs) {
            CustomField cf = cufB.getCustomField();
            code = cf.getCode();
            label = cf.getLabel();
            fields.put(code, label);
        }
        return fields;
    }

    private Map<String, List<String>> makeValueMappingsList(Long projectId) {
        LinkedHashMap<String, List<String>> valueMappings = new LinkedHashMap<String, List<String>>();
        GenericProject p = this.genericProjectFinder.findById(projectId.longValue());
        InfoList categories = p.getRequirementCategories();
        List<String> strCrits = Arrays.asList("critical", "major", "minor", "undefined");
        List<String> strStats = Arrays.asList("work_in_progress", "under_review", "approved", "obsolete");
        ArrayList<String> strCats = new ArrayList<String>(categories.getItems().size());
        boolean canLowercase = categories.getCode().equals("DEF_REQ_CAT");
        for (InfoListItem item : categories.getItems()) {
            String code = canLowercase ? item.getCode().toLowerCase() : item.getCode();
            strCats.add(code);
        }
        valueMappings.put("criticality", strCrits);
        valueMappings.put("category", strCats);
        valueMappings.put("status", strStats);
        return valueMappings;
    }
}

