/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.client;

import java.net.URI;
import java.util.Map;
import jirasync.com.atlassian.httpclient.api.HttpClient;
import jirasync.com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonParser;
import jirasync.com.atlassian.util.concurrent.Promise;
import jirasync.javax.ws.rs.core.UriBuilder;

public class RawJiraClient
extends AbstractAsynchronousRestClient {
    private static final String JIRA_BIZ_API = "/rest/api/latest";
    private static final String JIRA_SOFTWARE_API = "/rest/agile/latest";
    private URI serverUri;

    public RawJiraClient(URI serverUri, HttpClient client) {
        super(client);
        this.serverUri = serverUri;
    }

    public <T> Promise<T> getAndParseJiraBiz(String path, JsonParser<?, T> parser) {
        URI uri = UriBuilder.fromUri(this.serverUri).path(JIRA_BIZ_API + path).build(new Object[0]);
        return super.getAndParse(uri, parser);
    }

    public <T> Promise<T> getAndParseJiraBiz(String path, Map<String, String> parameters, JsonParser<?, T> parser) {
        UriBuilder builder = UriBuilder.fromUri(this.serverUri).path(JIRA_BIZ_API + path);
        parameters.forEach((param, value) -> {
            UriBuilder uriBuilder2 = builder.queryParam((String)param, value);
        });
        return super.getAndParse(builder.build(new Object[0]), parser);
    }

    public <T> Promise<T> getAndParseJiraSoftware(String path, JsonParser<?, T> parser) {
        URI uri = UriBuilder.fromUri(this.serverUri).path(JIRA_SOFTWARE_API + path).build(new Object[0]);
        return super.getAndParse(uri, parser);
    }

    public <T> Promise<T> getAndParseJiraSoftware(String path, Map<String, String> parameters, JsonParser<?, T> parser) {
        UriBuilder builder = UriBuilder.fromUri(this.serverUri).path(JIRA_SOFTWARE_API + path);
        parameters.forEach((param, value) -> {
            UriBuilder uriBuilder2 = builder.queryParam((String)param, value);
        });
        return super.getAndParse(builder.build(new Object[0]), parser);
    }
}

