/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.client;

import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import jirasync.com.atlassian.httpclient.api.HttpStatus;
import jirasync.com.atlassian.httpclient.api.Request;
import jirasync.com.atlassian.jira.rest.client.api.AuthenticationHandler;
import jirasync.com.atlassian.jira.rest.client.api.IssueRestClient;
import jirasync.com.atlassian.jira.rest.client.api.JiraRestClient;
import jirasync.com.atlassian.jira.rest.client.api.MetadataRestClient;
import jirasync.com.atlassian.jira.rest.client.api.RestClientException;
import jirasync.com.atlassian.jira.rest.client.api.SearchRestClient;
import jirasync.com.atlassian.jira.rest.client.api.domain.Field;
import jirasync.com.atlassian.jira.rest.client.api.domain.FieldSchema;
import jirasync.com.atlassian.jira.rest.client.api.domain.FieldType;
import jirasync.com.atlassian.jira.rest.client.api.domain.SearchResult;
import jirasync.com.atlassian.jira.rest.client.api.domain.Version;
import jirasync.com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import jirasync.com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import jirasync.com.atlassian.jira.rest.client.internal.json.VersionJsonParser;
import jirasync.com.atlassian.util.concurrent.Promise;
import jirasync.org.apache.commons.lang.StringUtils;
import jirasync.org.apache.http.util.EncodingUtils;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.csp.core.bugtracker.net.AuthenticationCredentials;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.OAuth1aCredentials;
import org.squashtest.tm.plugin.jirasync.client.AsynchronousPluginRestClient;
import org.squashtest.tm.plugin.jirasync.client.ExtendedAsynchronousJiraRestClient;
import org.squashtest.tm.plugin.jirasync.client.FixedJiraClientFactory;
import org.squashtest.tm.plugin.jirasync.client.JiraReport;
import org.squashtest.tm.plugin.jirasync.domain.Configuration;
import org.squashtest.tm.plugin.jirasync.domain.FieldMapping;
import org.squashtest.tm.plugin.jirasync.domain.JiraSprintState;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanIssue;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraAgileIssue;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraBoard;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraHtmlIssueDescription;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraPagedResource;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraPaginatedResourceParser;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraSearchResult;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraSearchResultParser;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraSprint;
import org.squashtest.tm.plugin.jirasync.service.JiraReportingEffectiveConfiguration;
import org.squashtest.tm.plugin.jirasync.service.SynchronisationEffectiveConfiguration;
import org.squashtest.tm.plugin.jirasync.service.ValueMappings;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.yaml.snakeyaml.Yaml;

@Component(value="squash.tm.plugin.jirasync.jiraClient")
@Scope(value="prototype")
public class JiraClient
implements Closeable {
    public static final Set<AuthenticationProtocol> PROTOCOLS = ImmutableSet.builder().add((Object[])new AuthenticationProtocol[]{AuthenticationProtocol.BASIC_AUTH, AuthenticationProtocol.OAUTH_1A}).build();
    private static final Set<String> REQUIRED_SEARCHED_FIELDS = new HashSet<String>();
    public static final String SPRINT_FIELD_IDENTIFIER = "com.pyxis.greenhopper.jira:gh-sprint";
    public static final String MAX_RESULTS = "maxResults";
    public static final int DEFAULT_MAX_RESULTS = 100;
    public static final String START_AT = "startAt";
    public static final String JQL = "jql";
    public static final String FIELDS = "fields";
    public static final String ORDER_BY = "orderBy";
    private static final Logger LOGGER;
    @Inject
    private InternationalizationHelper langHelper;
    private JiraRestClient client;

    static {
        REQUIRED_SEARCHED_FIELDS.add("summary");
        REQUIRED_SEARCHED_FIELDS.add("issuetype");
        REQUIRED_SEARCHED_FIELDS.add("created");
        REQUIRED_SEARCHED_FIELDS.add("updated");
        REQUIRED_SEARCHED_FIELDS.add("project");
        REQUIRED_SEARCHED_FIELDS.add("status");
        LOGGER = LoggerFactory.getLogger(JiraClient.class);
    }

    @Deprecated
    public void initialize(BugTracker server, AuthenticationCredentials credentials) {
        this.initialize(server, (Credentials)new BasicAuthenticationCredentials(credentials.getUsername(), credentials.getPassword().toCharArray()));
    }

    public void initialize(BugTracker server, Credentials credentials) {
        URI uri;
        try {
            uri = server.getURL().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            String msg = this.langHelper.getMessage("henix.jirasync.validation.invalidurl", new Object[]{server.getUrl()}, "wrong url", LocaleContextHolder.getLocale());
            LOGGER.error(msg);
            throw new RuntimeException(msg);
        }
        AuthenticationHandler handler = JiraClient.createAuthHandler(credentials);
        LOGGER.trace("attempting to create the client using custom factory");
        this.client = new FixedJiraClientFactory().create(uri, handler);
        LOGGER.trace("client created successfully");
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (IOException ex) {
            LOGGER.error("could not close client : ", (Throwable)ex);
        }
    }

    public void checkCredentials() {
        try {
            this.client.getMetadataClient().getPriorities().claim();
        }
        catch (RestClientException ex) {
            Locale locale = LocaleContextHolder.getLocale();
            if (ex.getStatusCode().isPresent() && ((Integer)ex.getStatusCode().get()).equals(HttpStatus.UNAUTHORIZED.code)) {
                String msg = this.langHelper.getMessage("henix.jirasync.dummyconnector.accessdenied", null, "authentication failed", locale);
                throw new BugTrackerNoCredentialsException(msg, (Throwable)ex);
            }
            LOGGER.error("Error occured while checking the credentials", (Throwable)ex);
            Object[] erArgs = new Object[]{ex.getMessage()};
            String msg = this.langHelper.getMessage("henix.jirasync.dummyconnector.unexpectederror", erArgs, "an error occured", locale);
            throw new BugTrackerRemoteException(msg, (Throwable)ex);
        }
    }

    public SynchronisationEffectiveConfiguration createEffectiveConfiguration(Configuration userConf) {
        Yaml yaml;
        HashMap parsed;
        SynchronisationEffectiveConfiguration eff = new SynchronisationEffectiveConfiguration();
        eff.setSprintFieldId(this.findSprintFieldIdentifier());
        Map<String, SynchronisationEffectiveConfiguration.EffectiveMapping> mappings = this.createEffectiveFieldMap(userConf);
        eff.setFieldMappings(mappings);
        if (mappings.containsKey("(internal - Epic link)")) {
            eff.setEpicLinkId(mappings.get("(internal - Epic link)").getJiraField());
            mappings.remove("(internal - Epic link)");
        }
        if ((parsed = (HashMap)(yaml = new Yaml()).load(userConf.getYamlFieldvalueMapping())) == null) {
            parsed = new HashMap();
        }
        ValueMappings valueMappings = new ValueMappings(parsed);
        eff.setValueMappings(valueMappings);
        return eff;
    }

    public JiraReportingEffectiveConfiguration createJiraReportingEffectiveConfiguration(Configuration configuration) {
        JiraReportingEffectiveConfiguration effectiveConfiguration = new JiraReportingEffectiveConfiguration();
        MetadataRestClient metadataClient = this.client.getMetadataClient();
        Iterable<Field> fields = metadataClient.getFields().claim();
        Map fieldByName = StreamSupport.stream(fields.spliterator(), false).filter(field -> field.getFieldType().equals((Object)FieldType.CUSTOM)).collect(Collectors.toMap(Field::getName, Function.identity(), (u, v) -> {
            LOGGER.debug(String.format("Duplicate custom field key %s", u));
            return v;
        }, LinkedHashMap::new));
        this.configureRedactionProgressField(configuration, effectiveConfiguration, fieldByName);
        this.configureVerificationProgressField(configuration, effectiveConfiguration, fieldByName);
        this.configureValidationProgressField(configuration, effectiveConfiguration, fieldByName);
        this.configureRedactionRatioField(configuration, effectiveConfiguration, fieldByName);
        this.configureVerificationRatioField(configuration, effectiveConfiguration, fieldByName);
        this.configureValidationRatioField(configuration, effectiveConfiguration, fieldByName);
        this.configureStatusField(configuration, effectiveConfiguration, fieldByName);
        return effectiveConfiguration;
    }

    private void configureStatusField(Configuration configuration, JiraReportingEffectiveConfiguration effectiveConfiguration, Map<String, Field> fieldByName) {
        String statusField = configuration.getStatusField();
        if (fieldByName.containsKey(statusField)) {
            String id = fieldByName.get(statusField).getId();
            effectiveConfiguration.setJiraStatusFieldId(id);
            LOGGER.debug("[JIRA-SYNC] Found reporting field for Testing Status : {}", (Object)id);
        } else {
            LOGGER.debug("[JIRA-SYNC] Not found reporting field for Testing Status. No reporting will be done to JIRA for Testing Status. Conf was : {}", (Object)statusField);
        }
    }

    private void configureValidationProgressField(Configuration configuration, JiraReportingEffectiveConfiguration effectiveConfiguration, Map<String, Field> fieldByName) {
        String validationProgressField = configuration.getValidationProgressField();
        if (fieldByName.containsKey(validationProgressField)) {
            String id = fieldByName.get(validationProgressField).getId();
            effectiveConfiguration.setJiraValidationProgressFieldId(id);
            LOGGER.debug("[JIRA-SYNC] Found reporting field for Validation Progress rate : {}", (Object)id);
        } else {
            LOGGER.debug("[JIRA-SYNC] Not found reporting field for Validation Progress rate. No reporting will be done to JIRA for Validation Progress.  Conf was : {}", (Object)validationProgressField);
        }
    }

    private void configureValidationRatioField(Configuration configuration, JiraReportingEffectiveConfiguration effectiveConfiguration, Map<String, Field> fieldByName) {
        String validationRatioField = configuration.getValidationRatioField();
        if (fieldByName.containsKey(validationRatioField)) {
            String id = fieldByName.get(validationRatioField).getId();
            effectiveConfiguration.setJiraValidationRatioFieldId(id);
            LOGGER.debug("[JIRA-SYNC] Found reporting field for Validation Ratio rate : {}", (Object)id);
        } else {
            LOGGER.debug("[JIRA-SYNC] Not found reporting field for Validation Ratio rate. No reporting will be done to JIRA for Validation Ratio.  Conf was : {}", (Object)validationRatioField);
        }
    }

    private void configureVerificationProgressField(Configuration configuration, JiraReportingEffectiveConfiguration effectiveConfiguration, Map<String, Field> fieldByName) {
        String verificationProgressField = configuration.getVerificationProgressField();
        if (fieldByName.containsKey(verificationProgressField)) {
            String id = fieldByName.get(verificationProgressField).getId();
            effectiveConfiguration.setJiraVerificationProgressFieldId(id);
            LOGGER.debug("[JIRA-SYNC] Found reporting field for Verification Progress rate : {}", (Object)id);
        } else {
            LOGGER.debug("[JIRA-SYNC] Not found reporting field for Verification Progress rate. No reporting will be done to JIRA for Verification Progress. Conf was : {}", (Object)verificationProgressField);
        }
    }

    private void configureVerificationRatioField(Configuration configuration, JiraReportingEffectiveConfiguration effectiveConfiguration, Map<String, Field> fieldByName) {
        String verificationRatioField = configuration.getVerificationRatioField();
        if (fieldByName.containsKey(verificationRatioField)) {
            String id = fieldByName.get(verificationRatioField).getId();
            effectiveConfiguration.setJiraVerificationRatioFieldId(id);
            LOGGER.debug("[JIRA-SYNC] Found reporting field for Verification Ratio rate : {}", (Object)id);
        } else {
            LOGGER.debug("[JIRA-SYNC] Not found reporting field for Verification Ratio rate. No reporting will be done to JIRA for Verification Ratio. Conf was : {}", (Object)verificationRatioField);
        }
    }

    private void configureRedactionProgressField(Configuration configuration, JiraReportingEffectiveConfiguration effectiveConfiguration, Map<String, Field> fieldByName) {
        String redactionProgressField = configuration.getRedactionProgressField();
        if (fieldByName.containsKey(redactionProgressField)) {
            String id = fieldByName.get(redactionProgressField).getId();
            effectiveConfiguration.setJiraRedactionProgressFieldId(id);
            LOGGER.debug("[JIRA-SYNC] Found reporting field for Redaction Progress rate : {}", (Object)id);
        } else {
            LOGGER.debug("[JIRA-SYNC] Not found reporting field for Redaction Progress rate. No reporting will be done to JIRA for Redaction Progress. Conf was : {}", (Object)redactionProgressField);
        }
    }

    private void configureRedactionRatioField(Configuration configuration, JiraReportingEffectiveConfiguration effectiveConfiguration, Map<String, Field> fieldByName) {
        String redactionRatioField = configuration.getRedactionRatioField();
        if (fieldByName.containsKey(redactionRatioField)) {
            String id = fieldByName.get(redactionRatioField).getId();
            effectiveConfiguration.setJiraRedactionRatioFieldId(id);
            LOGGER.debug("[JIRA-SYNC] Found reporting field for Redaction Ratio rate : {}", (Object)id);
        } else {
            LOGGER.debug("[JIRA-SYNC] Not found reporting field for Redaction Ratio. No reporting will be done to JIRA for Redaction Ratio. Conf was : {}", (Object)redactionRatioField);
        }
    }

    public void performReportingToJira(List<JiraReport> jiraReports, JiraReportingEffectiveConfiguration configuration) {
        IssueRestClient issueClient = this.client.getIssueClient();
        for (JiraReport jiraReport : jiraReports) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[JIRA-SYNC] - Posting Report to JIRA for Issue : {}", (Object)jiraReport.getKey());
            }
            ArrayList<FieldInput> inputs = new ArrayList<FieldInput>();
            if (configuration.hasValidStatusField() && jiraReport.shouldPostStatus()) {
                inputs.add(new FieldInput(configuration.getJiraStatusFieldId(), (Object)jiraReport.getStatusValue()));
            }
            if (configuration.hasValidRedactionField() && jiraReport.shouldPostRedactionRate()) {
                inputs.add(new FieldInput(configuration.getJiraRedactionProgressFieldId(), (Object)jiraReport.getRedactionRate()));
            }
            if (configuration.hasValidVerificationField() && jiraReport.shouldPostVerificationRate()) {
                inputs.add(new FieldInput(configuration.getJiraVerificationProgressFieldId(), (Object)jiraReport.getVerificationRate()));
            }
            if (configuration.hasValidValidationField() && jiraReport.shouldPostValidationRate()) {
                inputs.add(new FieldInput(configuration.getJiraValidationProgressFieldId(), (Object)jiraReport.getValidationRate()));
            }
            if (configuration.hasValidRedactionRatioField() && jiraReport.shouldPostRedactionRatio()) {
                inputs.add(new FieldInput(configuration.getJiraRedactionRatioFieldId(), (Object)jiraReport.getRedactionRatio()));
            }
            if (configuration.hasValidVerificationRatioField() && jiraReport.shouldPostVerificationRatio()) {
                inputs.add(new FieldInput(configuration.getJiraVerificationRatioFieldId(), (Object)jiraReport.getVerificationRatio()));
            }
            if (configuration.hasValidValidationRatioField() && jiraReport.shouldPostValidationRatio()) {
                inputs.add(new FieldInput(configuration.getJiraValidationRatioFieldId(), (Object)jiraReport.getValidationRatio()));
            }
            IssueInput issueInput = IssueInput.createWithFields(inputs.toArray(new FieldInput[inputs.size()]));
            try {
                issueClient.updateIssue(jiraReport.getKey(), issueInput).claim();
            }
            catch (RestClientException e) {
                LOGGER.warn("[JIRA-SYNC] - Error occurred when updating Jira Issue : {}", (Object)jiraReport.getKey(), (Object)e);
            }
        }
    }

    public Promise<SearchResult> getIssuesForFilter(Collection<String> values, Set<String> fields, int start, int maxres) {
        String jql = String.format("key IN (%s)", StringUtils.join(values, ","));
        SearchRestClient searcher = this.client.getSearchClient();
        HashSet<String> finalFields = new HashSet<String>(fields);
        finalFields.addAll(REQUIRED_SEARCHED_FIELDS);
        finalFields.add("issuefields");
        finalFields.add("parent");
        return searcher.searchJql(jql, maxres, start, finalFields);
    }

    public Long getBoardId(String boardName) {
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        AsynchronousPluginRestClient boardRestClient = extendedClient.getBoardRestClient();
        return boardRestClient.getBoardId(boardName);
    }

    public Iterable<JiraReport> getInitialReport(List<String> keys, JiraReportingEffectiveConfiguration configuration) {
        ExtendedAsynchronousJiraRestClient extendedClient = (ExtendedAsynchronousJiraRestClient)this.client;
        AsynchronousPluginRestClient boardRestClient = extendedClient.getBoardRestClient();
        return boardRestClient.getInitialReport(keys, configuration);
    }

    private ExtendedAsynchronousJiraRestClient getExtendedAsynchronousJiraRestClient() {
        return (ExtendedAsynchronousJiraRestClient)this.client;
    }

    public String getFilterForBoard(String boardName) {
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        AsynchronousPluginRestClient boardRestClient = extendedClient.getBoardRestClient();
        return boardRestClient.getBoardJQL(boardName);
    }

    public JiraBoard getBoard(String boardName) {
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        AsynchronousPluginRestClient boardRestClient = extendedClient.getBoardRestClient();
        return boardRestClient.getBoard(boardName);
    }

    public List<JiraSprint> getSprints(Long boardId, boolean activeOnly) {
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        AsynchronousPluginRestClient boardRestClient = extendedClient.getBoardRestClient();
        return boardRestClient.getSprints(boardId, activeOnly);
    }

    public List<JiraSprint> getSprints(Long boardId, JiraSprintState ... states) {
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        AsynchronousPluginRestClient boardRestClient = extendedClient.getBoardRestClient();
        return boardRestClient.getSprints(boardId, states);
    }

    public String findSprintFieldIdentifier() {
        Iterable<Field> fields = this.client.getMetadataClient().getFields().claim();
        Optional<Field> sprintField = StreamSupport.stream(fields.spliterator(), false).filter(field -> field != null && field.getSchema() != null).filter(field -> {
            FieldSchema schema = field.getSchema();
            String custom = schema.getCustom();
            return StringUtils.isNotBlank(custom) && custom.equals(SPRINT_FIELD_IDENTIFIER);
        }).findFirst();
        if (sprintField.isPresent()) {
            return sprintField.get().getId();
        }
        throw new IllegalArgumentException("Unable to find Sprint field identifier in metadata. Was looking for field : com.pyxis.greenhopper.jira:gh-sprint");
    }

    public Set<String> findIssuesForBackLog(Long boardId) {
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        AsynchronousPluginRestClient boardRestClient = extendedClient.getBoardRestClient();
        return boardRestClient.getBacklogIssueKeys(boardId);
    }

    public Set<String> findIssuesForSprint(Long sprintId) {
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        AsynchronousPluginRestClient boardRestClient = extendedClient.getBoardRestClient();
        return boardRestClient.getSprintIssueKeys(sprintId);
    }

    public Set<JiraAgileIssue> findIssuesForSprints(Long boardId, Collection<String> keys) {
        if (keys.isEmpty()) {
            return new HashSet<JiraAgileIssue>();
        }
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        AsynchronousPluginRestClient boardRestClient = extendedClient.getBoardRestClient();
        return boardRestClient.getAgileIssues(boardId, keys);
    }

    public Promise<SearchResult> getIssueForModificationChecking(String jql, int start, int maxres) {
        SearchRestClient searcher = this.client.getSearchClient();
        return searcher.searchJql(jql, maxres, start, REQUIRED_SEARCHED_FIELDS);
    }

    public Map<String, String> getIssuesDescription(List<String> keys, int processed, int fetchBatchSize) {
        if (keys.isEmpty()) {
            return new HashMap<String, String>();
        }
        ExtendedAsynchronousJiraRestClient extendedClient = (ExtendedAsynchronousJiraRestClient)this.client;
        AsynchronousPluginRestClient boardRestClient = extendedClient.getBoardRestClient();
        Iterable<JiraHtmlIssueDescription> issues = boardRestClient.getHtmlDescriptionIssues(keys, processed, fetchBatchSize);
        return StreamSupport.stream(issues.spliterator(), false).collect(Collectors.toMap(issue -> issue.getKey(), issue -> issue.getDescription()));
    }

    public Promise<JiraPagedResource<Version>> findPagedVersionsForProject(String projectKey, int pageNum, boolean orderByReleaseDateDesc) {
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        Map<String, String> options = this.defaultPaginationOptions();
        options.put(START_AT, String.valueOf(pageNum * 100));
        if (orderByReleaseDateDesc) {
            options.put(ORDER_BY, "-releaseDate");
        }
        return extendedClient.getAndParseJiraBiz("/project/" + projectKey + "/version", options, new JiraPaginatedResourceParser<Version>(new VersionJsonParser()));
    }

    public Promise<JiraSearchResult<ExecplanIssue>> findExecplanIssueForJql(String jql, int pageNum) {
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        Map<String, String> options = this.execplanPaginationOptions(pageNum);
        options.put(JQL, jql);
        ExecplanIssue.Parser issueParser = new ExecplanIssue.Parser();
        JiraSearchResultParser<ExecplanIssue> resultParser = new JiraSearchResultParser<ExecplanIssue>(issueParser);
        return extendedClient.getAndParseJiraBiz("/search", options, resultParser);
    }

    public Promise<JiraSearchResult<ExecplanIssue>> findExecplanIssuesForVersions(List<Long> versionIds, int pageNum) {
        String jql = versionIds.stream().map(id -> "fixVersion=" + id).collect(Collectors.joining(" or "));
        return this.findExecplanIssueForJql(jql, pageNum);
    }

    public Promise<JiraSearchResult<ExecplanIssue>> findExecplanIssuesForSprint(Long sprintId, int pageNum) {
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        Map<String, String> options = this.execplanPaginationOptions(pageNum);
        ExecplanIssue.Parser issueParser = new ExecplanIssue.Parser();
        JiraSearchResultParser<ExecplanIssue> resultParser = new JiraSearchResultParser<ExecplanIssue>(issueParser);
        return extendedClient.getAndParseJiraSoftware("/sprint/" + sprintId + "/issue", options, resultParser);
    }

    private Map<String, SynchronisationEffectiveConfiguration.EffectiveMapping> createEffectiveFieldMap(Configuration conf) {
        LOGGER.trace("fetching all fields available on jira");
        HashMap<String, SynchronisationEffectiveConfiguration.EffectiveMapping> mapping = new HashMap<String, SynchronisationEffectiveConfiguration.EffectiveMapping>();
        ArrayList<FieldMapping> mappingsToProcess = new ArrayList<FieldMapping>(conf.getFieldMappings());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("will try to find a match for the following mappings : ");
            for (FieldMapping todo : mappingsToProcess) {
                LOGGER.trace("\t " + todo.toString());
            }
        }
        Iterable<Field> actualFields = this.client.getMetadataClient().getFields().claim();
        boolean foundEpic = false;
        for (Field f : actualFields) {
            FieldSchema schema;
            if (mappingsToProcess.isEmpty() && foundEpic && !LOGGER.isTraceEnabled()) break;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("attempting to find a match for field {id : '" + f.getId() + "', name : '" + f.getName() + "'}");
            }
            Iterator mIterator = mappingsToProcess.iterator();
            while (mIterator.hasNext()) {
                FieldMapping m = (FieldMapping)mIterator.next();
                String squashField = m.getSquashField();
                String jiraField = m.getJiraField();
                if (!this.fieldsMatch(jiraField, f)) continue;
                SynchronisationEffectiveConfiguration.EffectiveMapping effective = this.newEffectiveMapping(f, squashField);
                mapping.put(squashField, effective);
                mIterator.remove();
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace("found a an effective mapping for squash field '" + squashField + "' : " + effective.toString());
            }
            if (foundEpic || (schema = f.getSchema()) == null || schema.getCustom() == null || !schema.getCustom().equals("com.pyxis.greenhopper.jira:gh-epic-link")) continue;
            mapping.put("(internal - Epic link)", new SynchronisationEffectiveConfiguration.EffectiveMapping("(internal - Epic link)", f.getId(), true));
            foundEpic = true;
        }
        for (FieldMapping m : mappingsToProcess) {
            mapping.put(m.getSquashField(), new SynchronisationEffectiveConfiguration.EffectiveMapping(m.getSquashField(), null, false));
        }
        LOGGER.trace("finished processing the jira fields");
        return mapping;
    }

    private SynchronisationEffectiveConfiguration.EffectiveMapping newEffectiveMapping(Field jiraField, String squashField) {
        String jiraId = jiraField.getId();
        boolean isCustom = this.isCustom(jiraField);
        SynchronisationEffectiveConfiguration.EffectiveMapping effective = new SynchronisationEffectiveConfiguration.EffectiveMapping(squashField, jiraId, isCustom);
        FieldSchema schema = jiraField.getSchema();
        if (schema != null) {
            effective.addCustomInfos(schema.getType(), schema.getItems());
        }
        return effective;
    }

    private boolean isCustom(Field jiraField) {
        return jiraField.getFieldType() == FieldType.CUSTOM;
    }

    private boolean fieldsMatch(String nameOrId, Field f) {
        return nameOrId.equals(f.getName()) || nameOrId.equals(f.getId());
    }

    private Map<String, String> defaultPaginationOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(MAX_RESULTS, String.valueOf(100));
        return options;
    }

    private Map<String, String> execplanPaginationOptions(int pageNum) {
        Map<String, String> options = this.defaultPaginationOptions();
        options.put(START_AT, String.valueOf(pageNum * 100));
        options.put(FIELDS, "self,key,status,assignee,summary,issuetype");
        return options;
    }

    private static final AuthenticationHandler createAuthHandler(Credentials credentials) {
        switch (credentials.getImplementedProtocol()) {
            case BASIC_AUTH: {
                BasicAuthenticationCredentials basicCreds = (BasicAuthenticationCredentials)credentials;
                return new Latin1BasicAuthHandler(basicCreds.getUsername(), new String(basicCreds.getPassword()));
            }
            case OAUTH_1A: {
                OAuth1aCredentials oauthCreds = (OAuth1aCredentials)credentials;
                return new OAuth1Handler(oauthCreds);
            }
        }
        throw new UnsupportedAuthenticationModeException(credentials.getImplementedProtocol().toString());
    }

    private static final class Latin1BasicAuthHandler
    implements AuthenticationHandler {
        private String username;
        private String password;

        Latin1BasicAuthHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void configure(Request request) {
            byte[] encoded = this.encode(this.username, this.password);
            request.setHeader("Authorization", "Basic " + new String(encoded));
        }

        private byte[] encode(String username, String password) {
            String toEncode = String.valueOf(username) + ":" + password;
            byte[] bytes = Base64.encodeBase64((byte[])EncodingUtils.getBytes(toEncode.toString(), StandardCharsets.ISO_8859_1.name()));
            return bytes;
        }
    }

    private static final class OAuth1Handler
    implements AuthenticationHandler {
        private OAuth1aCredentials credentials;
        private static final String HTTP_AUTHORIZATION = "Authorization";

        public OAuth1Handler(OAuth1aCredentials credentials) {
            this.credentials = credentials;
        }

        @Override
        public void configure(Request request) {
            String url = request.getUri().toString();
            String method = request.getMethod().toString();
            String header = this.credentials.createAuthorizationHeader(url, method);
            request.setHeader(HTTP_AUTHORIZATION, header);
        }
    }
}

