/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.client;

import java.lang.reflect.Field;
import java.net.URI;
import jirasync.com.atlassian.httpclient.apache.httpcomponents.DefaultHttpClient;
import jirasync.com.atlassian.jira.rest.client.api.AuthenticationHandler;
import jirasync.com.atlassian.jira.rest.client.api.JiraRestClient;
import jirasync.com.atlassian.jira.rest.client.internal.async.AsynchronousHttpClientFactory;
import jirasync.com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClient;
import jirasync.com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import jirasync.com.atlassian.jira.rest.client.internal.async.AtlassianHttpClientDecorator;
import jirasync.com.atlassian.jira.rest.client.internal.async.DisposableHttpClient;
import jirasync.org.apache.http.impl.nio.client.DefaultHttpAsyncClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.squashtest.tm.plugin.jirasync.client.ExtendedAsynchronousJiraRestClient;

public class FixedJiraClientFactory
extends AsynchronousJiraRestClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedJiraClientFactory.class);
    private static final String HEADER_CHARSET_PARAM = "http.protocol.element-charset";
    private static final String HEADER_CHARSET_VALUE = "ISO_8859_1";

    @Override
    public JiraRestClient create(URI serverUri, AuthenticationHandler authenticationHandler) {
        DisposableHttpClient httpClient = new AsynchronousHttpClientFactory().createClient(serverUri, authenticationHandler);
        ExtendedAsynchronousJiraRestClient client = new ExtendedAsynchronousJiraRestClient(serverUri, httpClient);
        AtlassianHttpClientDecorator lvl1Client = this.digThroughLayer1(client);
        DefaultHttpClient lvl2Client = this.digThroughLayer2(lvl1Client);
        DefaultHttpAsyncClient lvl3Client = this.dighThroughLayer3(lvl2Client);
        lvl3Client.getParams().setParameter(HEADER_CHARSET_PARAM, HEADER_CHARSET_VALUE);
        return client;
    }

    private AtlassianHttpClientDecorator digThroughLayer1(AsynchronousJiraRestClient client) {
        Field innerField = ReflectionUtils.findField(AsynchronousJiraRestClient.class, (String)"httpClient");
        ReflectionUtils.makeAccessible((Field)innerField);
        AtlassianHttpClientDecorator innerClient = (AtlassianHttpClientDecorator)ReflectionUtils.getField((Field)innerField, (Object)client);
        return innerClient;
    }

    private DefaultHttpClient digThroughLayer2(AtlassianHttpClientDecorator client) {
        Field innerField = ReflectionUtils.findField(AtlassianHttpClientDecorator.class, (String)"httpClient");
        ReflectionUtils.makeAccessible((Field)innerField);
        DefaultHttpClient innerClient = (DefaultHttpClient)ReflectionUtils.getField((Field)innerField, (Object)client);
        return innerClient;
    }

    private DefaultHttpAsyncClient dighThroughLayer3(DefaultHttpClient client) {
        Field innerField = ReflectionUtils.findField(DefaultHttpClient.class, (String)"nonCachingHttpClient");
        ReflectionUtils.makeAccessible((Field)innerField);
        DefaultHttpAsyncClient innerClient = (DefaultHttpAsyncClient)ReflectionUtils.getField((Field)innerField, (Object)client);
        return innerClient;
    }
}

