/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.squashtest.tm.api.security.acls.Permission;
import org.squashtest.tm.api.widget.InternationalizedMenuItem;
import org.squashtest.tm.api.widget.MenuItem;
import org.squashtest.tm.api.widget.TreeNodeType;
import org.squashtest.tm.api.widget.access.AccessRuleBuilder;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.plugin.jirasync.JIRASyncPlugin;
import org.squashtest.tm.plugin.jirasync.repository.PluginRequirementDao;
import org.squashtest.tm.plugin.jirasync.service.RequirementSynchronizationService;
import org.squashtest.tm.service.bugtracker.BugTrackerManagerService;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;

@Configuration(value="squash.tm.plugin.jirasync.conf")
@ComponentScan(basePackages={"org.squashtest.tm.plugin.jirasync"})
public class SpringConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringConfig.class);
    @Inject
    private PluginRequirementDao dao;
    @Inject
    private RequirementSynchronizationService requirementSynchronizationService;
    @Inject
    private InternationalizationHelper langHelper;
    @Inject
    private BugTrackerManagerService btService;

    @Bean(name={"squash.tm.plugin.jirasync"})
    public JIRASyncPlugin jiraReqPlugin() {
        JIRASyncPlugin plugin = new JIRASyncPlugin();
        plugin.setDao(this.dao);
        plugin.setRequirementSynchronizationService(this.requirementSynchronizationService);
        plugin.setLangHelper(this.langHelper);
        plugin.setBeanName("squash.tm.plugin.jirasync");
        plugin.setBtService(this.btService);
        plugin.setNameKey("henix.jirasync.plugin.name");
        plugin.setTypeKey("henix.jirasync.plugin.type");
        plugin.setDisplayWorkspace(WorkspaceType.CAMPAIGN_WORKSPACE);
        plugin.setWizardMenu(this.wizardItem());
        return plugin;
    }

    private MenuItem wizardItem() {
        InternationalizedMenuItem item = new InternationalizedMenuItem();
        item.setUrl("jirasync/exec-plan-designer");
        item.setAccessRule(AccessRuleBuilder.singleNodeSelection().nodePermission(TreeNodeType.CAMPAIGN, Permission.WRITE).or().nodePermission(TreeNodeType.ITERATION, Permission.WRITE).build());
        item.setTooltipKey("henix.jirasync.execplan.menu.tooltip");
        item.setLabelKey("henix.jirasync.execplan.menu.label");
        item.setMessageSource((MessageSource)this.langHelper);
        item.afterPropertiesSet();
        return item;
    }

    @Bean(name={"squash.tm.plugin.jirasync.mappings.valuefinders"})
    public Properties valuefindersMapping() throws IOException {
        return this.loadMapping("org/squashtest/tm/plugin/jirasync/jira-json-valuefinders.properties");
    }

    @Bean(name={"squash.tm.plugin.jirasync.mappings.parsers"})
    public Properties parsersMapping() throws IOException {
        return this.loadMapping("org/squashtest/tm/plugin/jirasync/jira-cf-parsers-mapping.properties");
    }

    @Bean(name={"squash.tm.plugin.jirasync.mappings.domain"})
    public Properties domainMapping() throws IOException {
        return this.loadMapping("org/squashtest/tm/plugin/jirasync/jira-cf-domain-mapping.properties");
    }

    private Properties loadMapping(String pptFile) throws IOException {
        try (InputStream pstream = null;){
            Properties properties = new Properties();
            ClassLoader cl = SpringConfig.class.getClassLoader();
            pstream = cl.getResourceAsStream(pptFile);
            properties.load(pstream);
            Properties properties2 = properties;
            return properties2;
        }
    }
}

