/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.concurrent.DelegatingSecurityContextRunnable;
import org.squashtest.tm.api.plugin.EntityReference;
import org.squashtest.tm.api.plugin.PluginValidationException;
import org.squashtest.tm.api.wizard.InternationalizedWorkspaceWizard;
import org.squashtest.tm.api.wizard.SynchronisationPlugin;
import org.squashtest.tm.domain.servers.AuthenticationPolicy;
import org.squashtest.tm.plugin.jirasync.domain.JiraRemoteSynchronisation;
import org.squashtest.tm.plugin.jirasync.repository.PluginRequirementDao;
import org.squashtest.tm.plugin.jirasync.service.RequirementSynchronizationService;
import org.squashtest.tm.service.bugtracker.BugTrackerManagerService;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;

public class JIRASyncPlugin
extends InternationalizedWorkspaceWizard
implements SynchronisationPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(JIRASyncPlugin.class);
    private static final String URL_TEMPLATE = "/jirasync/project/{projectId}/configuration";
    public static final String PLUGIN_ID = "squash.tm.plugin.jirasync";
    public static final String FIELD_MAPPING = "attributeMappings";
    public static final String VALUES_MAPPING = "valuesMapping";
    public static final String JIRA_TESTING_STATUS_FIELD = "jiraTestingStatusField";
    public static final String JIRA_REDACTION_PROGRESS_FIELD = "jiraRedactionProgressField";
    public static final String JIRA_VERIFICATION_PROGRESS_FIELD = "jiraVerificationProgressField";
    public static final String JIRA_VALIDATION_PROGRESS_FIELD = "jiraValidationProgressField";
    public static final String JIRA_REDACTION_RATIO_FIELD = "jiraRedactionRatioField";
    public static final String JIRA_VERIFICATION_RATIO_FIELD = "jiraVerificationRatioField";
    public static final String JIRA_VALIDATION_RATIO_FIELD = "jiraValidationRatioField";
    private PluginRequirementDao dao;
    private InternationalizationHelper langHelper;
    private RequirementSynchronizationService requirementSynchronizationService;
    private BugTrackerManagerService btService;

    public void setRequirementSynchronizationService(RequirementSynchronizationService requirementSynchronizationService) {
        this.requirementSynchronizationService = requirementSynchronizationService;
    }

    public void setDao(PluginRequirementDao dao) {
        this.dao = dao;
    }

    public void setLangHelper(InternationalizationHelper langHelper) {
        this.langHelper = langHelper;
    }

    public void setBtService(BugTrackerManagerService btService) {
        this.btService = btService;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        return map;
    }

    public void validate(EntityReference reference, Map<String, String> conf) throws PluginValidationException {
        throw new UnsupportedOperationException("This method is now deprecated and I won't support it");
    }

    public void validate(EntityReference reference) throws PluginValidationException {
        List bugtrackers = this.btService.findByKind("jira.rest");
        bugtrackers.addAll(this.btService.findByKind("jira.xsquash"));
        long count = bugtrackers.stream().filter(bugTracker -> bugTracker.getAuthenticationPolicy().equals((Object)AuthenticationPolicy.APP_LEVEL)).count();
        if (count == 0L) {
            throw new PluginValidationException("This plugin require an APP_LEVEL authentication JIRA bugtracker.");
        }
        List<JiraRemoteSynchronisation> synchronisations = this.dao.findJiraRemoteSyncForProject(reference.getId());
        if (synchronisations.isEmpty()) {
            throw new PluginValidationException("No remote sync for this project. Please create a new sync in conf screen");
        }
    }

    public String getConfigurationPath(EntityReference context) {
        Long id = context.getId();
        return URL_TEMPLATE.replace("{projectId}", id.toString());
    }

    public Runnable performSynchronisation() {
        Runnable runnable = () -> this.requirementSynchronizationService.performFullSynchronisation();
        return new DelegatingSecurityContextRunnable(runnable);
    }
}

