/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.codehaus.jackson.io;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import jirasync.org.codehaus.jackson.io.BaseReader;
import jirasync.org.codehaus.jackson.io.IOContext;

public final class UTF32Reader
extends BaseReader {
    final boolean mBigEndian;
    char mSurrogate = '\u0000';
    int mCharCount = 0;
    int mByteCount = 0;

    public UTF32Reader(IOContext ctxt, InputStream in, byte[] buf, int ptr, int len, boolean isBigEndian) {
        super(ctxt, in, buf, ptr, len);
        this.mBigEndian = isBigEndian;
    }

    public int read(char[] cbuf, int start, int len) throws IOException {
        if (this.mBuffer == null) {
            return -1;
        }
        if (len < 1) {
            return len;
        }
        if (start < 0 || start + len > cbuf.length) {
            this.reportBounds(cbuf, start, len);
        }
        len += start;
        int outPtr = start;
        if (this.mSurrogate != '\u0000') {
            cbuf[outPtr++] = this.mSurrogate;
            this.mSurrogate = '\u0000';
        } else {
            int left = this.mLength - this.mPtr;
            if (left < 4 && !this.loadMore(left)) {
                return -1;
            }
        }
        while (outPtr < len) {
            int ptr = this.mPtr;
            int ch = this.mBigEndian ? this.mBuffer[ptr] << 24 | (this.mBuffer[ptr + 1] & 0xFF) << 16 | (this.mBuffer[ptr + 2] & 0xFF) << 8 | this.mBuffer[ptr + 3] & 0xFF : this.mBuffer[ptr] & 0xFF | (this.mBuffer[ptr + 1] & 0xFF) << 8 | (this.mBuffer[ptr + 2] & 0xFF) << 16 | this.mBuffer[ptr + 3] << 24;
            this.mPtr += 4;
            if (ch > 65535) {
                if (ch > 0x10FFFF) {
                    this.reportInvalid(ch, outPtr - start, "(above " + Integer.toHexString(0x10FFFF) + ") ");
                }
                cbuf[outPtr++] = (char)(55296 + ((ch -= 65536) >> 10));
                ch = 0xDC00 | ch & 0x3FF;
                if (outPtr >= len) {
                    this.mSurrogate = (char)ch;
                    break;
                }
            }
            cbuf[outPtr++] = (char)ch;
            if (this.mPtr < this.mLength) continue;
            break;
        }
        len = outPtr - start;
        this.mCharCount += len;
        return len;
    }

    private void reportUnexpectedEOF(int gotBytes, int needed) throws IOException {
        int bytePos = this.mByteCount + gotBytes;
        int charPos = this.mCharCount;
        throw new CharConversionException("Unexpected EOF in the middle of a 4-byte UTF-32 char: got " + gotBytes + ", needed " + needed + ", at char #" + charPos + ", byte #" + bytePos + ")");
    }

    private void reportInvalid(int value, int offset, String msg) throws IOException {
        int bytePos = this.mByteCount + this.mPtr - 1;
        int charPos = this.mCharCount + offset;
        throw new CharConversionException("Invalid UTF-32 character 0x" + Integer.toHexString(value) + msg + " at char #" + charPos + ", byte #" + bytePos + ")");
    }

    private boolean loadMore(int available) throws IOException {
        int count;
        this.mByteCount += this.mLength - available;
        if (available > 0) {
            if (this.mPtr > 0) {
                for (int i = 0; i < available; ++i) {
                    this.mBuffer[i] = this.mBuffer[this.mPtr + i];
                }
                this.mPtr = 0;
            }
            this.mLength = available;
        } else {
            this.mPtr = 0;
            count = this.mIn.read(this.mBuffer);
            if (count < 1) {
                this.mLength = 0;
                if (count < 0) {
                    this.freeBuffers();
                    return false;
                }
                this.reportStrangeStream();
            }
            this.mLength = count;
        }
        while (this.mLength < 4) {
            count = this.mIn.read(this.mBuffer, this.mLength, this.mBuffer.length - this.mLength);
            if (count < 1) {
                if (count < 0) {
                    this.freeBuffers();
                    this.reportUnexpectedEOF(this.mLength, 4);
                }
                this.reportStrangeStream();
            }
            this.mLength += count;
        }
        return true;
    }
}

