/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.protocol;

import java.io.IOException;
import java.net.InetAddress;
import jirasync.org.apache.http.HttpConnection;
import jirasync.org.apache.http.HttpException;
import jirasync.org.apache.http.HttpHost;
import jirasync.org.apache.http.HttpInetConnection;
import jirasync.org.apache.http.HttpRequest;
import jirasync.org.apache.http.HttpRequestInterceptor;
import jirasync.org.apache.http.HttpVersion;
import jirasync.org.apache.http.ProtocolException;
import jirasync.org.apache.http.ProtocolVersion;
import jirasync.org.apache.http.annotation.Contract;
import jirasync.org.apache.http.annotation.ThreadingBehavior;
import jirasync.org.apache.http.protocol.HttpContext;
import jirasync.org.apache.http.protocol.HttpCoreContext;
import jirasync.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = corecontext.getTargetHost();
            if (targethost == null) {
                HttpConnection conn = corecontext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

