/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.nio.protocol;

import java.io.IOException;
import jirasync.org.apache.http.ConnectionReuseStrategy;
import jirasync.org.apache.http.HttpRequest;
import jirasync.org.apache.http.HttpResponse;
import jirasync.org.apache.http.annotation.Immutable;
import jirasync.org.apache.http.nio.NHttpConnection;
import jirasync.org.apache.http.nio.protocol.EventListener;
import jirasync.org.apache.http.nio.util.ByteBufferAllocator;
import jirasync.org.apache.http.params.HttpParams;
import jirasync.org.apache.http.protocol.HttpProcessor;

@Deprecated
@Immutable
public abstract class NHttpHandlerBase {
    protected static final String CONN_STATE = "http.nio.conn-state";
    protected final HttpProcessor httpProcessor;
    protected final ConnectionReuseStrategy connStrategy;
    protected final ByteBufferAllocator allocator;
    protected final HttpParams params;
    protected EventListener eventListener;

    public NHttpHandlerBase(HttpProcessor httpProcessor, ConnectionReuseStrategy connStrategy, ByteBufferAllocator allocator, HttpParams params) {
        if (httpProcessor == null) {
            throw new IllegalArgumentException("HTTP processor may not be null.");
        }
        if (connStrategy == null) {
            throw new IllegalArgumentException("Connection reuse strategy may not be null");
        }
        if (allocator == null) {
            throw new IllegalArgumentException("ByteBuffer allocator may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.httpProcessor = httpProcessor;
        this.connStrategy = connStrategy;
        this.allocator = allocator;
        this.params = params;
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    protected void closeConnection(NHttpConnection conn, Throwable cause) {
        try {
            conn.close();
        }
        catch (IOException ex) {
            try {
                conn.shutdown();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
    }

    protected void shutdownConnection(NHttpConnection conn, Throwable cause) {
        try {
            conn.shutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void handleTimeout(NHttpConnection conn) {
        try {
            if (conn.getStatus() == 0) {
                conn.close();
                if (conn.getStatus() == 1) {
                    conn.setSocketTimeout(250);
                }
                if (this.eventListener != null) {
                    this.eventListener.connectionTimeout(conn);
                }
            } else {
                conn.shutdown();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean canResponseHaveBody(HttpRequest request, HttpResponse response) {
        if (request != null && "HEAD".equalsIgnoreCase(request.getRequestLine().getMethod())) {
            return false;
        }
        int status = response.getStatusLine().getStatusCode();
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }
}

