/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.nio.entity;

import java.io.IOException;
import java.io.OutputStream;
import jirasync.org.apache.http.annotation.NotThreadSafe;
import jirasync.org.apache.http.nio.util.ContentOutputBuffer;

@NotThreadSafe
public class ContentOutputStream
extends OutputStream {
    private final ContentOutputBuffer buffer;

    public ContentOutputStream(ContentOutputBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("Output buffer may not be null");
        }
        this.buffer = buffer;
    }

    public void close() throws IOException {
        this.buffer.writeCompleted();
    }

    public void flush() throws IOException {
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.buffer.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        if (b == null) {
            return;
        }
        this.buffer.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        this.buffer.write(b);
    }
}

