/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.nio.client.methods;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.FileChannel;
import jirasync.org.apache.http.HttpEntity;
import jirasync.org.apache.http.HttpEntityEnclosingRequest;
import jirasync.org.apache.http.HttpException;
import jirasync.org.apache.http.HttpHost;
import jirasync.org.apache.http.HttpRequest;
import jirasync.org.apache.http.client.utils.URIUtils;
import jirasync.org.apache.http.entity.BasicHttpEntity;
import jirasync.org.apache.http.entity.ContentType;
import jirasync.org.apache.http.nio.ContentEncoder;
import jirasync.org.apache.http.nio.ContentEncoderChannel;
import jirasync.org.apache.http.nio.FileContentEncoder;
import jirasync.org.apache.http.nio.IOControl;
import jirasync.org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import jirasync.org.apache.http.protocol.HttpContext;

abstract class BaseZeroCopyRequestProducer
implements HttpAsyncRequestProducer {
    private final URI requestURI;
    private final File file;
    private final ContentType contentType;
    private FileChannel fileChannel;
    private long idx = -1L;

    protected BaseZeroCopyRequestProducer(URI requestURI, File file, ContentType contentType) {
        if (requestURI == null) {
            throw new IllegalArgumentException("Request URI may not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Source file may not be null");
        }
        this.requestURI = requestURI;
        this.file = file;
        this.contentType = contentType;
    }

    private void closeChannel() throws IOException {
        if (this.fileChannel != null) {
            this.fileChannel.close();
            this.fileChannel = null;
        }
    }

    protected abstract HttpEntityEnclosingRequest createRequest(URI var1, HttpEntity var2);

    public HttpRequest generateRequest() throws IOException, HttpException {
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setChunked(false);
        entity.setContentLength(this.file.length());
        if (this.contentType != null) {
            entity.setContentType(this.contentType.toString());
        }
        return this.createRequest(this.requestURI, entity);
    }

    public synchronized HttpHost getTarget() {
        return URIUtils.extractHost(this.requestURI);
    }

    public synchronized void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        long transferred;
        if (this.fileChannel == null) {
            FileInputStream in = new FileInputStream(this.file);
            this.fileChannel = in.getChannel();
            this.idx = 0L;
        }
        if ((transferred = encoder instanceof FileContentEncoder ? ((FileContentEncoder)encoder).transfer(this.fileChannel, this.idx, Integer.MAX_VALUE) : this.fileChannel.transferTo(this.idx, Integer.MAX_VALUE, new ContentEncoderChannel(encoder))) > 0L) {
            this.idx += transferred;
        }
        if (this.idx >= this.fileChannel.size()) {
            encoder.complete();
            this.closeChannel();
        }
    }

    public void requestCompleted(HttpContext context) {
    }

    public void failed(Exception ex) {
    }

    public boolean isRepeatable() {
        return true;
    }

    public synchronized void resetRequest() throws IOException {
        this.closeChannel();
    }

    public synchronized void close() throws IOException {
        this.closeChannel();
    }
}

