/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.impl.nio.client;

import jirasync.org.apache.http.HttpVersion;
import jirasync.org.apache.http.client.protocol.RequestAddCookies;
import jirasync.org.apache.http.client.protocol.RequestAuthCache;
import jirasync.org.apache.http.client.protocol.RequestClientConnControl;
import jirasync.org.apache.http.client.protocol.RequestDefaultHeaders;
import jirasync.org.apache.http.client.protocol.RequestProxyAuthentication;
import jirasync.org.apache.http.client.protocol.RequestTargetAuthentication;
import jirasync.org.apache.http.client.protocol.ResponseProcessCookies;
import jirasync.org.apache.http.impl.client.DefaultHttpClient;
import jirasync.org.apache.http.impl.nio.client.AbstractHttpAsyncClient;
import jirasync.org.apache.http.impl.nio.reactor.IOReactorConfig;
import jirasync.org.apache.http.nio.conn.ClientAsyncConnectionManager;
import jirasync.org.apache.http.nio.reactor.IOReactorException;
import jirasync.org.apache.http.params.HttpConnectionParams;
import jirasync.org.apache.http.params.HttpParams;
import jirasync.org.apache.http.params.HttpProtocolParams;
import jirasync.org.apache.http.params.SyncBasicHttpParams;
import jirasync.org.apache.http.protocol.BasicHttpProcessor;
import jirasync.org.apache.http.protocol.HTTP;
import jirasync.org.apache.http.protocol.RequestContent;
import jirasync.org.apache.http.protocol.RequestExpectContinue;
import jirasync.org.apache.http.protocol.RequestTargetHost;
import jirasync.org.apache.http.protocol.RequestUserAgent;
import jirasync.org.apache.http.util.VersionInfo;

public class DefaultHttpAsyncClient
extends AbstractHttpAsyncClient {
    public DefaultHttpAsyncClient(ClientAsyncConnectionManager connmgr) {
        super(connmgr);
    }

    public DefaultHttpAsyncClient(IOReactorConfig config) throws IOReactorException {
        super(config);
    }

    public DefaultHttpAsyncClient() throws IOReactorException {
        super(new IOReactorConfig());
    }

    protected HttpParams createHttpParams() {
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        DefaultHttpAsyncClient.setDefaultHttpParams(params);
        return params;
    }

    public static void setDefaultHttpParams(HttpParams params) {
        HttpProtocolParams.setVersion(params, HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset(params, HTTP.DEF_CONTENT_CHARSET.name());
        HttpConnectionParams.setTcpNoDelay(params, true);
        HttpConnectionParams.setSocketBufferSize(params, 8192);
        VersionInfo vi = VersionInfo.loadVersionInfo("jirasync.org.apache.http.nio.client", DefaultHttpClient.class.getClassLoader());
        String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
        HttpProtocolParams.setUserAgent(params, "Apache-HttpAsyncClient/" + release + " (java 1.5)");
    }

    protected BasicHttpProcessor createHttpProcessor() {
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor(new RequestDefaultHeaders());
        httpproc.addInterceptor(new RequestContent());
        httpproc.addInterceptor(new RequestTargetHost());
        httpproc.addInterceptor(new RequestClientConnControl());
        httpproc.addInterceptor(new RequestUserAgent());
        httpproc.addInterceptor(new RequestExpectContinue());
        httpproc.addInterceptor(new RequestAddCookies());
        httpproc.addInterceptor(new ResponseProcessCookies());
        httpproc.addInterceptor(new RequestAuthCache());
        httpproc.addInterceptor(new RequestTargetAuthentication());
        httpproc.addInterceptor(new RequestProxyAuthentication());
        return httpproc;
    }
}

