/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.impl.nio;

import javax.net.ssl.SSLContext;
import jirasync.org.apache.http.HttpResponseFactory;
import jirasync.org.apache.http.annotation.Immutable;
import jirasync.org.apache.http.impl.DefaultHttpResponseFactory;
import jirasync.org.apache.http.impl.nio.DefaultNHttpClientConnection;
import jirasync.org.apache.http.nio.NHttpConnectionFactory;
import jirasync.org.apache.http.nio.reactor.IOSession;
import jirasync.org.apache.http.nio.reactor.ssl.SSLIOSession;
import jirasync.org.apache.http.nio.reactor.ssl.SSLMode;
import jirasync.org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import jirasync.org.apache.http.nio.util.ByteBufferAllocator;
import jirasync.org.apache.http.nio.util.HeapByteBufferAllocator;
import jirasync.org.apache.http.params.HttpConnectionParams;
import jirasync.org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class SSLNHttpClientConnectionFactory
implements NHttpConnectionFactory<DefaultNHttpClientConnection> {
    private final HttpResponseFactory responseFactory;
    private final ByteBufferAllocator allocator;
    private final SSLContext sslcontext;
    private final SSLSetupHandler sslHandler;
    private final HttpParams params;

    public SSLNHttpClientConnectionFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        if (responseFactory == null) {
            throw new IllegalArgumentException("HTTP response factory may not be null");
        }
        if (allocator == null) {
            throw new IllegalArgumentException("Byte buffer allocator may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.sslcontext = sslcontext;
        this.sslHandler = sslHandler;
        this.responseFactory = responseFactory;
        this.allocator = allocator;
        this.params = params;
    }

    public SSLNHttpClientConnectionFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpParams params) {
        this(sslcontext, sslHandler, new DefaultHttpResponseFactory(), new HeapByteBufferAllocator(), params);
    }

    public SSLNHttpClientConnectionFactory(HttpParams params) {
        this(null, null, params);
    }

    private SSLContext getDefaultSSLContext() {
        SSLContext sslcontext;
        try {
            sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, null, null);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failure initializing default SSL context", ex);
        }
        return sslcontext;
    }

    protected DefaultNHttpClientConnection createConnection(IOSession session, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        return new DefaultNHttpClientConnection(session, responseFactory, allocator, params);
    }

    @Override
    public DefaultNHttpClientConnection createConnection(IOSession session) {
        SSLContext sslcontext = this.sslcontext != null ? this.sslcontext : this.getDefaultSSLContext();
        SSLIOSession ssliosession = new SSLIOSession(session, SSLMode.CLIENT, sslcontext, this.sslHandler);
        session.setAttribute("http.session.ssl", ssliosession);
        DefaultNHttpClientConnection conn = this.createConnection(ssliosession, this.responseFactory, this.allocator, this.params);
        int timeout = HttpConnectionParams.getSoTimeout(this.params);
        conn.setSocketTimeout(timeout);
        return conn;
    }
}

