/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.impl.nio;

import jirasync.org.apache.http.HttpRequestFactory;
import jirasync.org.apache.http.annotation.Immutable;
import jirasync.org.apache.http.impl.DefaultHttpRequestFactory;
import jirasync.org.apache.http.impl.nio.DefaultNHttpServerConnection;
import jirasync.org.apache.http.nio.NHttpConnectionFactory;
import jirasync.org.apache.http.nio.reactor.IOSession;
import jirasync.org.apache.http.nio.util.ByteBufferAllocator;
import jirasync.org.apache.http.nio.util.HeapByteBufferAllocator;
import jirasync.org.apache.http.params.HttpConnectionParams;
import jirasync.org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class DefaultNHttpServerConnectionFactory
implements NHttpConnectionFactory<DefaultNHttpServerConnection> {
    private final HttpRequestFactory requestFactory;
    private final ByteBufferAllocator allocator;
    private final HttpParams params;

    public DefaultNHttpServerConnectionFactory(HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        if (requestFactory == null) {
            throw new IllegalArgumentException("HTTP request factory may not be null");
        }
        if (allocator == null) {
            throw new IllegalArgumentException("Byte buffer allocator may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.requestFactory = requestFactory;
        this.allocator = allocator;
        this.params = params;
    }

    public DefaultNHttpServerConnectionFactory(HttpParams params) {
        this(new DefaultHttpRequestFactory(), new HeapByteBufferAllocator(), params);
    }

    protected DefaultNHttpServerConnection createConnection(IOSession session, HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        return new DefaultNHttpServerConnection(session, requestFactory, allocator, params);
    }

    @Override
    public DefaultNHttpServerConnection createConnection(IOSession session) {
        DefaultNHttpServerConnection conn = this.createConnection(session, this.requestFactory, this.allocator, this.params);
        int timeout = HttpConnectionParams.getSoTimeout(this.params);
        conn.setSocketTimeout(timeout);
        return conn;
    }
}

