/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.impl.nio;

import java.io.IOException;
import jirasync.org.apache.http.HttpEntity;
import jirasync.org.apache.http.HttpEntityEnclosingRequest;
import jirasync.org.apache.http.HttpException;
import jirasync.org.apache.http.HttpRequest;
import jirasync.org.apache.http.HttpRequestFactory;
import jirasync.org.apache.http.HttpResponse;
import jirasync.org.apache.http.annotation.NotThreadSafe;
import jirasync.org.apache.http.entity.ContentLengthStrategy;
import jirasync.org.apache.http.impl.entity.DisallowIdentityContentLengthStrategy;
import jirasync.org.apache.http.impl.entity.LaxContentLengthStrategy;
import jirasync.org.apache.http.impl.nio.NHttpConnectionBase;
import jirasync.org.apache.http.impl.nio.NHttpServerEventHandlerAdaptor;
import jirasync.org.apache.http.impl.nio.codecs.DefaultHttpRequestParser;
import jirasync.org.apache.http.impl.nio.codecs.DefaultHttpResponseWriter;
import jirasync.org.apache.http.nio.NHttpMessageParser;
import jirasync.org.apache.http.nio.NHttpMessageWriter;
import jirasync.org.apache.http.nio.NHttpServerEventHandler;
import jirasync.org.apache.http.nio.NHttpServerIOTarget;
import jirasync.org.apache.http.nio.NHttpServiceHandler;
import jirasync.org.apache.http.nio.reactor.IOSession;
import jirasync.org.apache.http.nio.reactor.SessionInputBuffer;
import jirasync.org.apache.http.nio.reactor.SessionOutputBuffer;
import jirasync.org.apache.http.nio.util.ByteBufferAllocator;
import jirasync.org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class DefaultNHttpServerConnection
extends NHttpConnectionBase
implements NHttpServerIOTarget {
    protected final NHttpMessageParser<HttpRequest> requestParser;
    protected final NHttpMessageWriter<HttpResponse> responseWriter;

    public DefaultNHttpServerConnection(IOSession session, HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        super(session, allocator, params);
        if (requestFactory == null) {
            throw new IllegalArgumentException("Request factory may not be null");
        }
        this.requestParser = this.createRequestParser(this.inbuf, requestFactory, params);
        this.responseWriter = this.createResponseWriter(this.outbuf, params);
    }

    @Override
    protected ContentLengthStrategy createIncomingContentStrategy() {
        return new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    }

    protected NHttpMessageParser<HttpRequest> createRequestParser(SessionInputBuffer buffer, HttpRequestFactory requestFactory, HttpParams params) {
        return new DefaultHttpRequestParser(buffer, null, requestFactory, params);
    }

    protected NHttpMessageWriter<HttpResponse> createResponseWriter(SessionOutputBuffer buffer, HttpParams params) {
        return new DefaultHttpResponseWriter(buffer, null, params);
    }

    protected void onRequestReceived(HttpRequest request) {
    }

    protected void onResponseSubmitted(HttpResponse response) {
    }

    @Override
    public void resetInput() {
        this.request = null;
        this.contentDecoder = null;
        this.requestParser.reset();
    }

    @Override
    public void resetOutput() {
        this.response = null;
        this.contentEncoder = null;
        this.responseWriter.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeInput(NHttpServerEventHandler handler) {
        if (this.status != 0) {
            this.session.clearEvent(1);
            return;
        }
        try {
            if (this.request == null) {
                int bytesRead;
                do {
                    if ((bytesRead = this.requestParser.fillBuffer(this.session.channel())) > 0) {
                        this.inTransportMetrics.incrementBytesTransferred(bytesRead);
                    }
                    this.request = this.requestParser.parse();
                } while (bytesRead > 0 && this.request == null);
                if (this.request != null) {
                    if (this.request instanceof HttpEntityEnclosingRequest) {
                        HttpEntity entity = this.prepareDecoder(this.request);
                        ((HttpEntityEnclosingRequest)this.request).setEntity(entity);
                    }
                    this.connMetrics.incrementRequestCount();
                    this.onRequestReceived(this.request);
                    handler.requestReceived(this);
                    if (this.contentDecoder == null) {
                        this.resetInput();
                    }
                }
                if (bytesRead == -1) {
                    handler.endOfInput(this);
                }
            }
            if (this.contentDecoder != null && (this.session.getEventMask() & 1) > 0) {
                handler.inputReady(this, this.contentDecoder);
                if (this.contentDecoder.isCompleted()) {
                    this.resetInput();
                }
            }
        }
        catch (HttpException ex) {
            this.resetInput();
            handler.exception(this, ex);
        }
        catch (Exception ex) {
            handler.exception(this, ex);
        }
        finally {
            this.hasBufferedInput = this.inbuf.hasData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceOutput(NHttpServerEventHandler handler) {
        try {
            int bytesWritten;
            if (this.outbuf.hasData() && (bytesWritten = this.outbuf.flush(this.session.channel())) > 0) {
                this.outTransportMetrics.incrementBytesTransferred(bytesWritten);
            }
            if (!this.outbuf.hasData()) {
                if (this.status == 1) {
                    this.session.close();
                    this.status = 2;
                    this.resetOutput();
                    return;
                }
                if (this.contentEncoder != null) {
                    handler.outputReady(this, this.contentEncoder);
                    if (this.contentEncoder.isCompleted()) {
                        this.resetOutput();
                    }
                }
                if (this.contentEncoder == null && !this.outbuf.hasData()) {
                    if (this.status == 1) {
                        this.session.close();
                        this.status = 2;
                    }
                    if (this.status != 2) {
                        this.session.clearEvent(4);
                        handler.responseReady(this);
                    }
                }
            }
        }
        catch (Exception ex) {
            handler.exception(this, ex);
        }
        finally {
            this.hasBufferedOutput = this.outbuf.hasData();
        }
    }

    @Override
    public void submitResponse(HttpResponse response) throws IOException, HttpException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        this.assertNotClosed();
        if (this.response != null) {
            throw new HttpException("Response already submitted");
        }
        this.onResponseSubmitted(response);
        this.responseWriter.write(response);
        this.hasBufferedOutput = this.outbuf.hasData();
        if (response.getStatusLine().getStatusCode() >= 200) {
            this.connMetrics.incrementResponseCount();
            if (response.getEntity() != null) {
                this.response = response;
                this.prepareEncoder(response);
            }
        }
        this.session.setEvent(4);
    }

    @Override
    public boolean isResponseSubmitted() {
        return this.response != null;
    }

    @Override
    public void consumeInput(NHttpServiceHandler handler) {
        this.consumeInput(new NHttpServerEventHandlerAdaptor(handler));
    }

    @Override
    public void produceOutput(NHttpServiceHandler handler) {
        this.produceOutput(new NHttpServerEventHandlerAdaptor(handler));
    }
}

