/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.impl.nio;

import jirasync.org.apache.http.HttpResponseFactory;
import jirasync.org.apache.http.annotation.Immutable;
import jirasync.org.apache.http.impl.DefaultHttpResponseFactory;
import jirasync.org.apache.http.impl.nio.DefaultNHttpClientConnection;
import jirasync.org.apache.http.nio.NHttpConnectionFactory;
import jirasync.org.apache.http.nio.reactor.IOSession;
import jirasync.org.apache.http.nio.util.ByteBufferAllocator;
import jirasync.org.apache.http.nio.util.HeapByteBufferAllocator;
import jirasync.org.apache.http.params.HttpConnectionParams;
import jirasync.org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class DefaultNHttpClientConnectionFactory
implements NHttpConnectionFactory<DefaultNHttpClientConnection> {
    private final HttpResponseFactory responseFactory;
    private final ByteBufferAllocator allocator;
    private final HttpParams params;

    public DefaultNHttpClientConnectionFactory(HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        if (responseFactory == null) {
            throw new IllegalArgumentException("HTTP response factory may not be null");
        }
        if (allocator == null) {
            throw new IllegalArgumentException("Byte buffer allocator may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.responseFactory = responseFactory;
        this.allocator = allocator;
        this.params = params;
    }

    public DefaultNHttpClientConnectionFactory(HttpParams params) {
        this(new DefaultHttpResponseFactory(), new HeapByteBufferAllocator(), params);
    }

    protected DefaultNHttpClientConnection createConnection(IOSession session, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        return new DefaultNHttpClientConnection(session, responseFactory, allocator, params);
    }

    @Override
    public DefaultNHttpClientConnection createConnection(IOSession session) {
        DefaultNHttpClientConnection conn = this.createConnection(session, this.responseFactory, this.allocator, this.params);
        int timeout = HttpConnectionParams.getSoTimeout(this.params);
        conn.setSocketTimeout(timeout);
        return conn;
    }
}

