/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.impl.nio;

import java.io.IOException;
import javax.net.ssl.SSLContext;
import jirasync.org.apache.http.annotation.Immutable;
import jirasync.org.apache.http.impl.nio.DefaultNHttpClientConnection;
import jirasync.org.apache.http.impl.nio.DefaultNHttpClientConnectionFactory;
import jirasync.org.apache.http.impl.nio.SSLNHttpClientConnectionFactory;
import jirasync.org.apache.http.impl.nio.reactor.AbstractIODispatch;
import jirasync.org.apache.http.nio.NHttpClientEventHandler;
import jirasync.org.apache.http.nio.NHttpConnectionFactory;
import jirasync.org.apache.http.nio.reactor.IOSession;
import jirasync.org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import jirasync.org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class DefaultHttpClientIODispatch
extends AbstractIODispatch<DefaultNHttpClientConnection> {
    private final NHttpClientEventHandler handler;
    private final NHttpConnectionFactory<DefaultNHttpClientConnection> connFactory;

    public DefaultHttpClientIODispatch(NHttpClientEventHandler handler, NHttpConnectionFactory<DefaultNHttpClientConnection> connFactory) {
        if (handler == null) {
            throw new IllegalArgumentException("HTTP client handler may not be null");
        }
        if (connFactory == null) {
            throw new IllegalArgumentException("HTTP client connection factory may not null");
        }
        this.handler = handler;
        this.connFactory = connFactory;
    }

    public DefaultHttpClientIODispatch(NHttpClientEventHandler handler, HttpParams params) {
        this(handler, new DefaultNHttpClientConnectionFactory(params));
    }

    public DefaultHttpClientIODispatch(NHttpClientEventHandler handler, SSLContext sslcontext, SSLSetupHandler sslHandler, HttpParams params) {
        this(handler, new SSLNHttpClientConnectionFactory(sslcontext, sslHandler, params));
    }

    public DefaultHttpClientIODispatch(NHttpClientEventHandler handler, SSLContext sslcontext, HttpParams params) {
        this(handler, sslcontext, null, params);
    }

    @Override
    protected DefaultNHttpClientConnection createConnection(IOSession session) {
        return this.connFactory.createConnection(session);
    }

    @Override
    protected void onConnected(DefaultNHttpClientConnection conn) {
        Object attachment = conn.getContext().getAttribute("http.session.attachment");
        try {
            this.handler.connected(conn, attachment);
        }
        catch (Exception ex) {
            this.handler.exception(conn, ex);
        }
    }

    @Override
    protected void onClosed(DefaultNHttpClientConnection conn) {
        this.handler.closed(conn);
    }

    @Override
    protected void onException(DefaultNHttpClientConnection conn, IOException ex) {
        this.handler.exception(conn, ex);
    }

    @Override
    protected void onInputReady(DefaultNHttpClientConnection conn) {
        conn.consumeInput(this.handler);
    }

    @Override
    protected void onOutputReady(DefaultNHttpClientConnection conn) {
        conn.produceOutput(this.handler);
    }

    @Override
    protected void onTimeout(DefaultNHttpClientConnection conn) {
        try {
            this.handler.timeout(conn);
        }
        catch (Exception ex) {
            this.handler.exception(conn, ex);
        }
    }
}

