/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.impl.entity;

import java.io.IOException;
import jirasync.org.apache.http.Header;
import jirasync.org.apache.http.HttpEntity;
import jirasync.org.apache.http.HttpException;
import jirasync.org.apache.http.HttpMessage;
import jirasync.org.apache.http.annotation.Contract;
import jirasync.org.apache.http.annotation.ThreadingBehavior;
import jirasync.org.apache.http.entity.BasicHttpEntity;
import jirasync.org.apache.http.entity.ContentLengthStrategy;
import jirasync.org.apache.http.impl.io.ChunkedInputStream;
import jirasync.org.apache.http.impl.io.ContentLengthInputStream;
import jirasync.org.apache.http.impl.io.IdentityInputStream;
import jirasync.org.apache.http.io.SessionInputBuffer;
import jirasync.org.apache.http.util.Args;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class EntityDeserializer {
    private final ContentLengthStrategy lenStrategy;

    public EntityDeserializer(ContentLengthStrategy lenStrategy) {
        this.lenStrategy = Args.notNull(lenStrategy, "Content length strategy");
    }

    protected BasicHttpEntity doDeserialize(SessionInputBuffer inbuffer, HttpMessage message) throws HttpException, IOException {
        Header contentEncodingHeader;
        BasicHttpEntity entity = new BasicHttpEntity();
        long len = this.lenStrategy.determineLength(message);
        if (len == -2L) {
            entity.setChunked(true);
            entity.setContentLength(-1L);
            entity.setContent(new ChunkedInputStream(inbuffer));
        } else if (len == -1L) {
            entity.setChunked(false);
            entity.setContentLength(-1L);
            entity.setContent(new IdentityInputStream(inbuffer));
        } else {
            entity.setChunked(false);
            entity.setContentLength(len);
            entity.setContent(new ContentLengthInputStream(inbuffer, len));
        }
        Header contentTypeHeader = message.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        if ((contentEncodingHeader = message.getFirstHeader("Content-Encoding")) != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        return entity;
    }

    public HttpEntity deserialize(SessionInputBuffer inbuffer, HttpMessage message) throws HttpException, IOException {
        Args.notNull(inbuffer, "Session input buffer");
        Args.notNull(message, "HTTP message");
        return this.doDeserialize(inbuffer, message);
    }
}

