/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.impl.client.cache;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.Set;
import jirasync.org.apache.http.annotation.ThreadSafe;
import jirasync.org.apache.http.client.cache.HttpCacheEntry;
import jirasync.org.apache.http.client.cache.HttpCacheStorage;
import jirasync.org.apache.http.client.cache.HttpCacheUpdateCallback;
import jirasync.org.apache.http.client.cache.Resource;
import jirasync.org.apache.http.impl.client.cache.CacheConfig;
import jirasync.org.apache.http.impl.client.cache.CacheMap;
import jirasync.org.apache.http.impl.client.cache.ResourceReference;

@ThreadSafe
public class ManagedHttpCacheStorage
implements HttpCacheStorage {
    private final CacheMap entries;
    private final ReferenceQueue<HttpCacheEntry> morque;
    private final Set<ResourceReference> resources;
    private volatile boolean shutdown;

    public ManagedHttpCacheStorage(CacheConfig config) {
        this.entries = new CacheMap(config.getMaxCacheEntries());
        this.morque = new ReferenceQueue();
        this.resources = new HashSet<ResourceReference>();
    }

    private void ensureValidState() throws IllegalStateException {
        if (this.shutdown) {
            throw new IllegalStateException("Cache has been shut down");
        }
    }

    private void keepResourceReference(HttpCacheEntry entry) {
        Resource resource = entry.getResource();
        if (resource != null) {
            ResourceReference ref = new ResourceReference(entry, this.morque);
            this.resources.add(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putEntry(String url, HttpCacheEntry entry) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL may not be null");
        }
        if (entry == null) {
            throw new IllegalArgumentException("Cache entry may not be null");
        }
        this.ensureValidState();
        ManagedHttpCacheStorage managedHttpCacheStorage = this;
        synchronized (managedHttpCacheStorage) {
            this.entries.put(url, entry);
            this.keepResourceReference(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpCacheEntry getEntry(String url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL may not be null");
        }
        this.ensureValidState();
        ManagedHttpCacheStorage managedHttpCacheStorage = this;
        synchronized (managedHttpCacheStorage) {
            return (HttpCacheEntry)this.entries.get(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(String url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL may not be null");
        }
        this.ensureValidState();
        ManagedHttpCacheStorage managedHttpCacheStorage = this;
        synchronized (managedHttpCacheStorage) {
            this.entries.remove(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntry(String url, HttpCacheUpdateCallback callback) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL may not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Callback may not be null");
        }
        this.ensureValidState();
        ManagedHttpCacheStorage managedHttpCacheStorage = this;
        synchronized (managedHttpCacheStorage) {
            HttpCacheEntry existing = (HttpCacheEntry)this.entries.get(url);
            HttpCacheEntry updated = callback.update(existing);
            this.entries.put(url, updated);
            if (existing != updated) {
                this.keepResourceReference(updated);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanResources() {
        ResourceReference ref;
        if (this.shutdown) {
            return;
        }
        while ((ref = (ResourceReference)this.morque.poll()) != null) {
            ManagedHttpCacheStorage managedHttpCacheStorage = this;
            synchronized (managedHttpCacheStorage) {
                this.resources.remove(ref);
            }
            ref.getResource().dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        ManagedHttpCacheStorage managedHttpCacheStorage = this;
        synchronized (managedHttpCacheStorage) {
            this.entries.clear();
            for (ResourceReference ref : this.resources) {
                ref.getResource().dispose();
            }
            this.resources.clear();
            while (this.morque.poll() != null) {
            }
        }
    }
}

