/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.impl.client.cache;

import java.io.IOException;
import jirasync.org.apache.commons.logging.Log;
import jirasync.org.apache.commons.logging.LogFactory;
import jirasync.org.apache.http.HttpHost;
import jirasync.org.apache.http.HttpRequest;
import jirasync.org.apache.http.HttpResponse;
import jirasync.org.apache.http.ProtocolException;
import jirasync.org.apache.http.client.cache.HttpCacheEntry;
import jirasync.org.apache.http.concurrent.FutureCallback;
import jirasync.org.apache.http.impl.client.cache.AsynchronousAsyncValidator;
import jirasync.org.apache.http.impl.client.cache.CachingHttpAsyncClient;
import jirasync.org.apache.http.protocol.HttpContext;

class AsynchronousAsyncValidationRequest
implements Runnable {
    private final AsynchronousAsyncValidator parent;
    private final CachingHttpAsyncClient cachingAsyncClient;
    private final HttpHost target;
    private final HttpRequest request;
    private final HttpContext context;
    private final HttpCacheEntry cacheEntry;
    private final String identifier;
    private final Log log = LogFactory.getLog(this.getClass());

    AsynchronousAsyncValidationRequest(AsynchronousAsyncValidator parent, CachingHttpAsyncClient cachingClient, HttpHost target, HttpRequest request, HttpContext context, HttpCacheEntry cacheEntry, String identifier) {
        this.parent = parent;
        this.cachingAsyncClient = cachingClient;
        this.target = target;
        this.request = request;
        this.context = context;
        this.cacheEntry = cacheEntry;
        this.identifier = identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.cachingAsyncClient.revalidateCacheEntry(this.target, this.request, this.context, this.cacheEntry, new FutureCallback<HttpResponse>(){

                @Override
                public void cancelled() {
                }

                @Override
                public void completed(HttpResponse httpResponse) {
                }

                @Override
                public void failed(Exception e) {
                    if (e instanceof IOException) {
                        AsynchronousAsyncValidationRequest.this.log.debug("Asynchronous revalidation failed due to exception: " + e);
                    }
                }
            });
        }
        catch (ProtocolException pe) {
            this.log.error("ProtocolException thrown during asynchronous revalidation: " + pe);
        }
        finally {
            this.parent.markComplete(this.identifier);
        }
    }

    String getIdentifier() {
        return this.identifier;
    }
}

